/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.io;

import com.jamesswafford.chess4j.ChessEngineApp;
import com.jamesswafford.chess4j.Color;
import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.board.Move;
import com.jamesswafford.chess4j.board.Undo;
import com.jamesswafford.chess4j.book.BookMove;
import com.jamesswafford.chess4j.eval.Eval;
import com.jamesswafford.chess4j.exceptions.IllegalMoveException;
import com.jamesswafford.chess4j.exceptions.ParseException;
import com.jamesswafford.chess4j.io.DrawBoard;
import com.jamesswafford.chess4j.io.FenParser;
import com.jamesswafford.chess4j.io.MoveParser;
import com.jamesswafford.chess4j.io.PGNGame;
import com.jamesswafford.chess4j.io.PGNIterator;
import com.jamesswafford.chess4j.io.PrintGameResult;
import com.jamesswafford.chess4j.search.Search;
import com.jamesswafford.chess4j.search.SearchIterator;
import com.jamesswafford.chess4j.utils.GameResult;
import com.jamesswafford.chess4j.utils.GameStatus;
import com.jamesswafford.chess4j.utils.GameStatusChecker;
import com.jamesswafford.chess4j.utils.Perft;
import eu.usrv.legacylootgames.chess.ChessEngineProxy;
import eu.usrv.yamcore.auxiliary.LogHelper;
import java.io.File;
import java.io.FileInputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class InputParser {
    private static final InputParser INSTANCE = new InputParser();
    private static final LogHelper mLog = new LogHelper("LootGames - ChessEngine");
    private boolean forceMode;
    private Thread searchThread;
    private Color engineColor;

    private InputParser() {
    }

    public static InputParser getInstance() {
        return INSTANCE;
    }

    public void parseCommand(String command) throws IllegalMoveException, ParseException {
        mLog.info((Object)("# parsing: " + command));
        String[] input = command.split("\\s+");
        String cmd = input[0];
        if (!("accepted".equals(cmd) || "analyze".equals(cmd) || "black".equals(cmd))) {
            if ("bk".equals(cmd)) {
                this.bk();
            } else if ("bkmoves".equals(cmd)) {
                this.bkmoves();
            } else if (!"computer".equals(cmd)) {
                if ("db".equals(cmd)) {
                    this.db();
                } else if (!"draw".equals(cmd)) {
                    if ("easy".equals(cmd)) {
                        SearchIterator.ponderEnabled = false;
                    } else if ("eval".equals(cmd)) {
                        this.eval();
                    } else if ("force".equals(cmd)) {
                        this.force();
                    } else if ("go".equals(cmd)) {
                        this.go();
                    } else if ("hard".equals(cmd)) {
                        SearchIterator.ponderEnabled = true;
                    } else if (!"hint".equals(cmd) && !"ics".equals(cmd)) {
                        if ("level".equals(cmd)) {
                            this.level(input);
                        } else if ("name".equals(cmd)) {
                            mLog.info((Object)("# opponent is: " + input[1]));
                        } else if ("new".equals(cmd)) {
                            this.newGame();
                        } else if ("nopost".equals(cmd)) {
                            SearchIterator.showThinking = false;
                        } else if (!"otim".equals(cmd)) {
                            if ("perft".equals(cmd)) {
                                this.perft(input);
                            } else if ("pgn2book".equals(cmd)) {
                                this.pgn2book(input);
                            } else if ("playother".equals(cmd)) {
                                this.playother();
                            } else if ("ping".equals(cmd)) {
                                this.ping(input);
                            } else if ("post".equals(cmd)) {
                                SearchIterator.showThinking = true;
                            } else if ("protover".equals(cmd)) {
                                this.protover(input);
                            } else if ("quit".equals(cmd)) {
                                this.quit();
                            } else if (!("random".equals(cmd) || "rating".equals(cmd) || "rejected".equals(cmd))) {
                                if ("remove".equals(cmd)) {
                                    this.remove();
                                } else if ("result".equals(cmd)) {
                                    this.result(input);
                                } else if ("sd".equals(cmd)) {
                                    this.sd(input);
                                } else if ("setboard".equals(cmd)) {
                                    this.setboard(input);
                                } else if (!"st".equals(cmd)) {
                                    if ("time".equals(cmd)) {
                                        this.time(input);
                                    } else if ("undo".equals(cmd)) {
                                        this.undo();
                                    } else if ("usermove".equals(cmd)) {
                                        this.usermove(input);
                                    } else if ("variant".equals(cmd)) {
                                        this.variant(input);
                                    } else if (!"white".equals(cmd) && !"xboard".equals(cmd)) {
                                        if ("?".equals(cmd)) {
                                            this.moveNow();
                                        } else {
                                            throw new ParseException("Invalid command: " + cmd);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void bk() {
        boolean bl = SearchIterator.useOpeningBook = !SearchIterator.useOpeningBook;
        if (SearchIterator.useOpeningBook) {
            mLog.info((Object)"\topening book on.\n\n");
        } else {
            mLog.info((Object)"\topening book off.\n\n");
        }
    }

    private void bkmoves() {
        List<BookMove> bookMoves = ChessEngineApp.getOpeningBook().getMoves(Board.INSTANCE);
        mLog.info((Object)"book moves:");
        for (BookMove bookMove : bookMoves) {
            mLog.info((Object)("\t" + bookMove));
        }
    }

    private void db() {
        DrawBoard.drawBoard(Board.INSTANCE);
    }

    private void eval() {
        int eval = Eval.eval(Board.INSTANCE);
        ChessEngineProxy.getInstance().publishAnswer("eval=" + eval);
    }

    private void force() {
        this.stopSearchThread();
        this.forceMode = true;
    }

    private void go() {
        this.stopSearchThread();
        this.forceMode = false;
        this.thinkAndMakeMove();
    }

    private void level(String[] input) {
        String mps = input[1];
        String base = input[2];
        Double increment = Double.valueOf(input[3]);
        mLog.debug((Object)("# level: " + mps + ", " + base + ", " + increment));
        increment = increment * 1000.0;
        mLog.debug((Object)("# increment: " + increment + " ms."));
        SearchIterator.incrementMS = increment.intValue();
    }

    private void moveNow() {
        if (!SearchIterator.isPondering()) {
            this.stopSearchThread();
        }
    }

    private void newGame() {
        this.stopSearchThread();
        this.forceMode = false;
        Board.INSTANCE.resetBoard();
        this.engineColor = Color.BLACK;
        SearchIterator.maxDepth = 0;
    }

    private void perft(String[] input) {
        int depth = Integer.valueOf(input[1]);
        DrawBoard.drawBoard(Board.INSTANCE);
        long start = System.currentTimeMillis();
        long nodes = Perft.perft(Board.INSTANCE, depth);
        long end = System.currentTimeMillis();
        if (end == start) {
            end = start + 1L;
        }
        DecimalFormat df = new DecimalFormat("0,000");
        mLog.info((Object)("# nodes: " + df.format(nodes)));
        mLog.info((Object)("# elapsed time: " + (end - start) + " ms"));
        mLog.info((Object)("# rate: " + df.format(nodes * 1000L / (end - start)) + " n/s\n"));
    }

    private void pgn2book(String[] input) {
        String fName = input[1];
        File f = new File(fName);
        if (f.exists()) {
            long startTime = System.currentTimeMillis();
            mLog.info((Object)("processing pgn: " + fName + " ..."));
            mLog.info((Object)"doing dry run...");
            try {
                int n = this.processPGNFile(f, true);
                mLog.info((Object)("\nadding " + n + " games to book..."));
                this.processPGNFile(f, false);
                DecimalFormat df = new DecimalFormat("0.00");
                long elapsed = System.currentTimeMillis() - startTime;
                mLog.info((Object)("\nfinished in " + df.format(Double.valueOf(elapsed) / 1000.0) + " seconds."));
                Board.INSTANCE.resetBoard();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            mLog.info((Object)("file " + fName + " not found."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processPGNFile(File f, boolean dryRun) throws Exception {
        int n = 0;
        try {
            PGNGame pgnGame;
            if (!dryRun) {
                ChessEngineApp.getOpeningBook().dropIndexes();
            }
            FileInputStream fis = new FileInputStream(f);
            PGNIterator it = new PGNIterator(fis);
            while ((pgnGame = it.next()) != null) {
                if (n % 1000 == 0) {
                    System.out.println(".");
                }
                if (!dryRun) {
                    ChessEngineApp.getOpeningBook().addToBook(pgnGame);
                }
                ++n;
            }
            fis.close();
        }
        finally {
            if (!dryRun) {
                ChessEngineApp.getOpeningBook().addIndexes();
            }
        }
        return n;
    }

    private void playother() {
    }

    private void ping(String[] input) {
        if (!SearchIterator.isPondering()) {
            this.stopSearchThread();
        }
        mLog.info((Object)("pong " + input[1]));
    }

    private void protover(String[] input) {
        Integer version = Integer.valueOf(input[1]);
        if (version < 2) {
            mLog.info((Object)"Error: invalid protocol version.");
            System.exit(1);
        }
        mLog.info((Object)"feature analyze=0 black=0 colors=0 ping=1 draw=0 debug=1 edit=0 ics=1");
        mLog.info((Object)"feature level=0 name=1 nps=0 memory=0 playother=0 pause=0 resume=0 reuse=1 san=0");
        mLog.info((Object)"feature setboard=1 sigint=0 sigterm=0 smp=0 st=0 time=1 usermove=1");
        mLog.info((Object)"feature white=0 variants=\"normal\" myname=\"chess4j\"");
        mLog.info((Object)"feature done=1");
    }

    private void quit() {
        this.stopSearchThread();
        mLog.info((Object)"bye...");
        System.exit(0);
    }

    private void remove() {
        this.stopSearchThread();
        Board.INSTANCE.undoLastMove();
        Board.INSTANCE.undoLastMove();
    }

    private void result(String[] input) {
        this.stopSearchThread();
        String result = input[1];
        GameResult gameResult = GameResult.UNKNOWN;
        if ("1-0".equals(result)) {
            gameResult = Color.WHITE.equals((Object)this.engineColor) ? GameResult.WIN : GameResult.LOSS;
        } else if ("0-1".equals(result)) {
            gameResult = Color.BLACK.equals((Object)this.engineColor) ? GameResult.WIN : GameResult.LOSS;
        } else if ("1/2-1/2".equals(result)) {
            gameResult = GameResult.DRAW;
        } else if ("*".equals(result)) {
            gameResult = GameResult.ADJOURNED;
        }
        mLog.info((Object)("# result : " + result + " : " + (Object)((Object)gameResult)));
        List<Undo> undos = Board.INSTANCE.getUndos();
        ArrayList<Move> gameMoves = new ArrayList<Move>();
        StringBuilder sb = new StringBuilder();
        for (Undo undo : undos) {
            gameMoves.add(undo.getMove());
            sb.append(undo.getMove().toString() + " ");
        }
        mLog.info((Object)("# game moves: " + sb));
        ChessEngineApp.getOpeningBook().learn(gameMoves, this.engineColor, gameResult);
    }

    private void sd(String[] input) {
        Integer depth = Integer.valueOf(input[1]);
        mLog.info((Object)("# setting depth to : " + depth));
        SearchIterator.maxDepth = depth;
    }

    private void setboard(String[] input) {
        StringBuilder fen = new StringBuilder();
        for (int i = 1; i < input.length; ++i) {
            if (i > 1) {
                fen.append(" ");
            }
            fen.append(input[i]);
        }
        try {
            FenParser.setPos(Board.INSTANCE, fen.toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        DrawBoard.drawBoard(Board.INSTANCE);
    }

    private void time(String[] input) {
        Integer time = Integer.valueOf(input[1]);
        time = time * 10;
        mLog.info((Object)("# MY TIME: " + time));
        SearchIterator.remainingTimeMS = time;
    }

    private void undo() {
        Board.INSTANCE.undoLastMove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void usermove(String[] input) throws IllegalMoveException, ParseException {
        String strMove = input[1];
        MoveParser mp = new MoveParser();
        Move mv = mp.parseMove(strMove, Board.INSTANCE);
        Board.INSTANCE.applyMove(mv);
        if (!this.forceMode) {
            boolean startNewSearch;
            boolean predicted = mv.equals(SearchIterator.getPonderMove());
            mLog.info((Object)("# pondering?: " + SearchIterator.isPondering() + ", predicted?: " + predicted));
            Object object = SearchIterator.ponderMutex;
            synchronized (object) {
                if (SearchIterator.isPondering() && predicted) {
                    SearchIterator.calculateSearchTimes();
                    SearchIterator.stopPondering();
                    startNewSearch = false;
                } else {
                    startNewSearch = true;
                }
            }
            if (startNewSearch) {
                this.stopSearchThread();
                this.thinkAndMakeMove();
            }
        }
    }

    private void variant(String[] input) {
        if (!"normal".equals(input[1])) {
            mLog.info((Object)"Error: unsupported variant.");
        }
    }

    private void stopSearchThread() {
        if (this.searchThread == null) {
            return;
        }
        try {
            SearchIterator.abortIterator = true;
            Search.abortSearch = true;
            this.searchThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void thinkAndMakeMove() {
        this.engineColor = Board.INSTANCE.getPlayerToMove();
        GameStatus gs = GameStatusChecker.getGameStatus();
        if (gs != GameStatus.INPROGRESS) {
            PrintGameResult.printResult(gs);
            return;
        }
        this.searchThread = SearchIterator.think();
    }
}

