/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.forge.event;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import java.util.EnumSet;
import java.util.HashSet;
import journeymap.client.Constants;
import journeymap.client.forge.event.EventHandlerManager;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.log.ChatLog;
import journeymap.client.model.Waypoint;
import journeymap.client.render.map.Tile;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.input.Keyboard;

public class KeyEventHandler
implements EventHandlerManager.EventHandler {
    public static void initKeyBindings() {
        Minecraft minecraft = Minecraft.func_71410_x();
        HashSet<String> keyDescs = new HashSet<String>();
        for (KeyBinding existing : minecraft.field_71474_y.field_74324_K) {
            try {
                if (existing == null || existing.func_151464_g() == null) continue;
                keyDescs.add(existing.func_151464_g());
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Unexpected error when checking existing keybinding : " + existing);
            }
        }
        for (KeyBinding kb : Constants.initKeybindings()) {
            try {
                if (!keyDescs.contains(kb.func_151464_g())) {
                    ClientRegistry.registerKeyBinding((KeyBinding)kb);
                    continue;
                }
                Journeymap.getLogger().warn("Avoided duplicate keybinding that was already registered: " + kb.func_151464_g());
            }
            catch (Throwable t) {
                ChatLog.announceError("Unexpected error when registering keybinding : " + kb);
            }
        }
    }

    public static boolean onKeypress(boolean minimapOnly) {
        boolean controlDown;
        Minecraft minecraft = Minecraft.func_71410_x();
        int i = Keyboard.getEventKey();
        boolean bl = controlDown = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        if (controlDown && Constants.isPressed(Constants.KB_MAP)) {
            UIManager.getInstance().toggleMinimap();
            return true;
        }
        if (controlDown && Constants.isPressed(Constants.KB_MAP_ZOOMIN)) {
            Tile.switchTileRenderType();
            return true;
        }
        if (controlDown && Constants.isPressed(Constants.KB_MAP_ZOOMOUT)) {
            Tile.switchTileDisplayQuality();
            return true;
        }
        if (Constants.isPressed(Constants.KB_MAP_ZOOMIN)) {
            MiniMap.state().zoomIn();
            return true;
        }
        if (Constants.isPressed(Constants.KB_MAP_ZOOMOUT)) {
            MiniMap.state().zoomOut();
            return true;
        }
        if (Constants.isPressed(Constants.KB_MAP_DAY) || Constants.isPressed(Constants.KB_MAP_NIGHT)) {
            MiniMap.state().toggleMapType();
            KeyBinding.func_74506_a();
            return true;
        }
        if (Constants.isPressed(Constants.KB_MINIMAP_PRESET)) {
            UIManager.getInstance().switchMiniMapPreset();
            return true;
        }
        if (controlDown && Constants.isPressed(Constants.KB_WAYPOINT)) {
            KeyBinding.func_74506_a();
            UIManager.getInstance().openWaypointManager(null, null);
            return true;
        }
        if (!minimapOnly) {
            if (Constants.KB_MAP.func_151468_f()) {
                if (ForgeHelper.INSTANCE.getClient().field_71462_r == null) {
                    UIManager.getInstance().openFullscreenMap();
                } else if (ForgeHelper.INSTANCE.getClient().field_71462_r instanceof Fullscreen) {
                    UIManager.getInstance().closeAll();
                }
                return true;
            }
            if (Constants.KB_WAYPOINT.func_151468_f()) {
                if (ForgeHelper.INSTANCE.getClient().field_71462_r == null) {
                    Minecraft mc = ForgeHelper.INSTANCE.getClient();
                    Waypoint waypoint = Waypoint.of((EntityPlayer)mc.field_71439_g);
                    UIManager.getInstance().openWaypointEditor(waypoint, true, null);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public EnumSet<EventHandlerManager.BusType> getBus() {
        return EnumSet.of(EventHandlerManager.BusType.FMLCommonHandlerBus);
    }

    @SubscribeEvent
    public void onKeyboardEvent(InputEvent.KeyInputEvent event) {
        KeyEventHandler.onKeypress(false);
    }
}

