/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.chunkcollision;

import net.malisis.core.asm.AsmHook;
import net.malisis.core.asm.AsmUtils;
import net.malisis.core.asm.MalisisClassTransformer;
import net.malisis.core.asm.mappings.McpFieldMapping;
import net.malisis.core.asm.mappings.McpMethodMapping;
import net.minecraft.entity.player.EntityPlayerMP;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ChunkCollisionTransformer
extends MalisisClassTransformer {
    EntityPlayerMP playerEntity;

    @Override
    public void registerHooks() {
        this.register(this.getBoundingBoxesHook());
        this.register(this.rayTraceHook());
        this.register(this.placeBlockHook());
        this.register(this.blockReachDistanceHook());
    }

    private AsmHook getBoundingBoxesHook() {
        McpMethodMapping onChunkLoad = new McpMethodMapping("getCollidingBoundingBoxes", "func_72945_a", "net.minecraft.world.World", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/AxisAlignedBB;)Ljava/util/List;");
        McpFieldMapping collidingBoundingBoxes = new McpFieldMapping("collidingBoundingBoxes", "field_72998_d", "net.minecraft.world.World", "Ljava/util/ArrayList;");
        AsmHook ah = new AsmHook(onChunkLoad);
        InsnList insert = new InsnList();
        insert.add((AbstractInsnNode)new MethodInsnNode(184, "net/malisis/core/util/chunkcollision/ChunkCollision", "get", "()Lnet/malisis/core/util/chunkcollision/ChunkCollision;"));
        insert.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insert.add((AbstractInsnNode)new VarInsnNode(25, 2));
        insert.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insert.add((AbstractInsnNode)collidingBoundingBoxes.getInsnNode(180));
        insert.add((AbstractInsnNode)new VarInsnNode(25, 1));
        insert.add((AbstractInsnNode)new MethodInsnNode(182, "net/malisis/core/util/chunkcollision/ChunkCollision", "getCollisionBoundingBoxes", "(Lnet/minecraft/world/World;Lnet/minecraft/util/AxisAlignedBB;Ljava/util/List;Lnet/minecraft/entity/Entity;)V"));
        InsnList match = new InsnList();
        match.add((AbstractInsnNode)new LdcInsnNode((Object)0.25));
        ah.jumpTo(match).jump(-1).insert(insert);
        return ah;
    }

    private AsmHook rayTraceHook() {
        McpMethodMapping func_147447_a = new McpMethodMapping("rayTraceBlocks", "func_147447_a", "net.minecraft.world.World", "(Lnet/minecraft/util/Vec3;Lnet/minecraft/util/Vec3;ZZZ)Lnet/minecraft/util/MovingObjectPosition;");
        AsmHook ah = new AsmHook(func_147447_a);
        InsnList setRayTraceInfos = new InsnList();
        setRayTraceInfos.add((AbstractInsnNode)new MethodInsnNode(184, "net/malisis/core/util/chunkcollision/ChunkCollision", "get", "()Lnet/malisis/core/util/chunkcollision/ChunkCollision;"));
        setRayTraceInfos.add((AbstractInsnNode)new VarInsnNode(25, 1));
        setRayTraceInfos.add((AbstractInsnNode)new VarInsnNode(25, 2));
        setRayTraceInfos.add((AbstractInsnNode)new MethodInsnNode(182, "net/malisis/core/util/chunkcollision/ChunkCollision", "setRayTraceInfos", "(Lnet/minecraft/util/Vec3;Lnet/minecraft/util/Vec3;)V"));
        InsnList returnMop = new InsnList();
        returnMop.add((AbstractInsnNode)new VarInsnNode(25, 14));
        returnMop.add((AbstractInsnNode)new InsnNode(176));
        InsnList insertMop = new InsnList();
        insertMop.add((AbstractInsnNode)new MethodInsnNode(184, "net/malisis/core/util/chunkcollision/ChunkCollision", "get", "()Lnet/malisis/core/util/chunkcollision/ChunkCollision;"));
        insertMop.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insertMop.add((AbstractInsnNode)new VarInsnNode(25, 14));
        insertMop.add((AbstractInsnNode)new MethodInsnNode(182, "net/malisis/core/util/chunkcollision/ChunkCollision", "getRayTraceResult", "(Lnet/minecraft/world/World;Lnet/minecraft/util/MovingObjectPosition;)Lnet/minecraft/util/MovingObjectPosition;"));
        insertMop.add((AbstractInsnNode)new VarInsnNode(58, 14));
        InsnList returnMop2OrNull = new InsnList();
        returnMop2OrNull.add((AbstractInsnNode)new VarInsnNode(21, 5));
        returnMop2OrNull.add((AbstractInsnNode)new JumpInsnNode(153, null));
        returnMop2OrNull.add((AbstractInsnNode)new VarInsnNode(25, 14));
        returnMop2OrNull.add((AbstractInsnNode)new JumpInsnNode(167, null));
        InsnList insertMop_2 = AsmUtils.cloneList(insertMop);
        InsnList returnMop1 = new InsnList();
        returnMop1.add((AbstractInsnNode)new VarInsnNode(25, 41));
        returnMop1.add((AbstractInsnNode)new InsnNode(176));
        InsnList insertMop1 = new InsnList();
        insertMop1.add((AbstractInsnNode)new MethodInsnNode(184, "net/malisis/core/util/chunkcollision/ChunkCollision", "get", "()Lnet/malisis/core/util/chunkcollision/ChunkCollision;"));
        insertMop1.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insertMop1.add((AbstractInsnNode)new VarInsnNode(25, 41));
        insertMop1.add((AbstractInsnNode)new MethodInsnNode(182, "net/malisis/core/util/chunkcollision/ChunkCollision", "getRayTraceResult", "(Lnet/minecraft/world/World;Lnet/minecraft/util/MovingObjectPosition;)Lnet/minecraft/util/MovingObjectPosition;"));
        insertMop1.add((AbstractInsnNode)new VarInsnNode(58, 41));
        InsnList insertMop_3 = AsmUtils.cloneList(insertMop);
        ah.insert(setRayTraceInfos).jumpTo(returnMop).insert(insertMop).jumpTo(returnMop2OrNull).insert(insertMop_2).jumpTo(returnMop1).insert(insertMop1).jumpTo(returnMop2OrNull).insert(insertMop_3);
        return ah;
    }

    private AsmHook placeBlockHook() {
        McpMethodMapping canPlaceEntityOnSide = new McpMethodMapping("onItemUse", "func_77648_a", "net/minecraft/item/ItemBlock", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;IIIIFFF)Z");
        McpMethodMapping getItemStackMetadata = new McpMethodMapping("getMetadata", "func_77960_j", "net/minecraft/item/ItemStack", "()I");
        McpMethodMapping getItemMetadata = new McpMethodMapping("getMetadata", "func_77647_b", "net/minecraft/item/ItemBlock", "(I)I");
        McpFieldMapping blockInstance = new McpFieldMapping("blockInstance", "field_150939_a", "net/minecraft/item/ItemBlock", "Lnet/minecraft/block/Block;");
        AsmHook ah = new AsmHook(canPlaceEntityOnSide);
        InsnList match = new InsnList();
        match.add((AbstractInsnNode)new VarInsnNode(25, 0));
        match.add((AbstractInsnNode)new VarInsnNode(25, 1));
        match.add((AbstractInsnNode)getItemStackMetadata.getInsnNode(182));
        match.add((AbstractInsnNode)getItemMetadata.getInsnNode(182));
        InsnList insert = new InsnList();
        LabelNode label = new LabelNode();
        insert.add((AbstractInsnNode)new MethodInsnNode(184, "net/malisis/core/util/chunkcollision/ChunkCollision", "get", "()Lnet/malisis/core/util/chunkcollision/ChunkCollision;"));
        insert.add((AbstractInsnNode)new VarInsnNode(25, 1));
        insert.add((AbstractInsnNode)new VarInsnNode(25, 2));
        insert.add((AbstractInsnNode)new VarInsnNode(25, 3));
        insert.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insert.add((AbstractInsnNode)blockInstance.getInsnNode(180));
        insert.add((AbstractInsnNode)new VarInsnNode(21, 4));
        insert.add((AbstractInsnNode)new VarInsnNode(21, 5));
        insert.add((AbstractInsnNode)new VarInsnNode(21, 6));
        insert.add((AbstractInsnNode)new VarInsnNode(21, 7));
        insert.add((AbstractInsnNode)new MethodInsnNode(182, "net/malisis/core/util/chunkcollision/ChunkCollision", "canPlaceBlockAt", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;Lnet/minecraft/block/Block;IIII)Z"));
        insert.add((AbstractInsnNode)new JumpInsnNode(154, label));
        insert.add((AbstractInsnNode)new InsnNode(3));
        insert.add((AbstractInsnNode)new InsnNode(172));
        insert.add((AbstractInsnNode)label);
        ah.jumpTo(match).insert(insert);
        return ah;
    }

    private AsmHook blockReachDistanceHook() {
        McpMethodMapping processPlayerDigging = new McpMethodMapping("processPlayerDigging", "func_147345_a", "net/minecraft/network/NetHandlerPlayServer", "(Lnet/minecraft/network/play/client/C07PacketPlayerDigging;)V");
        McpFieldMapping playerEntity = new McpFieldMapping("playerEntity", "field_147369_b", "net/minecraft/network/NetHandlerPlayServer", "Lnet/minecraft/entity/player/EntityPlayerMP;");
        McpFieldMapping worldObj = new McpFieldMapping("worldObj", "field_70170_p", "net/minecraft/entity/player/EntityPlayerMP", "Lnet/minecraft/world/World;");
        McpMethodMapping getBlock = new McpMethodMapping("getBlock", "func_147439_a", "net/minecraft/world/World", "(III)Lnet/minecraft/block/Block;");
        AsmHook ah = new AsmHook(processPlayerDigging);
        InsnList match = new InsnList();
        match.add((AbstractInsnNode)new InsnNode(107));
        match.add((AbstractInsnNode)new InsnNode(99));
        match.add((AbstractInsnNode)new VarInsnNode(57, 13));
        InsnList insert = new InsnList();
        LabelNode label = new LabelNode();
        insert.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insert.add((AbstractInsnNode)playerEntity.getInsnNode(180));
        insert.add((AbstractInsnNode)worldObj.getInsnNode(180));
        insert.add((AbstractInsnNode)new VarInsnNode(21, 4));
        insert.add((AbstractInsnNode)new VarInsnNode(21, 5));
        insert.add((AbstractInsnNode)new VarInsnNode(21, 6));
        insert.add((AbstractInsnNode)getBlock.getInsnNode(182));
        insert.add((AbstractInsnNode)new TypeInsnNode(193, "net/malisis/core/util/chunkcollision/IChunkCollidable"));
        insert.add((AbstractInsnNode)new JumpInsnNode(153, label));
        insert.add((AbstractInsnNode)new InsnNode(14));
        insert.add((AbstractInsnNode)new VarInsnNode(57, 13));
        insert.add((AbstractInsnNode)label);
        ah.jumpAfter(match).insert(insert);
        return ah;
    }
}

