/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon;

import java.util.HashMap;
import net.malisis.core.renderer.icon.MalisisIcon;
import net.minecraft.block.Block;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class MegaTextureIcon
extends MalisisIcon {
    private static HashMap<ForgeDirection, ForgeDirection[]> searchDirs = new HashMap();
    int baseX;
    int baseY;
    int baseZ;
    int numBlocks = -1;

    public MegaTextureIcon(String name) {
        super(name);
    }

    public MegaTextureIcon(String name, int numBlocks) {
        super(name);
        this.numBlocks = numBlocks;
    }

    public MegaTextureIcon(MalisisIcon icon) {
        super(icon);
    }

    public MegaTextureIcon(MalisisIcon icon, int numBlocks) {
        super(icon);
        this.numBlocks = numBlocks;
    }

    public IIcon getIcon(IBlockAccess world, Block block, int x, int y, int z, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        this.getBaseBlock(world, block, x, y, z, dir);
        return this.getIcon(x, y, z, dir);
    }

    private void getBaseBlock(IBlockAccess world, Block block, int x, int y, int z, ForgeDirection side) {
        this.baseX = x;
        this.baseY = y;
        this.baseZ = z;
        ForgeDirection[] dirs = searchDirs.get(side);
        if (dirs == null) {
            return;
        }
        for (ForgeDirection dir : dirs) {
            while (world.func_147439_a(this.baseX, this.baseY, this.baseZ) == block) {
                this.baseX += dir.offsetX;
                this.baseY += dir.offsetY;
                this.baseZ += dir.offsetZ;
            }
            dir = dir.getOpposite();
            this.baseX += dir.offsetX;
            this.baseY += dir.offsetY;
            this.baseZ += dir.offsetZ;
        }
    }

    private IIcon getIcon(int x, int y, int z, ForgeDirection dir) {
        if (this.numBlocks == -1) {
            int w = this.field_130223_c;
            if (this.field_147966_k) {
                w -= 16;
            }
            this.numBlocks = w / 16;
        }
        int u = 0;
        int v = (y - this.baseY) % this.numBlocks + 1;
        u = dir == ForgeDirection.NORTH || dir == ForgeDirection.SOUTH ? Math.abs(x - this.baseX) % this.numBlocks : Math.abs(z - this.baseZ) % this.numBlocks;
        float factor = 1.0f / (float)this.numBlocks;
        MalisisIcon icon = new MalisisIcon();
        icon.copyFrom(this);
        icon.clip((float)u * factor, 1.0f - (float)v * factor, factor, factor);
        return icon;
    }

    static {
        searchDirs.put(ForgeDirection.NORTH, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.EAST});
        searchDirs.put(ForgeDirection.SOUTH, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.WEST});
        searchDirs.put(ForgeDirection.EAST, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.SOUTH});
        searchDirs.put(ForgeDirection.WEST, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.NORTH});
    }
}

