/*
 * Decompiled with CFR 0.152.
 */
package tb.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockTBPlant
extends BlockBush
implements IGrowable {
    public int growthStages;
    public int growthDelay;
    public boolean requiresFarmland;
    public IIcon[] growthIcons;
    public ItemStack dropItem;
    public ItemStack dropSeed;

    public BlockTBPlant(int stages, int delay, boolean isCrop) {
        this.growthStages = stages;
        this.growthDelay = delay;
        this.requiresFarmland = isCrop;
        this.func_149675_a(true);
        float f = 0.5f;
        if (isCrop) {
            this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.25f, 0.5f + f);
        } else {
            this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.75f, 0.75f);
        }
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149779_h);
        this.func_149649_H();
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World w, int x, int y, int z) {
        return this.dropSeed != null ? this.dropSeed.func_77973_b() : Item.func_150898_a((Block)this);
    }

    protected boolean func_149854_a(Block b) {
        return this.requiresFarmland ? b == Blocks.field_150458_ak : true;
    }

    public void func_149674_a(World w, int x, int y, int z, Random rnd) {
        float f;
        int l;
        super.func_149674_a(w, x, y, z, rnd);
        if (w.func_72957_l(x, y + 1, z) >= 9 && (l = w.func_72805_g(x, y, z)) < this.growthStages && rnd.nextInt((int)((float)this.growthDelay / (f = this.calculateGrowth(w, x, y, z))) + 1) == 0) {
            w.func_72921_c(x, y, z, ++l, 2);
        }
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return this.requiresFarmland ? EnumPlantType.Crop : EnumPlantType.Plains;
    }

    private float calculateGrowth(World w, int x, int y, int z) {
        float f = 1.0f;
        Block block = w.func_147439_a(x, y, z - 1);
        Block block1 = w.func_147439_a(x, y, z + 1);
        Block block2 = w.func_147439_a(x - 1, y, z);
        Block block3 = w.func_147439_a(x + 1, y, z);
        Block block4 = w.func_147439_a(x - 1, y, z - 1);
        Block block5 = w.func_147439_a(x + 1, y, z - 1);
        Block block6 = w.func_147439_a(x + 1, y, z + 1);
        Block block7 = w.func_147439_a(x - 1, y, z + 1);
        boolean flag = block2 == this || block3 == this;
        boolean flag1 = block == this || block1 == this;
        boolean flag2 = block4 == this || block5 == this || block6 == this || block7 == this;
        for (int l = x - 1; l <= x + 1; ++l) {
            for (int i1 = z - 1; i1 <= z + 1; ++i1) {
                float f1 = 0.0f;
                if (w.func_147439_a(l, y - 1, i1).canSustainPlant((IBlockAccess)w, l, y - 1, i1, ForgeDirection.UP, (IPlantable)this)) {
                    f1 = 1.0f;
                    if (w.func_147439_a(l, y - 1, i1).isFertile(w, l, y - 1, i1)) {
                        f1 = 3.0f;
                    }
                }
                if (l != x || i1 != z) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        if (flag2 || flag && flag1) {
            f /= 2.0f;
        }
        return f;
    }

    public boolean func_149851_a(World w, int x, int y, int z, boolean remote) {
        return w.func_72805_g(x, y, z) < this.growthStages - 1;
    }

    public boolean func_149852_a(World w, Random r, int x, int y, int z) {
        return w.func_72957_l(x, y + 1, z) >= 9;
    }

    public void func_149853_b(World w, Random r, int x, int y, int z) {
        w.func_72921_c(x, y, z, Math.min(this.growthStages - 1, w.func_72805_g(x, y, z) + r.nextInt(3) + 1), 3);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.growthIcons = new IIcon[this.growthStages];
        for (int i = 0; i < this.growthStages; ++i) {
            this.growthIcons[i] = reg.func_94245_a(this.field_149768_d + "stage_" + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.growthIcons[meta >= this.growthIcons.length ? this.growthIcons.length - 1 : meta];
    }

    public int func_149645_b() {
        return this.requiresFarmland ? 6 : 1;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (metadata >= this.growthStages - 1) {
            for (int i = 0; i < 1 + world.field_73012_v.nextInt(fortune + 1); ++i) {
                if (world.field_73012_v.nextInt(this.growthStages) > metadata || this.dropItem == null) continue;
                ret.add(this.dropItem.func_77946_l());
            }
        }
        if (this.dropSeed != null) {
            ret.add(this.dropSeed.func_77946_l());
        }
        return ret;
    }
}

