/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.parser.xml;

import com.github.lunatrius.ingameinfo.Alignment;
import com.github.lunatrius.ingameinfo.parser.IParser;
import com.github.lunatrius.ingameinfo.reference.Reference;
import com.github.lunatrius.ingameinfo.value.Value;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlParser
implements IParser {
    private Document document;

    @Override
    public boolean load(InputStream inputStream) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            this.document = dBuilder.parse(inputStream);
            this.document.getDocumentElement().normalize();
        }
        catch (Exception e) {
            Reference.logger.fatal("Could not read xml configuration file!", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean parse(Map<Alignment, List<List<Value>>> format) {
        if (this.document == null) {
            return false;
        }
        Element documentElement = this.document.getDocumentElement();
        NodeList nodeListLines = documentElement.getChildNodes();
        for (int i = 0; i < nodeListLines.getLength(); ++i) {
            Alignment alignment;
            Element elementLines = this.getElement(nodeListLines.item(i), "lines");
            if (elementLines == null || (alignment = Alignment.parse(elementLines.getAttribute("at"))) == null) continue;
            format.put(alignment, this.getLines(elementLines));
        }
        return true;
    }

    private List<List<Value>> getLines(Element element) {
        ArrayList<List<Value>> listLines = new ArrayList<List<Value>>();
        NodeList nodeListLine = element.getChildNodes();
        for (int i = 0; i < nodeListLine.getLength(); ++i) {
            Element elementLine = this.getElement(nodeListLine.item(i), "line");
            if (elementLine == null) continue;
            listLines.add(this.getValues(elementLine));
        }
        return listLines;
    }

    private List<Value> getValues(Element element) {
        ArrayList<Value> values = new ArrayList<Value>();
        NodeList nodeListValues = element.getChildNodes();
        for (int i = 0; i < nodeListValues.getLength(); ++i) {
            String type;
            Value value;
            Element elementValue = this.getElement(nodeListValues.item(i));
            if (elementValue == null || !(value = Value.fromString(type = elementValue.getNodeName().equalsIgnoreCase("value") ? elementValue.getAttribute("type") : elementValue.getNodeName())).isValid()) continue;
            if (value.isSimple()) {
                value.setRawValue(elementValue.getTextContent(), false);
            } else {
                value.values.addAll(this.getValues(elementValue));
            }
            values.add(value);
        }
        return values;
    }

    private Element getElement(Node node) {
        if (node.getNodeType() == 1) {
            return (Element)node;
        }
        return null;
    }

    private Element getElement(Node node, String name) {
        Element element = this.getElement(node);
        if (element != null && element.getNodeName().equalsIgnoreCase(name)) {
            return element;
        }
        return null;
    }
}

