/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.gui.GuiScrollSlot;
import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.Button;
import codechicken.nei.ItemList;
import codechicken.nei.ItemPanel;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemsGrid;
import codechicken.nei.Label;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.TextField;
import codechicken.nei.Widget;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.util.NBTJson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.io.IOUtils;

public class PresetsWidget
extends Widget {
    protected static final FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
    protected static SubsetListBox listbox = new SubsetListBox();
    protected static File presetsDir;
    protected static boolean openListBox;
    protected static PresetTag edit;
    protected long lastclicktime;
    protected static MouseSelection mouseSelection;
    protected static final Button dropdown;
    protected static final Label selectedValue;
    protected static final TextField selectedDisplayName;
    protected static final Button selectedState;

    protected static void setEditedTag(PresetTag tag) {
        edit = tag;
        openListBox = false;
        selectedDisplayName.setText(tag != null ? tag.displayName : "");
        ItemList.updateFilter.restart();
    }

    public static void addTag(PresetTag tag) {
        PresetsWidget.addTag(tag, false);
    }

    public static void addTag(PresetTag tag, boolean sel) {
        listbox.addTag(tag, sel);
    }

    public static boolean inEditMode() {
        return edit != null;
    }

    public static boolean isHidden(ItemStack item) {
        if (edit != null) {
            if (mouseSelection != null && PresetsWidget.mouseSelection.items.contains(item)) {
                return PresetsWidget.mouseSelection.append != PresetsWidget.edit.whitelist;
            }
            return !edit.matches(item);
        }
        if (!listbox.getSelected().isEmpty()) {
            List<PresetTag> selected = listbox.getSelected();
            for (int idx = 0; idx < selected.size(); ++idx) {
                if (selected.get(idx).matches(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static void setHidden(ItemStack stack, boolean append) {
        if (edit == null) {
            return;
        }
        if (NEIClientUtils.shiftKey()) {
            ArrayList<ItemStack> items = ItemPanels.itemPanel.getItems();
            for (int i = 0; i < items.size(); ++i) {
                if (!stack.func_77973_b().equals(items.get(i).func_77973_b())) continue;
                PresetsWidget.hideItem(items.get(i), append);
            }
        } else if (NEIClientUtils.controlKey()) {
            String modId = PresetsWidget.getModId(stack);
            if (modId == null) {
                PresetsWidget.hideItem(stack, append);
            } else {
                ArrayList<ItemStack> items = ItemPanels.itemPanel.getItems();
                for (int i = 0; i < items.size(); ++i) {
                    String mod = PresetsWidget.getModId(items.get(i));
                    if (mod == null || !mod.equals(modId)) continue;
                    PresetsWidget.hideItem(items.get(i), append);
                }
            }
        } else {
            PresetsWidget.hideItem(stack, append);
        }
    }

    protected static void hideItem(ItemStack stack, boolean append) {
        String guid = StackInfo.getItemStackGUID(stack);
        if (append) {
            PresetsWidget.edit.items.add(guid);
        } else {
            PresetsWidget.edit.items.remove(guid);
        }
    }

    protected static String getModId(ItemStack stack) {
        try {
            return GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b()).modId;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void loadPresets(String worldPath) {
        File dir = new File(CommonUtils.getMinecraftDir(), "saves/NEI/" + worldPath);
        presetsDir = new File(CommonUtils.getMinecraftDir(), "saves/NEI/" + worldPath + "/presets");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!presetsDir.exists()) {
            presetsDir.mkdirs();
        }
        listbox = new SubsetListBox(presetsDir);
        edit = null;
        openListBox = false;
        selectedDisplayName.setText("");
        ItemList.updateFilter.restart();
    }

    @Override
    public void draw(int mx, int my) {
        if (edit != null) {
            PresetsWidget.selectedState.x = this.x;
            PresetsWidget.selectedState.y = this.y;
            PresetsWidget.selectedState.w = PresetsWidget.selectedState.h = this.h;
            selectedState.draw(mx, my);
            PresetsWidget.selectedDisplayName.y = this.y;
            PresetsWidget.selectedDisplayName.h = this.h;
            PresetsWidget.selectedDisplayName.x = PresetsWidget.selectedState.x + PresetsWidget.selectedState.w + 1;
            PresetsWidget.selectedDisplayName.w = this.w - this.h * 2 - 5;
            selectedDisplayName.draw(mx, my);
        } else {
            List<PresetTag> selected = listbox.getSelected();
            int size = selected.size();
            PresetsWidget.selectedValue.text = size > 1 ? NEIClientUtils.translate("presets.label.selected", size) : (size == 1 ? selected.get((int)0).displayName : "");
            PresetsWidget.selectedValue.y = this.y;
            PresetsWidget.selectedValue.h = this.h;
            PresetsWidget.selectedValue.w = this.w - this.h - 4;
            PresetsWidget.selectedValue.x = this.x;
            selectedValue.draw(mx, my);
        }
        PresetsWidget.dropdown.y = this.y;
        PresetsWidget.dropdown.w = PresetsWidget.dropdown.h = this.h;
        PresetsWidget.dropdown.x = this.x + this.w - PresetsWidget.dropdown.w;
        PresetsWidget.dropdown.state = edit != null || listbox.getNumSlots() == 0 ? 2 : 0;
        dropdown.draw(mx, my);
        if (openListBox) {
            int scrollbarWidth = listbox.hasScrollbar() ? PresetsWidget.listbox.scrollbarDim().width : 0;
            listbox.setSize(this.x, this.y + this.h + 1, this.w, Math.min((LayoutManager.searchField.y - this.h - this.y) / 18 * 18, listbox.contentHeight()));
            listbox.setMargins(0, 0, scrollbarWidth, 0);
            listbox.draw(mx, my, 0.0f);
        }
    }

    @Override
    public boolean contains(int px, int py) {
        return super.contains(px, py) || openListBox && listbox.contains(px, py);
    }

    @Override
    public boolean handleClick(int mx, int my, int button) {
        if (openListBox && listbox.contains(mx, my)) {
            listbox.mouseClicked(mx, my, button);
            return true;
        }
        if (edit != null) {
            if (selectedState.contains(mx, my)) {
                selectedState.handleClick(mx, my, button);
                return true;
            }
            if (selectedDisplayName.contains(mx, my)) {
                selectedDisplayName.handleClick(mx, my, button);
                return true;
            }
        } else {
            if (button == 0 && dropdown.contains(mx, my)) {
                openListBox = !openListBox;
                return true;
            }
            openListBox = false;
            if (button == 0 && selectedValue.contains(mx, my)) {
                List<PresetTag> selected;
                int size;
                if (System.currentTimeMillis() - this.lastclicktime < 400L && (size = (selected = listbox.getSelected()).size()) <= 1) {
                    PresetsWidget.setEditedTag(size == 1 ? selected.get(0).copy() : new PresetTag(""));
                }
                this.lastclicktime = System.currentTimeMillis();
            }
        }
        return this.contains(mx, my);
    }

    @Override
    public boolean handleClickExt(int mx, int my, int button) {
        ItemPanel.ItemPanelSlot slot;
        if (edit != null && mouseSelection == null && (slot = ItemPanels.itemPanel.getSlotMouseOver(mx, my)) != null && button != 2) {
            mouseSelection = new MouseSelection(slot.slotIndex, button == 0);
            return true;
        }
        return false;
    }

    @Override
    public boolean handleKeyPress(int keyID, char keyChar) {
        if (keyID == 1) {
            openListBox = false;
        }
        if (edit == null) {
            return false;
        }
        if (selectedDisplayName.focused() && (keyID == 28 || keyID == 156) && !selectedDisplayName.text().isEmpty()) {
            selectedDisplayName.handleKeyPress(keyID, keyChar);
            selectedDisplayName.setFocus(false);
            listbox.replaceSeleted(edit);
            PresetsWidget.setEditedTag(null);
            return true;
        }
        if (selectedDisplayName.focused()) {
            return selectedDisplayName.handleKeyPress(keyID, keyChar);
        }
        if (keyID == 1 && !(NEIClientUtils.mc().field_71462_r instanceof GuiRecipe)) {
            PresetsWidget.setEditedTag(null);
            return true;
        }
        return false;
    }

    @Override
    public void mouseDragged(int mx, int my, int button, long heldTime) {
        ItemPanel.ItemPanelSlot slot;
        if (openListBox) {
            listbox.mouseDragged(mx, my, button, heldTime);
        }
        if (edit != null && button != 2 && mouseSelection != null && (slot = ItemPanels.itemPanel.getSlotMouseOver(mx, my)) != null && slot.slotIndex != PresetsWidget.mouseSelection.endIndex) {
            ItemsGrid grid = ItemPanels.itemPanel.getGrid();
            PresetsWidget.mouseSelection.endIndex = slot.slotIndex;
            PresetsWidget.mouseSelection.items.clear();
            Rectangle4i rec = grid.getItemRect(slot.slotIndex);
            Rectangle4i sel = new Rectangle4i(Math.min(rec.x, PresetsWidget.mouseSelection.startX), Math.min(rec.y, PresetsWidget.mouseSelection.startY), Math.max(rec.x, PresetsWidget.mouseSelection.startX) - Math.min(rec.x, PresetsWidget.mouseSelection.startX), Math.max(rec.y, PresetsWidget.mouseSelection.startY) - Math.min(rec.y, PresetsWidget.mouseSelection.startY));
            for (int x = sel.x; x <= sel.x + sel.w; x += 18) {
                for (int y = sel.y; y <= sel.y + sel.h; y += 18) {
                    ItemStack stack = ItemPanels.itemPanel.getStackMouseOver(x, y);
                    if (stack == null) continue;
                    PresetsWidget.mouseSelection.items.add(stack);
                }
            }
        }
    }

    @Override
    public void mouseUp(int mx, int my, int button) {
        if (openListBox) {
            listbox.mouseMovedOrUp(mx, my, button);
        }
        if (edit != null && mouseSelection != null) {
            ItemPanel.ItemPanelSlot hoverSlot = ItemPanels.itemPanel.getSlotMouseOver(mx, my);
            if (hoverSlot != null && hoverSlot.slotIndex == PresetsWidget.mouseSelection.startIndex) {
                PresetsWidget.setHidden(hoverSlot.item, button == 0);
            } else if (!PresetsWidget.mouseSelection.items.isEmpty()) {
                for (ItemStack stack : PresetsWidget.mouseSelection.items) {
                    PresetsWidget.hideItem(stack, PresetsWidget.mouseSelection.append);
                }
            }
            mouseSelection = null;
        }
    }

    @Override
    public boolean onMouseWheel(int i, int mx, int my) {
        if (openListBox && listbox.hasScrollbar() && listbox.contains(mx, my)) {
            listbox.scroll(-i);
            return true;
        }
        return false;
    }

    @Override
    public void onGuiClick(int mx, int my) {
        if (!this.contains(mx, my)) {
            openListBox = false;
        }
        selectedDisplayName.onGuiClick(mx, my);
    }

    @Override
    public List<String> handleTooltip(int mx, int my, List<String> tooltip) {
        if (edit != null) {
            if (selectedState.contains(mx, my)) {
                return selectedState.handleTooltip(mx, my, tooltip);
            }
            if (selectedDisplayName.contains(mx, my)) {
                return selectedDisplayName.handleTooltip(mx, my, tooltip);
            }
        } else if (selectedValue.contains(mx, my)) {
            return selectedValue.handleTooltip(mx, my, tooltip);
        }
        return tooltip;
    }

    public static boolean matches(ItemStack stack) {
        if (edit != null) {
            return true;
        }
        List<PresetTag> selected = listbox.getSelected();
        for (int idx = 0; idx < selected.size(); ++idx) {
            if (selected.get(idx).matches(stack)) continue;
            return false;
        }
        return true;
    }

    static {
        openListBox = false;
        dropdown = new Button(){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    openListBox = !openListBox;
                    return true;
                }
                return false;
            }

            @Override
            public String getRenderLabel() {
                return "...";
            }
        };
        selectedValue = new Label("", false){

            @Override
            public void draw(int mousex, int mousey) {
                String text = NEIClientUtils.cropText(fontRenderer, this.text, this.w);
                if (text.equals(this.text)) {
                    GuiDraw.drawString((String)text, (int)(this.x + this.w - fontRenderer.func_78256_a(text)), (int)(this.y + (this.h - 8) / 2), (int)this.colour);
                } else {
                    GuiDraw.drawString((String)text, (int)this.x, (int)(this.y + (this.h - 8) / 2), (int)this.colour);
                }
            }

            @Override
            public List<String> handleTooltip(int mx, int my, List<String> tooltip) {
                if (this.contains(mx, my) && listbox.getSelected().size() <= 1) {
                    tooltip.add(NEIClientUtils.translate("presets.label.tooltip", new Object[0]));
                }
                return tooltip;
            }
        };
        selectedDisplayName = new TextField(""){

            @Override
            public void onTextChange(String oldText) {
                if (edit != null) {
                    PresetsWidget.edit.displayName = this.text();
                }
            }

            @Override
            public void draw(int mousex, int mousey) {
                super.draw(mousex, mousey);
                if (this.text().isEmpty()) {
                    GuiDraw.drawGradientRect((int)(this.x - 1), (int)(this.y - 1), (int)1, (int)(this.h + 2), (int)-3394816, (int)-3394816);
                    GuiDraw.drawGradientRect((int)(this.x - 1), (int)(this.y - 1), (int)(this.w + 2), (int)1, (int)-3394816, (int)-3394816);
                    GuiDraw.drawGradientRect((int)(this.x + this.w), (int)(this.y - 1), (int)1, (int)(this.h + 2), (int)-3394816, (int)-3394816);
                    GuiDraw.drawGradientRect((int)(this.x - 1), (int)(this.y + this.h), (int)(this.w + 2), (int)1, (int)-3394816, (int)-3394816);
                }
            }

            @Override
            public List<String> handleTooltip(int mx, int my, List<String> tooltip) {
                if (this.contains(mx, my) && listbox.getSelected().size() <= 1) {
                    tooltip.add(NEIClientUtils.translate("presets.textfield.tooltip.1", new Object[0]));
                    tooltip.add(NEIClientUtils.translate("presets.textfield.tooltip.2", new Object[0]));
                }
                return tooltip;
            }
        };
        selectedState = new Button("B"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick && edit != null) {
                    PresetsWidget.edit.whitelist = !PresetsWidget.edit.whitelist;
                    return true;
                }
                return false;
            }

            @Override
            public String getRenderLabel() {
                return edit != null && PresetsWidget.edit.whitelist ? NEIClientUtils.translate("presets.whitelist.label", new Object[0]) : NEIClientUtils.translate("presets.blacklist.label", new Object[0]);
            }

            @Override
            public void addTooltips(List<String> tooltip) {
                if (edit != null) {
                    tooltip.add(PresetsWidget.edit.whitelist ? NEIClientUtils.translate("presets.whitelist.tooltip", new Object[0]) : NEIClientUtils.translate("presets.blacklist.tooltip", new Object[0]));
                }
            }
        };
    }

    protected static class MouseSelection {
        public int startX = -1;
        public int startY = -1;
        public int startIndex = -1;
        public int endIndex = -1;
        public HashSet<ItemStack> items = new HashSet();
        public boolean append = true;

        public MouseSelection(int slotIndex, boolean append) {
            ItemsGrid grid = ItemPanels.itemPanel.getGrid();
            Rectangle4i rec = grid.getItemRect(slotIndex);
            this.append = append;
            this.endIndex = slotIndex;
            this.startIndex = slotIndex;
            this.startX = rec.x;
            this.startY = rec.y;
        }
    }

    protected static class SubsetListBox
    extends GuiScrollSlot {
        protected final List<PresetTag> presets = new ArrayList<PresetTag>();
        protected final List<PresetTag> selected = new ArrayList<PresetTag>();
        protected int lastSelectedIndex = 0;

        public SubsetListBox(File presetsDir) {
            super(0, 0, 0, 0);
            this.setSmoothScroll(false);
            try {
                this.presets.addAll((Collection)((ForkJoinTask)ItemList.forkJoinPool.submit(() -> Arrays.asList(presetsDir.listFiles()).parallelStream().map(f -> PresetTag.loadFromFile(f)).filter(p -> p != null).collect(Collectors.toCollection(ArrayList::new)))).get());
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                return;
            }
            this.selected.addAll(this.loadSelFromFile(presetsDir, this.presets));
            this.sort();
        }

        public SubsetListBox() {
            super(0, 0, 0, 0);
            this.setSmoothScroll(false);
        }

        public void addTag(PresetTag tag, boolean sel) {
            this.presets.add(tag);
            if (sel) {
                this.selected.add(tag);
            }
        }

        protected List<PresetTag> getPresets() {
            return this.presets;
        }

        protected List<PresetTag> getSelected() {
            return this.selected;
        }

        public void replaceSeleted(PresetTag tag) {
            if (this.selected.size() == 1) {
                this.selected.get(0).deleteFile();
                this.presets.set(this.presets.indexOf(this.selected.get(0)), tag);
                this.selected.set(0, tag);
            } else {
                this.presets.add(tag);
                this.selected.add(tag);
            }
            tag.saveToFile();
            this.saveSelToFile();
            this.sort();
        }

        public void sort() {
            this.presets.sort((o1, o2) -> o1.displayName.compareTo(o2.displayName));
        }

        public void clear() {
            this.presets.clear();
            this.selected.clear();
        }

        public int getSlotHeight(int slot) {
            return 18;
        }

        protected int getNumSlots() {
            return this.presets.size();
        }

        protected void slotClicked(int slot, int button, int mx, int my, int count) {
            if (slot >= this.presets.size()) {
                return;
            }
            PresetTag tag = this.presets.get(slot);
            int width = this.windowBounds().width;
            Rectangle4i direction = new Rectangle4i(0, 0, 18, 18);
            Rectangle4i delete = new Rectangle4i(width - 18, 0, 18, 18);
            Rectangle4i option = new Rectangle4i(18, 0, width - 18 - 18, 18);
            if (option.contains(mx, my)) {
                boolean sel = this.selected.contains(tag);
                if (NEIClientUtils.controlKey()) {
                    if (sel) {
                        this.selected.remove(tag);
                    } else {
                        this.selected.add(tag);
                    }
                } else if (NEIClientUtils.shiftKey()) {
                    this.selected.clear();
                    for (int i = Math.min(this.lastSelectedIndex, slot); i <= Math.max(this.lastSelectedIndex, slot); ++i) {
                        if (this.selected.contains(this.presets.get(i))) continue;
                        this.selected.add(this.presets.get(i));
                    }
                } else {
                    int size = this.selected.size();
                    this.selected.clear();
                    if (!sel || size > 1) {
                        this.selected.add(tag);
                    }
                }
                if (this.selected.isEmpty()) {
                    this.lastSelectedIndex = 0;
                } else if (!NEIClientUtils.shiftKey()) {
                    this.lastSelectedIndex = slot;
                }
            } else if (delete.contains(mx, my)) {
                this.presets.remove(tag);
                this.selected.remove(tag);
                tag.deleteFile();
            } else if (direction.contains(mx, my)) {
                tag.whitelist = !tag.whitelist;
                tag.saveToFile();
            }
            this.saveSelToFile();
            edit = null;
            openListBox = !this.presets.isEmpty() && (NEIClientUtils.controlKey() || NEIClientUtils.shiftKey() || !option.contains(mx, my));
            ItemList.updateFilter.restart();
        }

        protected void drawSlot(int slot, int x, int y, int mx, int my, float frame) {
            if (slot >= this.presets.size()) {
                return;
            }
            int width = this.windowBounds().width;
            Rectangle4i direction = new Rectangle4i(x, y, 18, 18);
            Rectangle4i delete = new Rectangle4i(x + width - 18, y, 18, 18);
            Rectangle4i option = new Rectangle4i(x + 18, y, width - 18 - 18, 18);
            PresetTag tag = this.presets.get(slot);
            int optionState = this.selected.contains(tag) ? 0 : (option.contains(x + mx, y + my) ? 1 : 2);
            int directionState = direction.contains(x + mx, y + my) ? 1 : 2;
            int deleteState = delete.contains(x + mx, y + my) ? 1 : 2;
            String displayName = NEIClientUtils.cropText(fontRenderer, tag.displayName, option.w - 6);
            String dirName = tag.whitelist ? NEIClientUtils.translate("presets.whitelist.label", new Object[0]) : NEIClientUtils.translate("presets.blacklist.label", new Object[0]);
            LayoutManager.getLayoutStyle().drawSubsetTag(null, direction.x, direction.y, direction.w, direction.h, directionState, false);
            GuiDraw.drawString((String)dirName, (int)(direction.x + 6), (int)(direction.y + 5), (int)(directionState == 2 ? -2039584 : 0xFFFFA0));
            LayoutManager.getLayoutStyle().drawSubsetTag(null, option.x, option.y, option.w, option.h, optionState, false);
            GuiDraw.drawString((String)displayName, (int)(option.x + 3), (int)(option.y + 5), (int)(optionState == 2 ? -2039584 : 0xFFFFA0));
            LayoutManager.getLayoutStyle().drawSubsetTag(null, delete.x, delete.y, delete.w, delete.h, deleteState, false);
            GuiDraw.drawString((String)"\u2715", (int)(delete.x + 6), (int)(delete.y + 5), (int)(deleteState == 2 ? -2039584 : 0x601010));
        }

        public void drawOverlay(float frame) {
        }

        public void drawBackground(float frame) {
            SubsetListBox.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-14671840);
        }

        public void drawScrollbar(float frame) {
            if (this.hasScrollbar()) {
                super.drawScrollbar(frame);
            }
        }

        public int scrollbarGuideAlignment() {
            return 0;
        }

        protected List<PresetTag> loadSelFromFile(File presetsDir, List<PresetTag> presets) {
            File file = new File(presetsDir, "selected.ini");
            ArrayList<PresetTag> selected = new ArrayList<PresetTag>();
            if (file.exists()) {
                try {
                    List itemStrings;
                    try {
                        FileInputStream input = new FileInputStream(file);
                        Iterator iterator = null;
                        try {
                            NEIClientConfig.logger.info("Loading presets selected from file {}", new Object[]{file});
                            itemStrings = IOUtils.readLines((InputStream)input, (String)"UTF-8");
                        }
                        catch (Throwable throwable) {
                            iterator = throwable;
                            throw throwable;
                        }
                        finally {
                            if (input != null) {
                                if (iterator != null) {
                                    try {
                                        input.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)((Object)iterator)).addSuppressed(throwable);
                                    }
                                } else {
                                    input.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        NEIClientConfig.logger.error("Failed to load presets selected from file {}", new Object[]{file, e});
                        return selected;
                    }
                    HashMap<String, PresetTag> map = new HashMap<String, PresetTag>();
                    for (PresetTag tag : presets) {
                        map.put(tag.filename, tag);
                    }
                    for (String filename : itemStrings) {
                        if (!map.containsKey(filename)) continue;
                        selected.add((PresetTag)map.get(filename));
                    }
                }
                catch (Throwable th) {
                    NEIClientConfig.logger.error("Failed to load presets selected from file", new Object[]{file});
                }
            }
            return selected;
        }

        public void saveSelToFile() {
            File file = new File(presetsDir, "selected.ini");
            ArrayList<String> list = new ArrayList<String>();
            for (PresetTag tag : this.selected) {
                list.add(tag.filename);
            }
            try (FileOutputStream output = new FileOutputStream(file);){
                IOUtils.writeLines(list, (String)"\n", (OutputStream)output, (String)"UTF-8");
            }
            catch (IOException e) {
                NEIClientConfig.logger.error("Filed to save presets selected list to file {}", new Object[]{file, e});
            }
        }
    }

    public static class PresetTag
    implements ItemFilter {
        public String filename = null;
        public String displayName = "";
        public boolean whitelist = true;
        public HashSet<String> items;

        public PresetTag(String displayName) {
            this(displayName, new HashSet<String>(), false, null);
        }

        public PresetTag(String displayName, HashSet<String> items) {
            this(displayName, items, true, null);
        }

        public PresetTag(String displayName, HashSet<String> items, boolean whitelist, String filename) {
            this.displayName = displayName;
            this.items = items != null ? items : new HashSet();
            this.whitelist = whitelist;
            this.filename = filename;
        }

        @Override
        public boolean matches(ItemStack stack) {
            return this.items.contains(StackInfo.getItemStackGUID(stack)) == this.whitelist;
        }

        public static PresetTag loadFromFile(File file) {
            if (!file.isFile() || !file.exists() || file.getName().equals("selected.ini")) {
                return null;
            }
            try {
                List itemStrings;
                try (FileInputStream input = new FileInputStream(file);){
                    NEIClientConfig.logger.info("Loading presets from file {}", new Object[]{file});
                    itemStrings = IOUtils.readLines((InputStream)input, (String)"UTF-8");
                }
                catch (IOException e) {
                    NEIClientConfig.logger.error("Failed to load presets from file {}", new Object[]{file, e});
                    return null;
                }
                JsonParser parser = new JsonParser();
                JsonObject metaObject = parser.parse((String)itemStrings.remove(0)).getAsJsonObject();
                String displayName = metaObject.get("displayName").getAsString();
                boolean whitelist = metaObject.get("whitelist").getAsBoolean();
                HashSet<String> items = new HashSet<String>();
                for (String itemStr : itemStrings) {
                    items.add(itemStr);
                }
                return new PresetTag(displayName, items, whitelist, file.getName());
            }
            catch (Throwable th) {
                NEIClientConfig.logger.error("Failed to load presets ItemStack from file", new Object[]{file});
                return null;
            }
        }

        public void deleteFile() {
            if (presetsDir == null || this.filename == null) {
                return;
            }
            File tagFile = new File(presetsDir, this.filename);
            if (tagFile.exists()) {
                tagFile.delete();
            }
        }

        public void saveToFile() {
            if (presetsDir == null) {
                return;
            }
            if (this.filename == null) {
                String sanitized = this.displayName.replaceAll("[^_\\-.0-9a-zA-Z]", "_");
                int index = 1;
                this.filename = sanitized + ".ini";
                while (new File(presetsDir, this.filename).exists() || this.filename.equals("selected.ini")) {
                    this.filename = sanitized + " (" + index + ").ini";
                    ++index;
                }
            }
            ArrayList<String> strings = new ArrayList<String>();
            JsonObject row = new JsonObject();
            row.add("displayName", (JsonElement)new JsonPrimitive(this.displayName));
            row.add("whitelist", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.whitelist)));
            strings.add(NBTJson.toJson((JsonElement)row));
            try {
                strings.addAll(this.items);
            }
            catch (JsonSyntaxException e) {
                NEIClientConfig.logger.error("Failed to stringify presets ItemStack to json string");
            }
            File tagFile = new File(presetsDir, this.filename);
            try (FileOutputStream output = new FileOutputStream(tagFile);){
                IOUtils.writeLines(strings, (String)"\n", (OutputStream)output, (String)"UTF-8");
            }
            catch (IOException e) {
                NEIClientConfig.logger.error("Filed to save presets list to file {}", new Object[]{tagFile, e});
            }
        }

        public PresetTag copy() {
            return new PresetTag(this.displayName, (HashSet)this.items.clone(), this.whitelist, null);
        }
    }
}

