/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import shukaro.warptheory.util.ChatHelper;
import shukaro.warptheory.util.FormatCodes;
import shukaro.warptheory.util.MiscHelper;

public abstract class IWarpEvent {
    protected final String name;
    protected final int minWarp;

    protected IWarpEvent(String name, int minWarp) {
        this.name = name;
        this.minWarp = minWarp;
    }

    public String getName() {
        return this.name;
    }

    public int getSeverity() {
        return this.minWarp;
    }

    public final int getCost() {
        return (int)Math.ceil((double)this.getSeverity() / 10.0);
    }

    public boolean canDo(World world, EntityPlayer player) {
        return true;
    }

    public abstract boolean doEvent(World var1, EntityPlayer var2);

    public void sendChatMessage(EntityPlayer player) {
        this.sendChatMessage(player, this.name);
    }

    public void sendChatMessage(EntityPlayer player, String messageName) {
        ChatHelper.sendToPlayer(player, FormatCodes.Purple.code + FormatCodes.Italic.code + StatCollector.func_74838_a((String)("chat.warptheory." + messageName)));
    }

    public int decreaseTag(EntityPlayer player, String tag, int decrement) {
        int amount = MiscHelper.getWarpTag(player).func_74762_e(tag);
        if (decrement > 0) {
            if (amount <= decrement) {
                MiscHelper.getWarpTag(player).func_82580_o(tag);
                return 0;
            }
            int newAmount = amount - decrement;
            MiscHelper.getWarpTag(player).func_74768_a(tag, newAmount);
            return newAmount;
        }
        return amount;
    }
}

