/*
 * Decompiled with CFR 0.152.
 */
package elan.tweaks.thaumcraft.research.frontend.integration.table.gui;

import elan.tweaks.common.container.SpecializedContainer;
import elan.tweaks.thaumcraft.research.frontend.domain.model.AspectPallet;
import elan.tweaks.thaumcraft.research.frontend.domain.model.AspectTree;
import elan.tweaks.thaumcraft.research.frontend.domain.model.ResearchProcess;
import elan.tweaks.thaumcraft.research.frontend.domain.model.ResearcherKnowledge;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.provided.AspectPalletPort;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.provided.AspectsTreePort;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.provided.ResearchProcessPort;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.provided.ResearcherKnowledgePort;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.required.AspectPool;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.required.KnowledgeBase;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.required.ResearchNotes;
import elan.tweaks.thaumcraft.research.frontend.integration.adapters.AspectCombinerAdapter;
import elan.tweaks.thaumcraft.research.frontend.integration.adapters.AspectPoolAdapter;
import elan.tweaks.thaumcraft.research.frontend.integration.adapters.KnowledgeBaseAdapter;
import elan.tweaks.thaumcraft.research.frontend.integration.adapters.PlayerInventoryAdapter;
import elan.tweaks.thaumcraft.research.frontend.integration.adapters.ResearchNotesAdapter;
import elan.tweaks.thaumcraft.research.frontend.integration.adapters.ScribeToolsAdapter;
import elan.tweaks.thaumcraft.research.frontend.integration.table.container.ResearchTableContainerFactory;
import elan.tweaks.thaumcraft.research.frontend.integration.table.gui.textures.ResearchTableInventoryTexture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import org.jetbrains.annotations.NotNull;
import thaumcraft.common.tiles.TileResearchTable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lelan/tweaks/thaumcraft/research/frontend/integration/table/gui/PortContainer;", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "table", "Lthaumcraft/common/tiles/TileResearchTable;", "(Lnet/minecraft/entity/player/EntityPlayer;Lthaumcraft/common/tiles/TileResearchTable;)V", "base", "Lelan/tweaks/thaumcraft/research/frontend/integration/adapters/KnowledgeBaseAdapter;", "combiner", "Lelan/tweaks/thaumcraft/research/frontend/integration/adapters/AspectCombinerAdapter;", "inventory", "Lelan/tweaks/common/container/SpecializedContainer;", "getInventory", "()Lelan/tweaks/common/container/SpecializedContainer;", "notes", "Lelan/tweaks/thaumcraft/research/frontend/integration/adapters/ResearchNotesAdapter;", "pallet", "Lelan/tweaks/thaumcraft/research/frontend/domain/ports/provided/AspectPalletPort;", "getPallet", "()Lelan/tweaks/thaumcraft/research/frontend/domain/ports/provided/AspectPalletPort;", "playerInventory", "Lelan/tweaks/thaumcraft/research/frontend/integration/adapters/PlayerInventoryAdapter;", "pool", "Lelan/tweaks/thaumcraft/research/frontend/integration/adapters/AspectPoolAdapter;", "research", "Lelan/tweaks/thaumcraft/research/frontend/domain/ports/provided/ResearchProcessPort;", "getResearch", "()Lelan/tweaks/thaumcraft/research/frontend/domain/ports/provided/ResearchProcessPort;", "researcher", "Lelan/tweaks/thaumcraft/research/frontend/domain/ports/provided/ResearcherKnowledgePort;", "getResearcher", "()Lelan/tweaks/thaumcraft/research/frontend/domain/ports/provided/ResearcherKnowledgePort;", "scribeTools", "Lelan/tweaks/thaumcraft/research/frontend/integration/adapters/ScribeToolsAdapter;", "tree", "Lelan/tweaks/thaumcraft/research/frontend/domain/ports/provided/AspectsTreePort;", "getTree", "()Lelan/tweaks/thaumcraft/research/frontend/domain/ports/provided/AspectsTreePort;", "ThaumcraftResearchTweaks"})
public final class PortContainer {
    @NotNull
    private final SpecializedContainer inventory;
    @NotNull
    private final KnowledgeBaseAdapter base;
    @NotNull
    private final AspectPoolAdapter pool;
    @NotNull
    private final AspectCombinerAdapter combiner;
    @NotNull
    private final ResearchNotesAdapter notes;
    @NotNull
    private final ScribeToolsAdapter scribeTools;
    @NotNull
    private final PlayerInventoryAdapter playerInventory;
    @NotNull
    private final AspectPalletPort pallet;
    @NotNull
    private final AspectsTreePort tree;
    @NotNull
    private final ResearcherKnowledgePort researcher;
    @NotNull
    private final ResearchProcessPort research;

    public PortContainer(@NotNull EntityPlayer player, @NotNull TileResearchTable table) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Object object = player.field_71071_by;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"player.inventory");
        this.inventory = ResearchTableContainerFactory.INSTANCE.create((InventoryPlayer)object, table, ResearchTableInventoryTexture.Slots.INSTANCE.getScribeToolsOrigin(), ResearchTableInventoryTexture.Slots.INSTANCE.getNotesOrigin(), ResearchTableInventoryTexture.INSTANCE.getInventoryOrigin());
        this.base = new KnowledgeBaseAdapter(player);
        this.pool = new AspectPoolAdapter(player, table);
        this.combiner = new AspectCombinerAdapter(player, table);
        this.notes = new ResearchNotesAdapter(player, table, this.inventory);
        this.scribeTools = new ScribeToolsAdapter(table);
        this.playerInventory = new PlayerInventoryAdapter(player);
        this.pallet = new AspectPallet(this.base, this.pool, this.combiner, 10);
        this.tree = AspectTree.INSTANCE;
        object = this.base;
        Object object2 = this.pool;
        this.researcher = new ResearcherKnowledge((AspectPool)object2, (KnowledgeBase)object);
        object = this.pool;
        object2 = this.notes;
        ScribeToolsAdapter scribeToolsAdapter = this.scribeTools;
        KnowledgeBaseAdapter knowledgeBaseAdapter = this.base;
        PlayerInventoryAdapter playerInventoryAdapter = this.playerInventory;
        this.research = new ResearchProcess((ResearchNotes)object2, (AspectPool)object, knowledgeBaseAdapter, scribeToolsAdapter, playerInventoryAdapter);
    }

    @NotNull
    public final SpecializedContainer getInventory() {
        return this.inventory;
    }

    @NotNull
    public final AspectPalletPort getPallet() {
        return this.pallet;
    }

    @NotNull
    public final AspectsTreePort getTree() {
        return this.tree;
    }

    @NotNull
    public final ResearcherKnowledgePort getResearcher() {
        return this.researcher;
    }

    @NotNull
    public final ResearchProcessPort getResearch() {
        return this.research;
    }
}

