/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.items.ItemBlockDesc;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.world.IChunkLoader;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.mars.ConfigManagerMars;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityCryogenicChamber;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityLaunchController;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityTerraformer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMachineMars
extends BlockTileGC
implements ItemBlockDesc.IBlockShiftDesc,
IPartialSealableBlock {
    public static final int TERRAFORMER_METADATA = 0;
    public static final int CRYOGENIC_CHAMBER_METADATA = 4;
    public static final int LAUNCH_CONTROLLER_METADATA = 8;
    private IIcon iconMachineSide;
    private IIcon iconInput;
    private IIcon iconTerraformer;
    private IIcon iconLaunchController;
    private IIcon iconCryochamber;

    public BlockMachineMars() {
        super(GCBlocks.machine);
        this.func_149672_a(field_149777_j);
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_blank");
        this.iconInput = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_input");
        this.iconMachineSide = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_blank");
        this.iconTerraformer = par1IconRegister.func_94245_a("galacticraftmars:terraformer_0");
        this.iconLaunchController = par1IconRegister.func_94245_a("galacticraftmars:launchController");
        this.iconCryochamber = par1IconRegister.func_94245_a("galacticraftmars:cryoDummy");
    }

    @Override
    public void func_149749_a(World var1, int var2, int var3, int var4, Block var5, int var6) {
        TileEntity var9 = var1.func_147438_o(var2, var3, var4);
        if (var9 instanceof IMultiBlock) {
            ((IMultiBlock)var9).onDestroy(var9);
        }
        super.func_149749_a(var1, var2, var3, var4, var5, var6);
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (side == 0 || side == 1) {
            return this.field_149761_L;
        }
        if (metadata >= 8) {
            if (side == (metadata -= 8) + 2) {
                return this.iconInput;
            }
            if (side == ForgeDirection.UP.ordinal() || side == ForgeDirection.DOWN.ordinal()) {
                return this.iconMachineSide;
            }
            return this.iconLaunchController;
        }
        if (metadata >= 4) {
            return this.iconCryochamber;
        }
        if (side == ForgeDirection.UP.ordinal() || side == ForgeDirection.DOWN.ordinal()) {
            return this.iconMachineSide;
        }
        if (side == ForgeDirection.getOrientation((int)(metadata + 2)).ordinal()) {
            return this.iconInput;
        }
        return this.iconTerraformer;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int metadata = world.func_72805_g(x, y, z);
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
                break;
            }
            case 3: {
                change = 3;
            }
        }
        if (metadata >= 8) {
            switch (angle) {
                case 0: {
                    change = 3;
                    break;
                }
                case 1: {
                    change = 1;
                    break;
                }
                case 2: {
                    change = 2;
                    break;
                }
                case 3: {
                    change = 0;
                }
            }
            world.func_72921_c(x, y, z, 8 + change, 3);
        } else if (metadata >= 4) {
            if (!this.canPlaceChamberAt(world, x, y, z)) {
                if (entityLiving instanceof EntityPlayer) {
                    if (!world.field_72995_K) {
                        ((EntityPlayer)entityLiving).func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.RED) + GCCoreUtil.translate("gui.warning.noroom")));
                    }
                    world.func_147468_f(x, y, z);
                    ((EntityPlayer)entityLiving).field_71071_by.func_70441_a(new ItemStack(Item.func_150898_a((Block)MarsBlocks.machine), 1, 4));
                    return;
                }
            } else {
                switch (angle) {
                    case 0: {
                        change = 3;
                        break;
                    }
                    case 1: {
                        change = 1;
                        break;
                    }
                    case 2: {
                        change = 2;
                        break;
                    }
                    case 3: {
                        change = 0;
                    }
                }
                world.func_72921_c(x, y, z, 4 + change, 3);
            }
        } else {
            world.func_72921_c(x, y, z, 0 + change, 3);
        }
        TileEntity var8 = world.func_147438_o(x, y, z);
        if (var8 instanceof IMultiBlock) {
            ((IMultiBlock)var8).onCreate(new BlockVec3(x, y, z));
        }
        if (metadata >= 8) {
            for (int dX = -2; dX < 3; ++dX) {
                for (int dZ = -2; dZ < 3; ++dZ) {
                    Block id = world.func_147439_a(x + dX, y, z + dZ);
                    if (id != GCBlocks.landingPadFull) continue;
                    world.func_147471_g(x + dX, y, z + dZ);
                }
            }
        }
        if (var8 instanceof IChunkLoader && !var8.func_145831_w().field_72995_K && ConfigManagerMars.launchControllerChunkLoad && entityLiving instanceof EntityPlayer) {
            ((IChunkLoader)var8).setOwnerName(((EntityPlayer)entityLiving).func_146103_bH().getName());
            ((IChunkLoader)var8).onTicketLoaded(ForgeChunkManager.requestTicket((Object)GalacticraftCore.instance, (World)var8.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL), true);
        } else if (var8 instanceof TileEntityLaunchController && entityLiving instanceof EntityPlayer) {
            ((TileEntityLaunchController)var8).setOwnerName(((EntityPlayer)entityLiving).func_146103_bH().getName());
        }
    }

    @Override
    public boolean onUseWrench(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        int metadata;
        int original = metadata = par1World.func_72805_g(x, y, z);
        int change = 0;
        if (metadata >= 8) {
            original -= 8;
        } else if (metadata >= 4) {
            return false;
        }
        switch (original) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        if (metadata >= 8) {
            change += 8;
        }
        if ((metadata >= 8 || metadata < 4) && (te = par1World.func_147438_o(x, y, z)) instanceof TileBaseUniversalElectrical) {
            ((TileBaseUniversalElectrical)te).updateFacing();
        }
        par1World.func_72921_c(x, y, z, change, 3);
        return true;
    }

    @Override
    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata >= 8 || metadata < 4) {
            par5EntityPlayer.openGui((Object)GalacticraftPlanets.instance, 2, world, x, y, z);
            return true;
        }
        ((IMultiBlock)world.func_147438_o(x, y, z)).onActivated(par5EntityPlayer);
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata >= 8) {
            return new TileEntityLaunchController();
        }
        if (metadata >= 4) {
            return new TileEntityCryogenicChamber();
        }
        return new TileEntityTerraformer();
    }

    public void func_149664_b(World world, int x, int y, int z, int par5) {
        super.func_149664_b(world, x, y, z, par5);
        if (world.func_72805_g(x, y, z) >= 8) {
            for (int dX = -2; dX < 3; ++dX) {
                for (int dZ = -2; dZ < 3; ++dZ) {
                    Block id = world.func_147439_a(x + dX, y, z + dZ);
                    if (id != GCBlocks.landingPadFull) continue;
                    world.func_147471_g(x + dX, y, z + dZ);
                }
            }
        }
    }

    public ItemStack getTerraformer() {
        return new ItemStack((Block)this, 1, 0);
    }

    public ItemStack getChamber() {
        return new ItemStack((Block)this, 1, 4);
    }

    public ItemStack getLaunchController() {
        return new ItemStack((Block)this, 1, 8);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        par3List.add(this.getTerraformer());
        par3List.add(this.getChamber());
        par3List.add(this.getLaunchController());
    }

    private boolean canPlaceChamberAt(World world, int x0, int y0, int z0) {
        for (int y = 0; y < 3; ++y) {
            Block blockAt = world.func_147439_a(x0, y0 + y, z0);
            int metaAt = world.func_72805_g(x0, y0 + y, z0);
            if (y == 0 && blockAt == MarsBlocks.machine && metaAt >= 4 && metaAt < 8 || blockAt.func_149688_o().func_76222_j()) continue;
            return false;
        }
        return true;
    }

    public int func_149692_a(int metadata) {
        if (metadata >= 8) {
            return 8;
        }
        if (metadata >= 4) {
            return 4;
        }
        return 0;
    }

    public int func_149645_b() {
        return GalacticraftPlanets.getBlockRenderID((Block)this);
    }

    public boolean isBed(IBlockAccess world, int x, int y, int z, EntityLivingBase player) {
        return world.func_72805_g(x, y, z) >= 4;
    }

    public ChunkCoordinates getBedSpawnPosition(IBlockAccess world, int x, int y, int z, EntityPlayer player) {
        return new ChunkCoordinates(x, y + 1, z);
    }

    public void setBedOccupied(IBlockAccess world, int x, int y, int z, EntityPlayer player, boolean occupied) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityCryogenicChamber) {
            ((TileEntityCryogenicChamber)tile).isOccupied = true;
        }
    }

    public static ChunkCoordinates getNearestEmptyChunkCoordinates(World par0World, int par1, int par2, int par3, int par4) {
        for (int k1 = 0; k1 <= 1; ++k1) {
            int l1 = par1 - 1;
            int i2 = par3 - 1;
            int j2 = l1 + 2;
            int k2 = i2 + 2;
            for (int l2 = l1; l2 <= j2; ++l2) {
                for (int i3 = i2; i3 <= k2; ++i3) {
                    if (!World.func_147466_a((IBlockAccess)par0World, (int)l2, (int)(par2 - 1), (int)i3) || par0World.func_147439_a(l2, par2, i3).func_149688_o().func_76218_k() || par0World.func_147439_a(l2, par2 + 1, i3).func_149688_o().func_76218_k()) continue;
                    if (par4 <= 0) {
                        return new ChunkCoordinates(l2, par2, i3);
                    }
                    --par4;
                }
            }
        }
        return null;
    }

    public int getBedDirection(IBlockAccess world, int x, int y, int z) {
        return 0;
    }

    @Override
    public String getShiftDescription(int meta) {
        switch (meta) {
            case 4: {
                return GCCoreUtil.translate("tile.cryoChamber.description");
            }
            case 8: {
                return GCCoreUtil.translate("tile.launchController.description");
            }
            case 0: {
                return GCCoreUtil.translate("tile.terraformer.description");
            }
        }
        return "";
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    @Override
    public boolean isSealed(World world, int x, int y, int z, ForgeDirection direction) {
        int meta = world.func_72805_g(x, y, z) & 0xC;
        return meta != 4;
    }
}

