/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.relauncher.Side;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.items.ItemCanisterGeneric;
import micdoodle8.mods.galacticraft.core.util.Annotations;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityRefinery
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IFluidHandler {
    private final int tankCapacity = 24000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank oilTank = new FluidTank(this.tankCapacity);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank fuelTank = new FluidTank(this.tankCapacity);
    public static final int PROCESS_TIME_REQUIRED = 2;
    public static final int OUTPUT_PER_SECOND = 1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private ItemStack[] containingItems = new ItemStack[3];

    public TileEntityRefinery() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 60.0f);
        this.oilTank.setFluid(new FluidStack(GalacticraftCore.fluidOil, 0));
        this.fuelTank.setFluid(new FluidStack(GalacticraftCore.fluidFuel, 0));
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.containingItems[1] != null) {
                if (this.containingItems[1].func_77973_b() instanceof ItemCanisterGeneric) {
                    if (this.containingItems[1].func_77973_b() == GCItems.oilCanister) {
                        int originalDamage = this.containingItems[1].func_77960_j();
                        int used = this.oilTank.fill(new FluidStack(GalacticraftCore.fluidOil, 1001 - originalDamage), true);
                        this.containingItems[1] = new ItemStack(GCItems.oilCanister, 1, originalDamage + used);
                    }
                } else {
                    boolean isOil;
                    FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[1]);
                    if (liquid != null && (isOil = FluidRegistry.getFluidName((FluidStack)liquid).startsWith("oil")) && (this.oilTank.getFluid() == null || this.oilTank.getFluid().amount + liquid.amount <= this.oilTank.getCapacity())) {
                        this.oilTank.fill(new FluidStack(GalacticraftCore.fluidOil, liquid.amount), true);
                        if (FluidContainerRegistry.isBucket((ItemStack)this.containingItems[1]) && FluidContainerRegistry.isFilledContainer((ItemStack)this.containingItems[1])) {
                            int amount = this.containingItems[1].field_77994_a;
                            if (amount > 1) {
                                this.oilTank.fill(new FluidStack(GalacticraftCore.fluidOil, (amount - 1) * 1000), true);
                            }
                            this.containingItems[1] = new ItemStack(Items.field_151133_ar, amount);
                        } else {
                            --this.containingItems[1].field_77994_a;
                            if (this.containingItems[1].field_77994_a == 0) {
                                this.containingItems[1] = null;
                            }
                        }
                    }
                }
            }
            this.checkFluidTankTransfer(2, this.fuelTank);
            if (this.canProcess() && this.hasEnoughEnergyToRun) {
                if (this.processTicks == 0) {
                    this.processTicks = 2;
                } else if (--this.processTicks <= 0) {
                    this.smeltItem();
                    this.processTicks = this.canProcess() ? 2 : 0;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    private void checkFluidTankTransfer(int slot, FluidTank tank) {
        FluidUtil.tryFillContainerFuel(tank, this.containingItems, slot);
    }

    public int getScaledOilLevel(int i) {
        return this.oilTank.getFluidAmount() * i / this.oilTank.getCapacity();
    }

    public int getScaledFuelLevel(int i) {
        return this.fuelTank.getFluidAmount() * i / this.fuelTank.getCapacity();
    }

    public boolean canProcess() {
        if (this.oilTank.getFluidAmount() <= 0 || this.fuelTank.getFluidAmount() >= this.fuelTank.getCapacity()) {
            return false;
        }
        return !this.getDisabled(0);
    }

    public void smeltItem() {
        if (this.canProcess()) {
            int oilAmount = this.oilTank.getFluidAmount();
            int fuelSpace = this.fuelTank.getCapacity() - this.fuelTank.getFluidAmount();
            int amountToDrain = Math.min(Math.min(oilAmount, fuelSpace), 1);
            this.oilTank.drain(amountToDrain, true);
            this.fuelTank.fill(FluidRegistry.getFluidStack((String)(ConfigManagerCore.useOldFuelFluidID ? "fuelgc" : "fuel"), (int)amountToDrain), true);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTicks = nbt.func_74762_e("smeltingTicks");
        this.containingItems = this.readStandardItemsFromNBT(nbt);
        if (nbt.func_74764_b("oilTank")) {
            this.oilTank.readFromNBT(nbt.func_74775_l("oilTank"));
        }
        if (this.oilTank.getFluid() != null && this.oilTank.getFluid().getFluid() != GalacticraftCore.fluidOil) {
            this.oilTank.setFluid(new FluidStack(GalacticraftCore.fluidOil, this.oilTank.getFluidAmount()));
        }
        if (nbt.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(nbt.func_74775_l("fuelTank"));
        }
        if (this.fuelTank.getFluid() != null && this.fuelTank.getFluid().getFluid() != GalacticraftCore.fluidFuel) {
            this.fuelTank.setFluid(new FluidStack(GalacticraftCore.fluidFuel, this.fuelTank.getFluidAmount()));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(nbt);
        if (this.oilTank.getFluid() != null) {
            nbt.func_74782_a("oilTank", (NBTBase)this.oilTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.fuelTank.getFluid() != null) {
            nbt.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate("container.refinery.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        if (itemstack != null && this.func_94041_b(slotID, itemstack)) {
            boolean bl;
            switch (slotID) {
                case 0: {
                    bl = ItemElectricBase.isElectricItemCharged(itemstack);
                    break;
                }
                case 1: {
                    bl = FluidUtil.isOilContainerAny(itemstack);
                    break;
                }
                case 2: {
                    bl = FluidUtil.isEmptyContainer(itemstack, GCItems.fuelCanister);
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (itemstack != null && this.func_94041_b(slotID, itemstack)) {
            boolean bl;
            switch (slotID) {
                case 0: {
                    if (ItemElectricBase.isElectricItemEmpty(itemstack) || !this.shouldPullEnergy()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 1: {
                    bl = FluidUtil.isEmptyContainer(itemstack);
                    break;
                }
                case 2: {
                    bl = FluidUtil.isFullContainer(itemstack);
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                return itemstack != null && ItemElectricBase.isElectricItem(itemstack.func_77973_b());
            }
            case 1: 
            case 2: {
                return FluidUtil.isValidContainer(itemstack);
            }
        }
        return false;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    @Override
    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.UP;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_145832_p() + 2 ^ 1)))) {
            return this.fuelTank.getFluid() != null && this.fuelTank.getFluidAmount() > 0;
        }
        return false;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_145832_p() + 2 ^ 1)))) {
            return this.fuelTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_145832_p() + 2 ^ 1)))) {
            return this.drain(from, new FluidStack(GalacticraftCore.fluidFuel, maxDrain), doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_145832_p() + 2)))) {
            return this.oilTank.getFluid() == null || this.oilTank.getFluidAmount() < this.oilTank.getCapacity();
        }
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        String liquidName;
        int used = 0;
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_145832_p() + 2))) && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null && liquidName.startsWith("oil")) {
            used = liquidName.equals(GalacticraftCore.fluidOil.getName()) ? this.oilTank.fill(resource, doFill) : this.oilTank.fill(new FluidStack(GalacticraftCore.fluidOil, resource.amount), doFill);
        }
        return used;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] tankInfo = new FluidTankInfo[]{};
        if (from == ForgeDirection.getOrientation((int)(this.func_145832_p() + 2))) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.oilTank)};
        } else if (from == ForgeDirection.getOrientation((int)(this.func_145832_p() + 2 ^ 1))) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.fuelTank)};
        }
        return tankInfo;
    }
}

