/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render.carts;

import java.util.Random;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.client.render.carts.CartContentRenderer;
import mods.railcraft.client.render.carts.RenderCart;
import mods.railcraft.common.carts.EntityCartCargo;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class CartContentRendererCargo
extends CartContentRenderer {
    private final RenderFakeBlock.RenderInfo filterSign = new RenderFakeBlock.RenderInfo();
    private Random rand = new Random();

    public CartContentRendererCargo() {
        this.filterSign.template = Blocks.field_150359_w;
        this.filterSign.texture = new IIcon[1];
        this.filterSign.renderSide[0] = false;
        this.filterSign.renderSide[1] = false;
        this.filterSign.renderSide[2] = false;
        this.filterSign.renderSide[3] = false;
    }

    public void renderCargo(RenderCart renderer, EntityCartCargo cart, float light, float time, int x, int y, int z) {
        if (!cart.hasFilter()) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        EntityItem item = new EntityItem(null, 0.0, 0.0, 0.0, cart.getFilterItem().func_77946_l());
        item.func_92059_d().field_77994_a = 1;
        item.field_70290_d = 0.0f;
        boolean renderIn3D = RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)item.func_92059_d().func_77973_b()).func_149645_b());
        RenderItem.field_82407_g = true;
        if (!renderIn3D) {
            if (!RenderManager.field_78727_a.field_78733_k.field_74347_j) {
                GL11.glDisable((int)2884);
            }
            GL11.glTranslatef((float)0.0f, (float)-0.44f, (float)0.0f);
            float scale = 1.5f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            int numIterations = cart.getSlotsFilled();
            this.rand.setSeed(738L);
            for (int i = 0; i < numIterations; ++i) {
                GL11.glPushMatrix();
                float tx = (float)this.rand.nextGaussian() * 0.1f;
                float ty = (float)this.rand.nextGaussian() * 0.01f;
                float tz = (float)this.rand.nextGaussian() * 0.2f;
                GL11.glTranslatef((float)tx, (float)ty, (float)tz);
                this.renderEntityItem(item);
                GL11.glPopMatrix();
            }
        } else {
            int numIterations;
            GL11.glTranslatef((float)-0.08f, (float)-0.44f, (float)-0.18f);
            float scale = 1.8f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            int slotsFilled = cart.getSlotsFilled();
            if (slotsFilled <= 0) {
                numIterations = 0;
            } else {
                numIterations = (int)Math.ceil((double)slotsFilled / 3.2);
                numIterations = MathHelper.func_76125_a((int)numIterations, (int)1, (int)5);
            }
            this.rand.setSeed(1983L);
            for (int i = 0; i < numIterations; ++i) {
                GL11.glPushMatrix();
                float tx = (float)this.rand.nextGaussian() * 0.2f;
                float ty = (float)this.rand.nextGaussian() * 0.06f;
                float tz = (float)this.rand.nextGaussian() * 0.15f;
                GL11.glTranslatef((float)tx, (float)ty, (float)tz);
                this.renderEntityItem(item);
                GL11.glPopMatrix();
            }
        }
        RenderItem.field_82407_g = false;
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void renderEntityItem(EntityItem item) {
        try {
            RenderManager.field_78727_a.func_147940_a((Entity)item, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void render(RenderCart renderer, EntityMinecart cart, float light, float time) {
        super.render(renderer, cart, light, time);
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glTranslatef((float)0.0f, (float)0.3125f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
        int x = (int)Math.floor(cart.field_70165_t);
        int y = (int)Math.floor(cart.field_70163_u);
        int z = (int)Math.floor(cart.field_70161_v);
        EntityCartCargo cartCargo = (EntityCartCargo)cart;
        this.renderCargo(renderer, cartCargo, light, time, x, y, z);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }
}

