/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import tconstruct.world.TinkerWorld;

public abstract class SlimeBase
extends EntityLiving
implements IMob {
    public float sizeOffset;
    public float sizeFactor;
    public float sizeHeight;
    protected int slimeJumpDelay = 0;

    public SlimeBase(World world) {
        super(world);
        this.initializeSlime();
    }

    protected abstract String getSlimeParticle();

    protected String getJumpSound() {
        return "mob.slime." + (this.getSlimeSize() > 1 ? "big" : "small");
    }

    protected boolean makesSoundOnJump() {
        return this.getSlimeSize() > 0;
    }

    protected boolean makesSoundOnLand() {
        return this.getSlimeSize() > 2;
    }

    public int getSlimeSize() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void setSlimeSize(int size) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)size));
        this.func_70105_a(0.6f * (float)size, 0.6f * (float)size);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getMaxHealthForSize());
        this.func_70606_j(this.getMaxHealthForSize());
        this.field_70747_aH = 0.004f * (float)size + 0.01f;
        this.field_70728_aV = size + 2 ^ size;
    }

    protected float getMaxHealthForSize() {
        int i = this.getSlimeSize();
        if (i == 1) {
            return 4.0f;
        }
        return Math.min(i * i + 8, 49);
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(120) + 40;
    }

    protected boolean canDamagePlayer() {
        return this.getSlimeSize() > 1;
    }

    protected int getAttackStrength() {
        return this.getSlimeSize();
    }

    protected abstract SlimeBase createInstance(World var1);

    protected void initializeSlime() {
        int offset = this.field_70146_Z.nextInt(299);
        offset = offset < 149 ? 1 : (offset < 298 ? 2 : 3);
        int size = 1 << offset;
        this.field_70129_M = 0.0f;
        this.slimeJumpDelay = this.field_70146_Z.nextInt(120) + 40;
        this.setSlimeSize(size);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)1);
    }

    public void func_70664_aZ() {
        this.field_70181_x = 0.05 * (double)this.getSlimeSize() + 0.37;
        if (this.func_70644_a(Potion.field_76430_j)) {
            this.field_70181_x += (double)((float)(this.func_70660_b(Potion.field_76430_j).func_76458_c() + 1) * 0.1f);
        }
        if (this.func_70051_ag()) {
            float f = this.field_70177_z * ((float)Math.PI / 180);
            this.field_70159_w -= (double)(MathHelper.func_76126_a((float)f) * 0.2f);
            this.field_70179_y += (double)(MathHelper.func_76134_b((float)f) * 0.2f);
        }
        if (!(this instanceof IBossDisplayData) && this.func_70013_c(1.0f) > 0.9f && this.field_70146_Z.nextInt(5) == 0 && this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v))) {
            int size = this.getSlimeSize() - 1;
            if (size <= 0) {
                this.func_70076_C();
            } else {
                this.setSlimeSize(size);
            }
        }
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    public void func_70071_h_() {
        int i;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL && this.getSlimeSize() > 0) {
            this.field_70128_L = true;
        }
        this.sizeFactor += (this.sizeOffset - this.sizeFactor) * 0.5f;
        this.sizeHeight = this.sizeFactor;
        boolean flag = this.field_70122_E;
        super.func_70071_h_();
        if (this.field_70122_E && !flag) {
            i = this.getSlimeSize();
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
                float offset = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float xPos = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * offset;
                float zPos = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * offset;
                TinkerWorld.proxy.spawnParticle(this.getSlimeParticle(), this.field_70165_t + (double)xPos, this.field_70121_D.field_72338_b, this.field_70161_v + (double)zPos, 0.0, 0.0, 0.0);
            }
            if (this.makesSoundOnLand()) {
                this.func_85030_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.sizeOffset = -0.5f;
        } else if (!this.field_70122_E && flag) {
            this.sizeOffset = 1.0f;
        }
        this.alterSquishAmount();
        if (this.field_70170_p.field_72995_K) {
            i = this.getSlimeSize();
            this.func_70105_a(0.6f * (float)i, 0.6f * (float)i);
        }
    }

    protected void alterSquishAmount() {
        this.sizeOffset *= 0.6f;
    }

    protected void func_70626_be() {
        this.func_70623_bb();
        EntityPlayer entityplayer = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        if (entityplayer != null) {
            this.func_70625_a((Entity)entityplayer, 10.0f, 20.0f);
        } else if (this.field_70122_E && this.slimeJumpDelay == 1) {
            this.field_70177_z = this.field_70177_z + this.field_70146_Z.nextFloat() * 180.0f - 90.0f;
            if (this.field_70177_z > 360.0f) {
                this.field_70177_z -= 360.0f;
            }
            if (this.field_70177_z < 0.0f) {
                this.field_70177_z += 360.0f;
            }
        }
        if (this.field_70122_E && this.slimeJumpDelay-- <= 0) {
            this.slimeJumpDelay = this.getJumpDelay();
            if (entityplayer != null) {
                this.slimeJumpDelay /= 12;
            }
            this.field_70703_bu = true;
            if (this.makesSoundOnJump()) {
                this.func_85030_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.field_70702_br = 1.0f - this.field_70146_Z.nextFloat() * 2.0f;
            this.field_70701_bs = this.getSlimeSize();
        } else {
            this.field_70703_bu = false;
            if (this.field_70122_E) {
                this.field_70701_bs = 0.0f;
                this.field_70702_br = 0.0f;
            }
        }
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
        if (this.canDamagePlayer()) {
            int i = this.getSlimeSize();
            if (this.func_70685_l((Entity)par1EntityPlayer) && this.func_70068_e((Entity)par1EntityPlayer) < 0.6 * (double)i * 0.6 * (double)i && par1EntityPlayer.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.getAttackStrength())) {
                this.func_85030_a("mob.attack", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    public void func_70106_y() {
        int size = this.getSlimeSize();
        if (!this.field_70170_p.field_72995_K && size > 1 && this.func_110143_aJ() <= 0.0f && size < 8) {
            float f = -0.5f * (float)size / 4.0f;
            float f1 = -0.5f * (float)size / 4.0f;
            SlimeBase entityslime = this.createInstance(this.field_70170_p);
            entityslime.setSlimeSize(size / 2);
            entityslime.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entityslime);
        }
        super.func_70106_y();
    }

    protected void func_70628_a(boolean par1, int par2) {
        int size = this.getSlimeSize();
        Item j = this.func_146068_u();
        if (j != null && this.field_70146_Z.nextInt(2) == 0 || size >= 8) {
            int k = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(this.getSlimeSize());
            if (par2 > 0) {
                k += this.field_70146_Z.nextInt(par2 + 1);
            }
            for (int l = 0; l < k; ++l) {
                this.func_70099_a(new ItemStack(j), 1.0f);
            }
        }
    }

    protected void func_70069_a(float distance) {
        ForgeHooks.onLivingFall((EntityLivingBase)this, (float)distance);
    }

    public boolean func_70601_bi() {
        int z;
        int y;
        if (!this.field_70170_p.func_72855_b(this.field_70121_D) || !this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() || this.field_70170_p.func_72953_d(this.field_70121_D)) {
            return false;
        }
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72972_b(EnumSkyBlock.Sky, x, y = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), z = MathHelper.func_76128_c((double)this.field_70161_v)) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int light = this.field_70170_p.func_72957_l(x, y, z);
        if (this.field_70170_p.func_72911_I()) {
            int i1 = this.field_70170_p.field_73008_k;
            this.field_70170_p.field_73008_k = 10;
            light = this.field_70170_p.func_72957_l(x, y, z);
            this.field_70170_p.field_73008_k = i1;
        }
        return light <= this.field_70146_Z.nextInt(8);
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.3;
    }

    protected String func_70621_aR() {
        return this.getJumpSound();
    }

    protected String func_70673_aS() {
        return this.getJumpSound();
    }

    protected float func_70599_aP() {
        return Math.min(0.05f * (float)this.getSlimeSize(), 0.3f);
    }

    public int func_70646_bf() {
        return 0;
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("Size", this.getSlimeSize() - 1);
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.setSlimeSize(par1NBTTagCompound.func_74762_e("Size") + 1);
    }
}

