/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;

public class BaseInventoryUtils {
    public static InventorySide inventorySide(IInventory base, int side) {
        if (base instanceof ISidedInventory) {
            return new SidedInventorySide((ISidedInventory)base, side);
        }
        return new UnsidedInventorySide(base);
    }

    public static void clearInventory(IInventory inv) {
        int n = inv.func_70302_i_();
        for (int i = 0; i < n; ++i) {
            inv.func_70299_a(i, null);
        }
    }

    public static class SidedInventorySide
    extends InventorySide {
        ISidedInventory base;
        int side;
        int[] slots;

        public SidedInventorySide(ISidedInventory base, int side) {
            this.base = base;
            this.side = side;
            this.slots = base.func_94128_d(side);
            this.size = this.slots.length;
        }

        @Override
        public ItemStack get(int i) {
            return this.base.func_70301_a(this.slots[i]);
        }

        @Override
        public boolean set(int i, ItemStack stack) {
            int slot = this.slots[i];
            if (this.base.func_102007_a(slot, stack, this.side)) {
                this.base.func_70299_a(slot, stack);
                return true;
            }
            return false;
        }

        @Override
        public ItemStack extract(int i) {
            int slot = this.slots[i];
            ItemStack stack = this.base.func_70301_a(slot);
            if (this.base.func_102008_b(slot, stack, this.side)) {
                return stack;
            }
            return null;
        }
    }

    public static class UnsidedInventorySide
    extends InventorySide {
        IInventory base;

        public UnsidedInventorySide(IInventory base) {
            this.base = base;
            this.size = base.func_70302_i_();
        }

        @Override
        public ItemStack get(int slot) {
            return this.base.func_70301_a(slot);
        }

        @Override
        public boolean set(int slot, ItemStack stack) {
            this.base.func_70299_a(slot, stack);
            return true;
        }

        @Override
        public ItemStack extract(int slot) {
            return this.get(slot);
        }
    }

    public static abstract class InventorySide {
        public int size;

        public abstract ItemStack get(int var1);

        public abstract boolean set(int var1, ItemStack var2);

        public abstract ItemStack extract(int var1);
    }
}

