/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.block;

import java.io.IOException;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class PowerPacketLaser
extends CoordinatesPacket {
    private ForgeDirection dir;
    private int color;
    private boolean reverse;
    private boolean renderBall;
    private float length;
    private boolean remove = false;

    public PowerPacketLaser(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        this.length = data.readFloat();
        this.dir = data.readForgeDirection();
        this.color = data.readInt();
        this.reverse = data.readBoolean();
        this.renderBall = data.readBoolean();
        this.remove = data.readBoolean();
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericPipe tile = this.getPipe(player.func_130014_f_());
        if (this.remove) {
            tile.removeLaser(this.dir, this.getColor(), this.isRenderBall());
        } else {
            tile.addLaser(this.dir, this.getLength(), this.getColor(), this.isReverse(), this.isRenderBall());
        }
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeFloat(this.length);
        data.writeForgeDirection(this.dir);
        data.writeInt(this.color);
        data.writeBoolean(this.reverse);
        data.writeBoolean(this.renderBall);
        data.writeBoolean(this.remove);
    }

    @Override
    public ModernPacket template() {
        return new PowerPacketLaser(this.getId());
    }

    public ForgeDirection getDir() {
        return this.dir;
    }

    public PowerPacketLaser setDir(ForgeDirection dir) {
        this.dir = dir;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public PowerPacketLaser setColor(int color) {
        this.color = color;
        return this;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public PowerPacketLaser setReverse(boolean reverse) {
        this.reverse = reverse;
        return this;
    }

    public boolean isRenderBall() {
        return this.renderBall;
    }

    public PowerPacketLaser setRenderBall(boolean renderBall) {
        this.renderBall = renderBall;
        return this;
    }

    public float getLength() {
        return this.length;
    }

    public PowerPacketLaser setLength(float length) {
        this.length = length;
        return this;
    }

    public boolean isRemove() {
        return this.remove;
    }

    public PowerPacketLaser setRemove(boolean remove) {
        this.remove = remove;
        return this;
    }
}

