/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import logisticspipes.gui.hud.modules.HUDAdvancedExtractor;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IModuleInventoryReceive;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.modules.abstractmodules.LogisticsSneakyDirectionModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.module.inhand.AdvancedExtractorModuleInHand;
import logisticspipes.network.guis.module.inpipe.AdvancedExtractorModuleSlot;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.module.ModuleInventory;
import logisticspipes.network.packets.modules.AdvancedExtractorInclude;
import logisticspipes.network.packets.modules.ExtractorModuleMode;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

@CCType(name="Advanced Extractor Module")
public class ModuleAdvancedExtractor
extends LogisticsSneakyDirectionModule
implements IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
IModuleInventoryReceive,
ISimpleInventoryEventHandler {
    protected int currentTick = 0;
    private final ItemIdentifierInventory _filterInventory = new ItemIdentifierInventory(9, "Item list", 1);
    private boolean _itemsIncluded = true;
    private ForgeDirection _sneakyDirection = ForgeDirection.UNKNOWN;
    private final IHUDModuleRenderer HUD = new HUDAdvancedExtractor(this);
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();

    public ModuleAdvancedExtractor() {
        this._filterInventory.addListener(this);
    }

    @CCCommand(description="Returns the FilterInventory of this Module")
    public ItemIdentifierInventory getFilterInventory() {
        return this._filterInventory;
    }

    @Override
    public ForgeDirection getSneakyDirection() {
        return this._sneakyDirection;
    }

    @Override
    public void setSneakyDirection(ForgeDirection sneakyDirection) {
        this._sneakyDirection = sneakyDirection;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this._filterInventory.readFromNBT(nbttagcompound);
        this.setItemsIncluded(nbttagcompound.func_74767_n("itemsIncluded"));
        if (nbttagcompound.func_74764_b("sneakydirection")) {
            this._sneakyDirection = ForgeDirection.values()[nbttagcompound.func_74762_e("sneakydirection")];
        } else if (nbttagcompound.func_74764_b("sneakyorientation")) {
            int t = nbttagcompound.func_74762_e("sneakyorientation");
            switch (t) {
                default: {
                    this._sneakyDirection = ForgeDirection.UNKNOWN;
                    break;
                }
                case 1: {
                    this._sneakyDirection = ForgeDirection.UP;
                    break;
                }
                case 2: {
                    this._sneakyDirection = ForgeDirection.SOUTH;
                    break;
                }
                case 3: {
                    this._sneakyDirection = ForgeDirection.DOWN;
                }
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        this._filterInventory.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("itemsIncluded", this.areItemsIncluded());
        nbttagcompound.func_74768_a("sneakydirection", this._sneakyDirection.ordinal());
    }

    @Override
    protected ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        return NewGuiHandler.getGui(AdvancedExtractorModuleSlot.class).setAreItemsIncluded(this._itemsIncluded);
    }

    @Override
    protected ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(AdvancedExtractorModuleInHand.class);
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        return null;
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    protected int ticksToAction() {
        return 100;
    }

    protected int itemsToExtract() {
        return 1;
    }

    protected int neededEnergy() {
        return 6;
    }

    protected CoreRoutedPipe.ItemSendMode itemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public void tick() {
        IInventoryUtil inventory;
        if (++this.currentTick < this.ticksToAction()) {
            return;
        }
        this.currentTick = 0;
        ForgeDirection extractOrientation = this._sneakyDirection;
        if (extractOrientation == ForgeDirection.UNKNOWN) {
            extractOrientation = this._service.inventoryOrientation().getOpposite();
        }
        if ((inventory = this._service.getSneakyInventory(extractOrientation, true)) == null) {
            return;
        }
        this.checkExtract(inventory);
    }

    private void checkExtract(IInventoryUtil invUtil) {
        Map<ItemIdentifier, Integer> items = invUtil.getItemsAndCount();
        for (Map.Entry<ItemIdentifier, Integer> item : items.entrySet()) {
            if (!this.CanExtract(item.getKey().makeNormalStack(item.getValue()))) continue;
            LinkedList<Integer> jamList = new LinkedList<Integer>();
            Pair<Integer, SinkReply> reply = this._service.hasDestination(item.getKey(), true, jamList);
            if (reply == null) continue;
            int itemsleft = this.itemsToExtract();
            while (reply != null) {
                ItemStack stackToSend;
                int count = Math.min(itemsleft, item.getValue());
                count = Math.min(count, item.getKey().getMaxStackSize());
                if (reply.getValue2().maxNumberOfItems > 0) {
                    count = Math.min(count, reply.getValue2().maxNumberOfItems);
                }
                while (!this._service.useEnergy(this.neededEnergy() * count) && count > 0) {
                    this._service.spawnParticle(Particles.OrangeParticle, 2);
                    --count;
                }
                if (count <= 0 || (stackToSend = invUtil.getMultipleItems(item.getKey(), count)) == null || stackToSend.field_77994_a == 0) break;
                count = stackToSend.field_77994_a;
                this._service.sendStack(stackToSend, reply, this.itemSendMode());
                if ((itemsleft -= count) <= 0) break;
                jamList.add(reply.getValue1());
                reply = this._service.hasDestination(item.getKey(), true, jamList);
            }
            return;
        }
    }

    public boolean CanExtract(ItemStack item) {
        for (int i = 0; i < this._filterInventory.func_70302_i_(); ++i) {
            ItemStack stack = this._filterInventory.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item.func_77973_b()) continue;
            if (item.func_77973_b().func_77645_m()) {
                return this.areItemsIncluded();
            }
            if (stack.func_77960_j() != item.func_77960_j()) continue;
            return this.areItemsIncluded();
        }
        return !this.areItemsIncluded();
    }

    public boolean areItemsIncluded() {
        return this._itemsIncluded;
    }

    public void setItemsIncluded(boolean flag) {
        this._itemsIncluded = flag;
        if (!this.localModeWatchers.isEmpty()) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(AdvancedExtractorInclude.class).setFlag(this.areItemsIncluded()).setModulePos(this), this.localModeWatchers);
        }
    }

    @Override
    public List<String> getClientInformation() {
        ArrayList<String> list = new ArrayList<String>(5);
        list.add(this.areItemsIncluded() ? "Included" : "Excluded");
        list.add("Extraction: " + (this._sneakyDirection == ForgeDirection.UNKNOWN ? "DEFAULT" : this._sneakyDirection.name()));
        list.add("Filter: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        if (MainProxy.isServer(this._world.getWorld())) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(inventory)).setModulePos(this), this.localModeWatchers);
        }
    }

    @Override
    public void handleInvContent(Collection<ItemIdentifierStack> list) {
        this._filterInventory.handleItemIdentifierList(list);
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(this._filterInventory)).setModulePos(this), player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ExtractorModuleMode.class).setDirection(this._sneakyDirection).setModulePos(this), player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(AdvancedExtractorInclude.class).setFlag(this.areItemsIncluded()).setModulePos(this), player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return this.HUD;
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    public List<ItemIdentifier> getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTexture(IIconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleAdvancedExtractor");
    }
}

