/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGen_Base;
import java.util.HashSet;
import java.util.Set;

public class RecipeGen_AlloySmelter
extends RecipeGen_Base {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();

    public RecipeGen_AlloySmelter(Material M) {
        this.toGenerate = M;
        mRecipeGenMap.add(this);
    }

    @Override
    public void run() {
        this.generateRecipes(this.toGenerate);
    }

    private void generateRecipes(Material material) {
        int tVoltageMultiplier = material.vVoltageMultiplier;
        if (ItemUtils.checkForInvalidItems(material.getIngot(1)) && ItemUtils.checkForInvalidItems(material.getNugget(1))) {
            GT_Values.RA.addAlloySmelterRecipe(material.getIngot(1), ItemList.Shape_Mold_Nugget.get(0L, new Object[0]), material.getNugget(9), (int)Math.max(material.getMass() * 2L, 1L), tVoltageMultiplier);
        }
        if (ItemUtils.checkForInvalidItems(material.getIngot(1)) && ItemUtils.checkForInvalidItems(material.getGear(1))) {
            GT_Values.RA.addAlloySmelterRecipe(material.getIngot(8), ItemList.Shape_Mold_Gear.get(0L, new Object[0]), material.getGear(1), (int)Math.max(material.getMass() * 2L, 1L), tVoltageMultiplier);
        }
        if (ItemUtils.checkForInvalidItems(material.getIngot(1)) && ItemUtils.checkForInvalidItems(material.getNugget(1))) {
            GT_Values.RA.addAlloySmelterRecipe(material.getNugget(9), ItemList.Shape_Mold_Ingot.get(0L, new Object[0]), material.getIngot(1), (int)Math.max(material.getMass() * 2L, 1L), tVoltageMultiplier);
        }
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.put(mRecipeGenMap);
    }
}

