/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.material.ELEMENT;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechOrePrefixes;
import gtPlusPlus.xmod.gregtech.api.interfaces.internal.Interface_OreRecipeRegistrator;
import gtPlusPlus.xmod.gregtech.common.items.MetaGeneratedGregtechTools;
import net.minecraft.item.ItemStack;

public class ProcessingAngleGrinder
implements Interface_OreRecipeRegistrator,
Runnable {
    public ProcessingAngleGrinder() {
        GregtechOrePrefixes.toolAngleGrinder.add(this);
    }

    @Override
    public void registerOre(GregtechOrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        if (aMaterial == Materials.Stone || aMaterial == Materials.Flint || aMaterial == Materials.Rubber || aMaterial.contains(SubTag.WOOD) || aMaterial.contains(SubTag.BOUNCY) || !aMaterial.contains(SubTag.NO_SMASHING)) {
            // empty if block
        }
    }

    @Override
    public void registerOre(GregtechOrePrefixes aPrefix, GregtechOrePrefixes.GT_Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
    }

    public void materialsLoops() {
        Materials[] i = Materials.values();
        int size = i.length;
        Logger.MATERIALS("Materials to attempt tool gen. with: " + size);
        int used = 0;
        Materials aMaterial = null;
        for (int r = 0; r < size; ++r) {
            aMaterial = i[r];
            if (aMaterial != Materials.Stone && aMaterial != Materials.Flint && aMaterial != Materials.Rubber && aMaterial != Materials._NULL) {
                if (!(aMaterial.contains(SubTag.WOOD) || aMaterial.contains(SubTag.BOUNCY) || aMaterial.contains(SubTag.NO_SMASHING) || aMaterial.contains(SubTag.TRANSPARENT) || aMaterial.contains(SubTag.FLAMMABLE) || aMaterial.contains(SubTag.MAGICAL) || aMaterial.contains(SubTag.NO_SMELTING))) {
                    Logger.MATERIALS("Generating Angle Grinder from " + MaterialUtils.getMaterialName(aMaterial));
                    ItemStack plate = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)aMaterial, (long)1L);
                    ItemStack longrod = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stickLong, (Object)aMaterial, (long)1L);
                    if (null != plate && longrod != null) {
                        this.addRecipe(aMaterial, 1600000L, 3, ItemList.Battery_RE_HV_Lithium.get(1L, new Object[0]));
                        this.addRecipe(aMaterial, 1200000L, 3, ItemList.Battery_RE_HV_Cadmium.get(1L, new Object[0]));
                        this.addRecipe(aMaterial, 800000L, 3, ItemList.Battery_RE_HV_Sodium.get(1L, new Object[0]));
                        ++used;
                        continue;
                    }
                    Logger.MATERIALS("Unable to generate Angle Grinder from " + MaterialUtils.getMaterialName(aMaterial) + ", Plate or Long Rod may be invalid. Invalid | Plate? " + (plate == null) + " | Rod? " + (longrod == null) + " |");
                    continue;
                }
                Logger.MATERIALS("Unable to generate Angle Grinder from " + MaterialUtils.getMaterialName(aMaterial));
                continue;
            }
            Logger.MATERIALS("Unable to generate Angle Grinder from " + MaterialUtils.getMaterialName(aMaterial));
        }
        Logger.INFO("Materials used for tool gen: " + used);
    }

    @Override
    public void run() {
        Logger.INFO("Generating Angle Grinders for all valid GT Materials.");
        this.materialsLoops();
    }

    public boolean addRecipe(Materials aMaterial, long aBatteryStorage, int aVoltageTier, ItemStack aBattery) {
        ItemStack aOutputStack = MetaGeneratedGregtechTools.INSTANCE.getToolWithStats(7834, 1, aMaterial, Materials.Titanium, new long[]{aBatteryStorage, GT_Values.V[aVoltageTier], 3L, -1L});
        long aDura = MetaGeneratedGregtechTools.getToolMaxDamage((ItemStack)aOutputStack);
        if (aDura <= 32000L) {
            Logger.MATERIALS("Unable to generate Angle Grinder from " + MaterialUtils.getMaterialName(aMaterial) + ", Durability: " + aDura);
            return false;
        }
        return GT_ModHandler.addCraftingRecipe((ItemStack)aOutputStack, (long)(GT_ModHandler.RecipeBits.DISMANTLEABLE | GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"SXL", "GMG", "PBP", Character.valueOf('X'), ItemList.Component_Grinder_Tungsten.get(1L, new Object[0]), Character.valueOf('M'), CI.getElectricMotor(aVoltageTier, 1), Character.valueOf('S'), OrePrefixes.screw.get((Object)Materials.Titanium), Character.valueOf('L'), OrePrefixes.stickLong.get((Object)aMaterial), Character.valueOf('P'), OrePrefixes.plate.get((Object)aMaterial), Character.valueOf('G'), ELEMENT.STANDALONE.BLACK_METAL.getGear(1), Character.valueOf('B'), aBattery});
    }
}

