/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Element;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.recipe.check.FindRecipeResult;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_DataOrb;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_ElementalDataOrbHolder;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GregtechMTE_ElementalDuplicator
extends GregtechMeta_MultiBlockBase<GregtechMTE_ElementalDuplicator>
implements ISurvivalConstructable {
    private final ArrayList<GT_MetaTileEntity_Hatch_ElementalDataOrbHolder> mReplicatorDataOrbHatches = new ArrayList();
    private static final int CASING_TEXTURE_ID = TAE.getIndexFromPage(0, 3);
    private int mCasing = 0;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static IStructureDefinition<GregtechMTE_ElementalDuplicator> STRUCTURE_DEFINITION = null;

    public GregtechMTE_ElementalDuplicator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMTE_ElementalDuplicator(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMTE_ElementalDuplicator(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Replicator";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Produces Elemental Material from UU Matter").addInfo("Speed: +100% | EU Usage: 100% | Parallel: 8 * Tier").addInfo("Maximum 1x of each bus/hatch.").addInfo("Requires circuit 1-16 in your Data Orb Repository").addInfo("depending on what Data Orb you want to prioritize").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(9, 6, 9, true).addController("Top Center").addCasingInfoMin("Elemental Confinement Shell", 138, false).addCasingInfoMin("Matter Fabricator Casing", 24, false).addCasingInfoMin("Particle Containment Casing", 24, false).addCasingInfoMin("Matter Generation Coil", 24, false).addCasingInfoMin("High Voltage Current Capacitor", 20, false).addCasingInfoMin("Resonance Chamber III", 24, false).addCasingInfoMin("Modulator III", 16, false).addOtherStructurePart("Data Orb Repository", "1x", new int[]{1}).addInputHatch("Any 1 dot hint", new int[]{1}).addOutputBus("Any 1 dot hint", new int[]{1}).addOutputHatch("Any 1 dot hint", new int[]{1}).addEnergyHatch("Any 1 dot hint", new int[]{1}).addMaintenanceHatch("Any 1 dot hint", new int[]{1}).addMufflerHatch("Any 1 dot hint", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    public IStructureDefinition<GregtechMTE_ElementalDuplicator> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, (String[][])new String[][]{{"   ccc   ", "  ccccc  ", " ccccccc ", "ccchhhccc", "ccch~hccc", "ccchhhccc", " ccccccc ", "  ccccc  ", "   ccc   "}, {"   cac   ", "  abfba  ", " abfgfba ", "cbfgdgfbc", "afgdddgfa", "cbfgdgfbc", " abfgfba ", "  abfba  ", "   cac   "}, {"   cec   ", "  e   e  ", " e     e ", "c   d   c", "e  ddd  e", "c   d   c", " e     e ", "  e   e  ", "   cec   "}, {"   cec   ", "  e   e  ", " e     e ", "c   d   c", "e  ddd  e", "c   d   c", " e     e ", "  e   e  ", "   cec   "}, {"   cac   ", "  abfba  ", " abfgfba ", "cbfgdgfbc", "afgdddgfa", "cbfgdgfbc", " abfgfba ", "  abfba  ", "   cac   "}, {"   ccc   ", "  ccccc  ", " ccccccc ", "ccchhhccc", "ccchhhccc", "ccchhhccc", " ccccccc ", "  ccccc  ", "   ccc   "}}).addElement('a', StructureUtility.ofBlock((Block)GregtechMTE_ElementalDuplicator.getCasingBlock4(), (int)GregtechMTE_ElementalDuplicator.getCasingMeta6())).addElement('b', StructureUtility.ofBlock((Block)GregtechMTE_ElementalDuplicator.getCasingBlock4(), (int)GregtechMTE_ElementalDuplicator.getCasingMeta7())).addElement('d', StructureUtility.ofBlock((Block)GregtechMTE_ElementalDuplicator.getCasingBlock2(), (int)GregtechMTE_ElementalDuplicator.getCasingMeta2())).addElement('e', StructureUtility.ofBlock((Block)GregtechMTE_ElementalDuplicator.getCasingBlock2(), (int)GregtechMTE_ElementalDuplicator.getCasingMeta3())).addElement('f', StructureUtility.ofBlock((Block)GregtechMTE_ElementalDuplicator.getCasingBlock3(), (int)GregtechMTE_ElementalDuplicator.getCasingMeta4())).addElement('g', StructureUtility.ofBlock((Block)GregtechMTE_ElementalDuplicator.getCasingBlock3(), (int)GregtechMTE_ElementalDuplicator.getCasingMeta5())).addElement('c', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregtechMTE_ElementalDuplicator.getCasingBlock(), (int)GregtechMTE_ElementalDuplicator.getCasingMeta())))).addElement('h', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(GregtechMTE_ElementalDuplicator.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.OutputBus, GT_HatchElement.OutputHatch, GT_HatchElement.Maintenance, GT_HatchElement.Muffler, GT_HatchElement.Energy}).casingIndex(GregtechMTE_ElementalDuplicator.getCasingTextureIndex()).dot(1).build(), GT_StructureUtility.buildHatchAdder(GregtechMTE_ElementalDuplicator.class).hatchClass(GT_MetaTileEntity_Hatch_ElementalDataOrbHolder.class).shouldReject(x -> x.mReplicatorDataOrbHatches.size() >= 1).adder(GregtechMTE_ElementalDuplicator::addDataOrbHatch).casingIndex(GregtechMTE_ElementalDuplicator.getCasingTextureIndex()).dot(1).build(), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregtechMTE_ElementalDuplicator.getCasingBlock(), (int)GregtechMTE_ElementalDuplicator.getCasingMeta()))}))).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 4, 4, 0);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        boolean aDidBuild = this.checkPiece(STRUCTURE_PIECE_MAIN, 4, 4, 0);
        if (this.mInputHatches.size() != 1 || this.mOutputBusses.size() != 1 && this.mOutputHatches.size() != 0 || this.mEnergyHatches.size() != 1 || this.mReplicatorDataOrbHatches.size() != 1) {
            return false;
        }
        this.log("Casings: " + this.mCasing);
        return aDidBuild && this.mCasing >= 138 && this.checkHatch();
    }

    public int survivalConstruct(ItemStack itemStack, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, itemStack, 4, 4, 0, elementBudget, env, false, true);
    }

    protected static int getCasingTextureIndex() {
        return CASING_TEXTURE_ID;
    }

    protected static Block getCasingBlock() {
        return ModBlocks.blockCasings5Misc;
    }

    protected static Block getCasingBlock2() {
        return ModBlocks.blockSpecialMultiCasings;
    }

    protected static Block getCasingBlock3() {
        return ModBlocks.blockSpecialMultiCasings2;
    }

    protected static Block getCasingBlock4() {
        return ModBlocks.blockCasingsMisc;
    }

    protected static int getCasingMeta() {
        return 3;
    }

    protected static int getCasingMeta2() {
        return 12;
    }

    protected static int getCasingMeta3() {
        return 13;
    }

    protected static int getCasingMeta4() {
        return 2;
    }

    protected static int getCasingMeta5() {
        return 6;
    }

    protected static int getCasingMeta6() {
        return 9;
    }

    protected static int getCasingMeta7() {
        return 8;
    }

    private boolean addDataOrbHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_ElementalDataOrbHolder) {
            try {
                ((GT_MetaTileEntity_Hatch_ElementalDataOrbHolder)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
                return this.addToMachineListInternal(this.mReplicatorDataOrbHatches, aMetaTileEntity, aBaseCasingIndex);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return false;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d == ForgeDirection.UP;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    @Override
    protected int getCasingTextureId() {
        return CASING_TEXTURE_ID;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GTPP_Recipe.GTPP_Recipe_Map.sElementalDuplicatorRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @NotNull
            protected FindRecipeResult findRecipe(@Nullable GT_Recipe.GT_Recipe_Map map) {
                if (map == null) {
                    return FindRecipeResult.NOT_FOUND;
                }
                try {
                    GT_Recipe recipe;
                    ItemStack aDataOrbStack = null;
                    block2: for (GT_Recipe nRecipe : map.mRecipeList) {
                        ItemStack aTempStack = GregtechMTE_ElementalDuplicator.getSpecialSlotStack(nRecipe);
                        if (aTempStack == null) continue;
                        for (ItemStack aItem : this.inputItems) {
                            if (nRecipe.mSpecialItems == null || !GT_Utility.areStacksEqual((ItemStack)aTempStack, (ItemStack)aItem, (boolean)false)) continue;
                            aDataOrbStack = aTempStack;
                            break block2;
                        }
                    }
                    if (aDataOrbStack != null && (recipe = GregtechMTE_ElementalDuplicator.this.findRecipe((IHasWorldObjectAndCoords)GregtechMTE_ElementalDuplicator.this.getBaseMetaTileEntity(), GregtechMTE_ElementalDuplicator.this.mLastRecipe, false, false, this.availableVoltage, this.inputFluids, aDataOrbStack, this.inputItems)) != null) {
                        return FindRecipeResult.ofSuccess((GT_Recipe)recipe);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return FindRecipeResult.NOT_FOUND;
            }
        }.setSpeedBonus(0.5f).enablePerfectOverclock().setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 8 * GT_Utility.getTier((long)this.getMaxInputVoltage());
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiMolecularTransformer;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && (this.mUpdate == 1 || this.mStartUpCheck == 1)) {
            this.mReplicatorDataOrbHatches.clear();
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public ArrayList<ItemStack> getStoredInputs() {
        ArrayList tItems = super.getStoredInputs();
        for (GT_MetaTileEntity_Hatch_ElementalDataOrbHolder tHatch : this.mReplicatorDataOrbHatches) {
            tHatch.mRecipeMap = this.getRecipeMap();
            if (!GregtechMTE_ElementalDuplicator.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            tItems.add(tHatch.getOrbByCircuit());
        }
        tItems.removeAll(Collections.singleton(null));
        return tItems;
    }

    public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, boolean aDontCheckStackSizes, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
        ItemStack aRecipeSpecial;
        Collection tRecipes;
        int n;
        GT_Recipe.GT_Recipe_Map mRecipeMap = this.getRecipeMap();
        if (mRecipeMap.mRecipeList.isEmpty()) {
            return null;
        }
        if (GregTech_API.sPostloadFinished) {
            int n2;
            FluidStack[] fluidStackArray;
            int tAmount;
            if (mRecipeMap.mMinimalInputFluids > 0) {
                if (aFluids == null) {
                    return null;
                }
                tAmount = 0;
                fluidStackArray = aFluids;
                n = fluidStackArray.length;
                for (n2 = 0; n2 < n; ++n2) {
                    FluidStack aFluid = fluidStackArray[n2];
                    if (aFluid == null) continue;
                    ++tAmount;
                }
                if (tAmount < mRecipeMap.mMinimalInputFluids) {
                    return null;
                }
            }
            if (mRecipeMap.mMinimalInputItems > 0) {
                if (aInputs == null) {
                    return null;
                }
                tAmount = 0;
                fluidStackArray = aInputs;
                n = fluidStackArray.length;
                for (n2 = 0; n2 < n; ++n2) {
                    FluidStack aInput = fluidStackArray[n2];
                    if (aInput == null) continue;
                    ++tAmount;
                }
                if (tAmount < mRecipeMap.mMinimalInputItems) {
                    return null;
                }
            }
        }
        if (aNotUnificated) {
            aInputs = GT_OreDictUnificator.getStackArray((boolean)true, (Object[])aInputs);
        }
        if (aRecipe != null) {
            ItemStack aRecipeSpecial2 = GregtechMTE_ElementalDuplicator.getSpecialSlotStack(aRecipe);
            if (!aRecipe.mFakeRecipe && aRecipe.mCanBeBuffered && aRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs) && GT_Utility.areStacksEqual((ItemStack)aRecipeSpecial2, (ItemStack)aSpecialSlot, (boolean)false) && GregtechMTE_ElementalDuplicator.areDataOrbsEqual(aRecipeSpecial2, aSpecialSlot)) {
                return aRecipe.mEnabled && aVoltage * (long)mRecipeMap.mAmperage >= (long)aRecipe.mEUt ? aRecipe : null;
            }
        }
        if (mRecipeMap.mUsualInputCount > 0 && aInputs != null) {
            ItemStack[] itemStackArray = aInputs;
            int n3 = itemStackArray.length;
            for (n = 0; n < n3; ++n) {
                ItemStack tStack = itemStackArray[n];
                if (tStack == null) continue;
                tRecipes = (Collection)mRecipeMap.mRecipeItemMap.get(new GT_ItemStack(tStack));
                if (tRecipes != null) {
                    for (GT_Recipe tRecipe : tRecipes) {
                        if (!tRecipe.mFakeRecipe && tRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs) && GT_Utility.areStacksEqual((ItemStack)(aRecipeSpecial = GregtechMTE_ElementalDuplicator.getSpecialSlotStack(tRecipe)), (ItemStack)aSpecialSlot, (boolean)false) && GregtechMTE_ElementalDuplicator.areDataOrbsEqual(aRecipeSpecial, aSpecialSlot)) {
                            return tRecipe.mEnabled && aVoltage * (long)mRecipeMap.mAmperage >= (long)tRecipe.mEUt ? tRecipe : null;
                        }
                        tRecipes = (Collection)mRecipeMap.mRecipeItemMap.get(new GT_ItemStack(tStack, true));
                    }
                }
                if (tRecipes == null) continue;
                for (GT_Recipe tRecipe : tRecipes) {
                    if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs) || !GT_Utility.areStacksEqual((ItemStack)(aRecipeSpecial = GregtechMTE_ElementalDuplicator.getSpecialSlotStack(tRecipe)), (ItemStack)aSpecialSlot, (boolean)false) || !GregtechMTE_ElementalDuplicator.areDataOrbsEqual(aRecipeSpecial, aSpecialSlot)) continue;
                    return tRecipe.mEnabled && aVoltage * (long)mRecipeMap.mAmperage >= (long)tRecipe.mEUt ? tRecipe : null;
                }
            }
        }
        if (mRecipeMap.mMinimalInputItems == 0 && aFluids != null) {
            for (FluidStack aFluid : aFluids) {
                if (aFluid == null || (tRecipes = (Collection)mRecipeMap.mRecipeFluidMap.get(aFluid.getFluid().getName())) == null) continue;
                for (GT_Recipe tRecipe : tRecipes) {
                    if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs) || !GT_Utility.areStacksEqual((ItemStack)(aRecipeSpecial = GregtechMTE_ElementalDuplicator.getSpecialSlotStack(tRecipe)), (ItemStack)aSpecialSlot, (boolean)false) || !GregtechMTE_ElementalDuplicator.areDataOrbsEqual(aRecipeSpecial, aSpecialSlot)) continue;
                    return tRecipe.mEnabled && aVoltage * (long)mRecipeMap.mAmperage >= (long)tRecipe.mEUt ? tRecipe : null;
                }
            }
        }
        return null;
    }

    public static ItemStack getSpecialSlotStack(GT_Recipe aRecipe) {
        ItemStack aStack = null;
        if (aRecipe.mSpecialItems != null && aRecipe.mSpecialItems instanceof ItemStack[]) {
            ItemStack[] aTempStackArray = (ItemStack[])aRecipe.mSpecialItems;
            aStack = aTempStackArray[0];
        }
        return aStack;
    }

    private static boolean areDataOrbsEqual(ItemStack aOrb1, ItemStack aOrb2) {
        Materials tMaterial2;
        Materials tMaterial1;
        return aOrb1 != null && aOrb2 != null && (tMaterial1 = (Materials)Element.get((String)Behaviour_DataOrb.getDataName((ItemStack)aOrb1)).mLinkedMaterials.get(0)).equals(tMaterial2 = (Materials)Element.get((String)Behaviour_DataOrb.getDataName((ItemStack)aOrb2)).mLinkedMaterials.get(0));
    }

    public boolean doesBindPlayerInventory() {
        return false;
    }
}

