/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;
import team.chisel.carving.Carving;

public class GregtechMetaTileEntity_AutoChisel
extends GT_MetaTileEntity_BasicMachine {
    private ItemStack mInputCache;
    private ItemStack mOutputCache;

    public GregtechMetaTileEntity_AutoChisel(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, "Chisels things, Gregtech style", 1, 1, new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_MASSFAB_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_MASSFAB), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_MatterFab_Active), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_MatterFab), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB)});
    }

    public GregtechMetaTileEntity_AutoChisel(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_AutoChisel(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public String[] getDescription() {
        return (String[])ArrayUtils.addAll((Object[])this.mDescriptionArray, (Object[])new String[]{"What you want to chisel goes in slot 1", "What you want to get goes in the special slot (bottom right)", "If special slot is empty, first chisel result is used"});
    }

    public GT_Recipe.GT_Recipe_Map getRecipeList() {
        return null;
    }

    private boolean hasValidCache(ItemStack aStack, ItemStack aSpecialSlot, boolean aClearOnFailure) {
        if (this.mInputCache != null && this.mOutputCache != null && GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)this.mInputCache) && GT_Utility.areStacksEqual((ItemStack)aSpecialSlot, (ItemStack)this.mOutputCache)) {
            return true;
        }
        if (aClearOnFailure) {
            this.mInputCache = null;
            this.mOutputCache = null;
        }
        return false;
    }

    private void cacheItem(ItemStack mInputItem, ItemStack mOutputItem) {
        this.mOutputCache = mOutputItem.func_77946_l();
        this.mInputCache = mInputItem.func_77946_l();
    }

    protected boolean allowPutStackValidated(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return this.hasValidCache(aStack, this.getSpecialSlot(), false) ? true : super.allowPutStackValidated(aBaseMetaTileEntity, aIndex, side, aStack) && GregtechMetaTileEntity_AutoChisel.hasChiselResults(aStack);
    }

    private static boolean canBeMadeFrom(ItemStack from, ItemStack to) {
        List<ItemStack> results = GregtechMetaTileEntity_AutoChisel.getItemsForChiseling(from);
        for (ItemStack s : results) {
            if (s.func_77973_b() != to.func_77973_b() || s.func_77960_j() != to.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasChiselResults(ItemStack from) {
        List<ItemStack> results = GregtechMetaTileEntity_AutoChisel.getItemsForChiseling(from);
        return results.size() > 0;
    }

    private static List<ItemStack> getItemsForChiseling(ItemStack aStack) {
        return Carving.chisel.getItemsForChiseling(aStack);
    }

    private static ItemStack getChiselOutput(ItemStack aInput, ItemStack aTarget) {
        Object tOutput = null;
        tOutput = aTarget != null && GregtechMetaTileEntity_AutoChisel.canBeMadeFrom(aInput, aTarget) ? aTarget : (aTarget != null && !GregtechMetaTileEntity_AutoChisel.canBeMadeFrom(aInput, aTarget) ? null : GregtechMetaTileEntity_AutoChisel.getItemsForChiseling(aInput).get(0));
        return tOutput;
    }

    public int checkRecipe() {
        ItemStack tOutput = null;
        ItemStack aInput = this.getInputAt(0);
        ItemStack aTarget = this.getSpecialSlot();
        boolean tIsCached = this.hasValidCache(aInput, aTarget, true);
        if (aInput != null && GregtechMetaTileEntity_AutoChisel.hasChiselResults(aInput) && aInput.field_77994_a > 0) {
            ItemStack itemStack = tOutput = tIsCached ? this.mOutputCache.func_77946_l() : GregtechMetaTileEntity_AutoChisel.getChiselOutput(aInput, aTarget);
            if (tOutput != null) {
                tOutput = tOutput.func_77946_l();
                tOutput.field_77994_a = 1;
                if (this.canOutput(new ItemStack[]{tOutput})) {
                    --this.getInputAt((int)0).field_77994_a;
                    this.calculateOverclockedNess(16, 20);
                    if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                        return 1;
                    }
                    if (!tIsCached) {
                        this.cacheItem(ItemUtils.getSimpleStack(aInput, 1), ItemUtils.getSimpleStack(tOutput, 1));
                    }
                    this.mOutputItems[0] = tOutput.func_77946_l();
                    return 2;
                }
                ++this.mOutputBlocked;
                return 1;
            }
        }
        return 0;
    }

    public boolean useModularUI() {
        return true;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget((Widget)this.createProgressBar(GT_UITextures.PROGRESSBAR_COMPRESS, 20, ProgressBar.Direction.RIGHT, new Pos2d(78, 24), new Size(20, 18)));
    }

    protected SlotWidget createItemInputSlot(int index, IDrawable[] backgrounds, Pos2d pos) {
        return (SlotWidget)super.createItemInputSlot(index, backgrounds, pos).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_COMPRESSOR});
    }

    protected SlotWidget createSpecialSlot(IDrawable[] backgrounds, Pos2d pos) {
        return (SlotWidget)super.createSpecialSlot(backgrounds, pos).setGTTooltip(() -> this.mTooltipCache.getData("GTPP.machines.chisel_slot.tooltip", new Object[0]));
    }
}

