/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.forestry.bees.custom;

import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.IGT_RecipeMap;
import gregtech.api.util.GT_Recipe;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.item.base.ingots.BaseItemIngot_OLD;
import gtPlusPlus.core.item.base.misc.BaseItemMisc;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.forestry.bees.custom.GTPP_Bee_Definition;
import gtPlusPlus.xmod.forestry.bees.custom.ItemCustomComb;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.reflect.FieldUtils;

public class GTPP_Bees {
    public static Item dropForceGem;
    public static Item dropBiomassBlob;
    public static Item dropEthanolBlob;
    public static Item dropNikoliteDust;
    public static Item dropFluorineBlob;
    public static ItemCustomComb combs;
    public static ItemStack Comb_Slag;
    public static ItemStack Comb_Stone;
    public static Materials PTFE;
    public static Materials PBS;

    public GTPP_Bees() {
        if (Mods.Forestry.isModLoaded()) {
            this.setMaterials();
            this.setCustomItems();
            try {
                combs = new ItemCustomComb();
                combs.initCombsRecipes();
                GTPP_Bee_Definition.initBees();
            }
            catch (Throwable t) {
                Logger.BEES("Failed to load bees, probably due to an ancient forestry version");
                t.printStackTrace();
            }
        }
    }

    private void setCustomItems() {
        dropForceGem = new BaseItemMisc("Force", new short[]{250, 250, 20}, 64, BaseItemMisc.MiscTypes.GEM, null);
        dropBiomassBlob = new BaseItemMisc("Biomass", new short[]{33, 225, 24}, 64, BaseItemMisc.MiscTypes.DROP, null);
        dropEthanolBlob = new BaseItemMisc("Ethanol", new short[]{255, 128, 0}, 64, BaseItemMisc.MiscTypes.DROP, null);
        dropNikoliteDust = ItemUtils.generateSpecialUseDusts("Nikolite", "Nikolite", Utils.rgbtoHexValue(60, 180, 200))[2];
        if (ItemUtils.getItemStackOfAmountFromOreDictNoBroken("ingotNikolite", 1) == null) {
            new BaseItemIngot_OLD("itemIngotNikolite", "Nikolite", Utils.rgbtoHexValue(60, 180, 200), 0);
        }
        dropFluorineBlob = new BaseItemMisc("Fluorine", new short[]{30, 230, 230}, 64, BaseItemMisc.MiscTypes.DROP, null);
        this.addRecipes();
    }

    private void addRecipes() {
        this.addExtractorRecipe(ItemUtils.getSimpleStack(dropBiomassBlob), FluidUtils.getFluidStack("biomass", 30));
        this.addExtractorRecipe(ItemUtils.getSimpleStack(dropEthanolBlob), FluidUtils.getFluidStack("ethanol", 6));
        this.addExtractorRecipe(ItemUtils.getSimpleStack(dropFluorineBlob), FluidUtils.getFluidStack("fluorine", 4));
    }

    private void addExtractorRecipe(ItemStack input, FluidStack output) {
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{input}).fluidOutputs(new FluidStack[]{output}).duration(30).eut(8).addTo((IGT_RecipeMap)GT_Recipe.GT_Recipe_Map.sFluidExtractionRecipes);
    }

    private static boolean tryGetBeesBoolean() {
        try {
            Class<?> mProxy = Class.forName("gregtech.GT_Mod.gregtechproxy");
            Field mNerf = FieldUtils.getDeclaredField(mProxy, (String)"mGTBees", (boolean)true);
            boolean returnValue = (Boolean)mNerf.get(GT_Mod.gregtechproxy);
            return returnValue;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException e) {
            return false;
        }
    }

    private void setMaterials() {
        try {
            Class<?> gtBees = Class.forName("gregtech.loaders.misc.GT_Bees");
            Class<?> gtCombItemClass = Class.forName("gregtech.common.items.ItemComb");
            Class<?> gtCombEnumClass = Class.forName("gregtech.common.items.CombType");
            Field gtCombs = FieldUtils.getDeclaredField(gtBees, (String)"combs", (boolean)true);
            gtCombs.setAccessible(true);
            ReflectionUtils.makeFieldAccessible(gtCombs);
            Object gtCombTypeSlag = Enum.valueOf(gtCombEnumClass, "SLAG");
            Object gtCombTypeStone = Enum.valueOf(gtCombEnumClass, "STONE");
            Object oCombObject = gtCombs.get(null);
            Logger.DEBUG_BEES("Field getModifiers: " + gtCombs.getModifiers());
            Logger.DEBUG_BEES("Field toGenericString: " + gtCombs.toGenericString());
            Logger.DEBUG_BEES("Field getClass: " + gtCombs.getClass());
            Logger.DEBUG_BEES("Field isEnumConstant: " + gtCombs.isEnumConstant());
            Logger.DEBUG_BEES("Field isSynthetic: " + gtCombs.isSynthetic());
            Logger.DEBUG_BEES("Field get(gtBees) != null: " + (gtCombs.get(gtBees) != null));
            Logger.DEBUG_BEES("Field isAccessible: " + gtCombs.isAccessible());
            Logger.BEES("gtBees: " + (gtBees != null));
            Logger.BEES("gtCombItemClass: " + (gtCombItemClass != null));
            Logger.BEES("gtCombEnumClass: " + (gtCombEnumClass != null));
            Logger.BEES("gtCombs: " + (gtCombs != null));
            Logger.BEES("gtCombTypeSlag: " + (gtCombTypeSlag != null));
            Logger.BEES("gtCombTypeStone: " + (gtCombTypeStone != null));
            Logger.BEES("oCombObject: " + (oCombObject != null));
            Method getStackForType = gtCombItemClass.getDeclaredMethod("getStackForType", gtCombEnumClass);
            if (getStackForType != null) {
                Logger.BEES("Found Method: getStackForType");
            }
            if (Comb_Slag == null) {
                Comb_Slag = (ItemStack)getStackForType.invoke(gtBees, gtCombTypeSlag);
            }
            if (Comb_Stone == null) {
                Comb_Stone = (ItemStack)getStackForType.invoke(gtBees, gtCombTypeStone);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException e) {
            Logger.BEES("Bad Reflection. setMaterials()");
        }
        PTFE = this.trySetValue("Polytetrafluoroethylene");
        PBS = this.trySetValue("StyreneButadieneRubber");
    }

    private Materials trySetValue(String material) {
        Materials mTemp = Materials.get((String)material);
        if (mTemp != Materials._NULL) {
            return mTemp;
        }
        return Materials._NULL;
    }
}

