/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.enums.GT_Values;
import gregtech.common.power.FusionPower;
import gregtech.nei.FusionSpecialValueFormatter;

public class AdvFusionPower
extends FusionPower {
    public AdvFusionPower(byte tier, int startupPower) {
        super(tier, startupPower);
    }

    public void computePowerUsageAndDuration(int euPerTick, int duration, int specialValue) {
        this.originalVoltage = this.computeVoltageForEuRate(euPerTick);
        this.recipeEuPerTick = euPerTick;
        this.recipeDuration = duration;
        if (this.tier > 0) {
            int maxPossibleOverclocks = FusionSpecialValueFormatter.getFusionTier((int)this.specialValue, (long)GT_Values.V[this.tier - 1]) - FusionSpecialValueFormatter.getFusionTier((int)specialValue, (long)euPerTick);
            long tempEUt = Math.max((long)euPerTick, GT_Values.V[1]);
            this.recipeDuration = duration;
            while (tempEUt <= GT_Values.V[this.tier - 1] * (long)this.amperage && maxPossibleOverclocks-- > 0 && this.recipeDuration > 1) {
                tempEUt <<= 2;
                this.recipeDuration >>= 2;
            }
            if (tempEUt > 0x7FFFFFFEL) {
                this.recipeEuPerTick = 0x7FFFFFFE;
                this.recipeDuration = 0x7FFFFFFE;
            } else {
                this.recipeEuPerTick = (int)tempEUt;
                if (this.recipeEuPerTick == 0) {
                    this.recipeEuPerTick = 1;
                }
                if (this.recipeDuration == 0) {
                    this.recipeDuration = 1;
                }
            }
        }
        this.wasOverclocked = this.checkIfOverclocked();
    }
}

