/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.core.impl.Pair;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Advanced;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.PresenceSettingsGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.CheckBoxControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.SelectorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextDisplayWidget;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextWidget;
import net.minecraft.client.gui.GuiScreen;

public class AdvancedSettingsGui
extends ConfigurationGui<Advanced> {
    private final Advanced INSTANCE;
    private final Advanced DEFAULTS = this.getCurrentData().getDefaults();
    private ExtendedButtonControl guiMessagesButton;
    private ExtendedButtonControl itemMessagesButton;
    private ExtendedButtonControl entityTargetMessagesButton;
    private ExtendedButtonControl entityRidingMessagesButton;
    private CheckBoxControl enablePerGuiButton;
    private CheckBoxControl enablePerItemButton;
    private CheckBoxControl enablePerEntityButton;
    private CheckBoxControl formatWordsButton;
    private CheckBoxControl debugModeButton;
    private CheckBoxControl verboseModeButton;
    private CheckBoxControl allowPlaceholderPreviewsButton;
    private CheckBoxControl allowEndpointIconsButton;
    private CheckBoxControl allowDuplicatePacketsButton;
    private ExtendedTextControl refreshRate;
    private ExtendedTextControl maxConnectionAttempts;
    private ExtendedTextControl playerSkinEndpoint;
    private ExtendedTextControl serverIconEndpoint;

    AdvancedSettingsGui(GuiScreen parentScreen) {
        super(parentScreen, "gui.config.title", "gui.config.title.advanced");
        this.INSTANCE = this.getCurrentData().copy();
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        int calc1 = this.getScreenWidth() / 2 - 160;
        int calc2 = this.getScreenWidth() / 2 + 3;
        this.refreshRate = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(0), 160, 20, "gui.config.name.advanced.refresh_rate", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.advanced.refresh_rate", new Object[0])))));
        this.refreshRate.setControlMessage(Integer.toString(this.getCurrentData().refreshRate));
        this.maxConnectionAttempts = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(1), 160, 20, "gui.config.name.advanced.max_connection_attempts", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.advanced.max_connection_attempts", new Object[0])))));
        this.maxConnectionAttempts.setControlMessage(Integer.toString(this.getCurrentData().maxConnectionAttempts));
        this.guiMessagesButton = this.childFrame.addControl(new ExtendedButtonControl(calc1, this.getButtonY(2), 160, 20, "gui.config.name.advanced.gui_messages", () -> this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.gui", new Object[0]), CraftPresence.GUIS.GUI_NAMES, null, null, true, true, ScrollableListControl.RenderType.None, null, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((GuiScreen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getCurrentData().guiSettings.guiData.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getCurrentData().guiSettings.guiData.get("default");
            screenInstance.currentData = this.getCurrentData().guiSettings.guiData.get(attributeName);
            screenInstance.isPreliminaryData = screenInstance.currentData == null;
            screenInstance.mainTitle = Constants.TRANSLATOR.translate("gui.config.title.gui.edit_specific_gui", attributeName);
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
        }, (screenInstance, attributeName, inputText) -> {
            screenInstance.currentData.setTextOverride((String)inputText);
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().guiSettings.guiData.put((String)attributeName, screenInstance.currentData);
            if (!CraftPresence.GUIS.GUI_NAMES.contains(attributeName)) {
                CraftPresence.GUIS.GUI_NAMES.add((String)attributeName);
            }
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().guiSettings.guiData.remove(attributeName);
            if (!CraftPresence.GUIS.DEFAULT_NAMES.contains(attributeName)) {
                CraftPresence.GUIS.GUI_NAMES.remove(attributeName);
            }
        }, (attributeName, screenInstance, isPresenceButton) -> {
            if (isPresenceButton.booleanValue()) {
                PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                this.openScreen(new PresenceSettingsGui((GuiScreen)screenInstance, currentPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
            } else {
                String defaultIcon = Config.getProperty(screenInstance.defaultData, "iconOverride") != null ? screenInstance.defaultData.getIconOverride() : this.getCurrentData().guiSettings.fallbackGuiIcon;
                String specificIcon = Config.getProperty(screenInstance.currentData, "iconOverride") != null ? screenInstance.currentData.getIconOverride() : defaultIcon;
                this.openScreen(new SelectorGui((GuiScreen)screenInstance, Constants.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), specificIcon, (String)attributeName, true, false, ScrollableListControl.RenderType.DiscordAsset, (innerAttributeName, innerCurrentValue) -> screenInstance.currentData.setIconOverride((String)innerCurrentValue), null));
            }
        }, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.advanced.gui_messages", CraftPresence.CLIENT.generateArgumentMessage("screen."))))))).setIdentifierType(ScrollableListControl.IdentifierType.Gui)), () -> {
            if (!this.guiMessagesButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.access", Constants.TRANSLATOR.translate("gui.config.name.advanced.enable_per_gui", new Object[0]))));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.advanced.gui_messages", CraftPresence.CLIENT.generateArgumentMessage("screen."))));
            }
        }, new String[0]));
        this.itemMessagesButton = this.childFrame.addControl(new ExtendedButtonControl(calc2, this.getButtonY(2), 160, 20, "gui.config.name.advanced.item_messages", () -> this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.item", new Object[0]), CraftPresence.TILE_ENTITIES.TILE_ENTITY_NAMES, null, null, true, true, ScrollableListControl.RenderType.ItemData, null, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((GuiScreen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage = this.getCurrentData().itemMessages.getOrDefault("default", "");
        }, (attributeName, screenInstance) -> {
            screenInstance.mainTitle = Constants.TRANSLATOR.translate("gui.config.title.item.edit_specific_item", attributeName);
            screenInstance.originalPrimaryMessage = this.getCurrentData().itemMessages.getOrDefault("default", "");
            screenInstance.primaryMessage = this.getCurrentData().itemMessages.getOrDefault(attributeName, screenInstance.originalPrimaryMessage);
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().itemMessages.put((String)attributeName, (String)inputText);
            if (!CraftPresence.TILE_ENTITIES.ITEM_NAMES.contains(attributeName)) {
                CraftPresence.TILE_ENTITIES.ITEM_NAMES.add((String)attributeName);
            }
            if (!CraftPresence.TILE_ENTITIES.BLOCK_NAMES.contains(attributeName)) {
                CraftPresence.TILE_ENTITIES.BLOCK_NAMES.add((String)attributeName);
            }
            CraftPresence.TILE_ENTITIES.TILE_ENTITY_NAMES.remove(attributeName);
            CraftPresence.TILE_ENTITIES.verifyEntities();
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().itemMessages.remove(attributeName);
            CraftPresence.TILE_ENTITIES.ITEM_NAMES.remove(attributeName);
            CraftPresence.TILE_ENTITIES.BLOCK_NAMES.remove(attributeName);
            CraftPresence.TILE_ENTITIES.TILE_ENTITY_NAMES.remove(attributeName);
        }, null, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.advanced.item_messages", CraftPresence.CLIENT.generateArgumentMessage("item.")))))))), () -> {
            if (!this.itemMessagesButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.access", Constants.TRANSLATOR.translate("gui.config.name.advanced.enable_per_item", new Object[0]))));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.advanced.item_messages", CraftPresence.CLIENT.generateArgumentMessage("item."))));
            }
        }, new String[0]));
        this.entityTargetMessagesButton = this.childFrame.addControl(new ExtendedButtonControl(calc1, this.getButtonY(3), 160, 20, "gui.config.name.advanced.entity_target_messages", () -> this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.entity", new Object[0]), CraftPresence.ENTITIES.ENTITY_NAMES, null, null, true, true, ScrollableListControl.RenderType.EntityData, null, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((GuiScreen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getCurrentData().entitySettings.targetData.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getCurrentData().entitySettings.targetData.get("default");
            screenInstance.currentData = this.getCurrentData().entitySettings.targetData.get(attributeName);
            screenInstance.isPreliminaryData = screenInstance.currentData == null;
            screenInstance.mainTitle = Constants.TRANSLATOR.translate("gui.config.title.entity.edit_specific_entity", attributeName);
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
        }, (screenInstance, attributeName, inputText) -> {
            screenInstance.currentData.setTextOverride((String)inputText);
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().entitySettings.targetData.put((String)attributeName, screenInstance.currentData);
            if (!CraftPresence.ENTITIES.ENTITY_NAMES.contains(attributeName)) {
                CraftPresence.ENTITIES.ENTITY_NAMES.add((String)attributeName);
            }
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().entitySettings.targetData.remove(attributeName);
            if (!CraftPresence.ENTITIES.DEFAULT_NAMES.contains(attributeName)) {
                CraftPresence.ENTITIES.ENTITY_NAMES.remove(attributeName);
            }
        }, (attributeName, screenInstance, isPresenceButton) -> {
            if (isPresenceButton.booleanValue()) {
                PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                this.openScreen(new PresenceSettingsGui((GuiScreen)screenInstance, currentPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
            } else {
                String defaultIcon = Config.getProperty(screenInstance.defaultData, "iconOverride") != null ? screenInstance.defaultData.getIconOverride() : this.getCurrentData().entitySettings.fallbackEntityIcon;
                String specificIcon = Config.getProperty(screenInstance.currentData, "iconOverride") != null ? screenInstance.currentData.getIconOverride() : defaultIcon;
                this.openScreen(new SelectorGui((GuiScreen)screenInstance, Constants.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), specificIcon, (String)attributeName, true, false, ScrollableListControl.RenderType.DiscordAsset, (innerAttributeName, innerCurrentValue) -> screenInstance.currentData.setIconOverride((String)innerCurrentValue), null));
            }
        }, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.advanced.entity_target_messages", CraftPresence.CLIENT.generateArgumentMessage("entity.target.")))))))), () -> {
            if (!this.entityTargetMessagesButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.access", Constants.TRANSLATOR.translate("gui.config.name.advanced.enable_per_entity", new Object[0]))));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.advanced.entity_target_messages", CraftPresence.CLIENT.generateArgumentMessage("entity.target."))));
            }
        }, new String[0]));
        this.entityRidingMessagesButton = this.childFrame.addControl(new ExtendedButtonControl(calc2, this.getButtonY(3), 160, 20, "gui.config.name.advanced.entity_riding_messages", () -> this.openScreen(new SelectorGui(this.currentScreen, Constants.TRANSLATOR.translate("gui.config.title.selector.entity", new Object[0]), CraftPresence.ENTITIES.ENTITY_NAMES, null, null, true, true, ScrollableListControl.RenderType.EntityData, null, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((GuiScreen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getCurrentData().entitySettings.ridingData.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getCurrentData().entitySettings.ridingData.get("default");
            screenInstance.currentData = this.getCurrentData().entitySettings.ridingData.get(attributeName);
            screenInstance.isPreliminaryData = screenInstance.currentData == null;
            screenInstance.mainTitle = Constants.TRANSLATOR.translate("gui.config.title.entity.edit_specific_entity", attributeName);
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
        }, (screenInstance, attributeName, inputText) -> {
            screenInstance.currentData.setTextOverride((String)inputText);
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().entitySettings.ridingData.put((String)attributeName, screenInstance.currentData);
            if (!CraftPresence.ENTITIES.ENTITY_NAMES.contains(attributeName)) {
                CraftPresence.ENTITIES.ENTITY_NAMES.add((String)attributeName);
            }
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().entitySettings.ridingData.remove(attributeName);
            if (!CraftPresence.ENTITIES.DEFAULT_NAMES.contains(attributeName)) {
                CraftPresence.ENTITIES.ENTITY_NAMES.remove(attributeName);
            }
        }, (attributeName, screenInstance, isPresenceButton) -> {
            if (isPresenceButton.booleanValue()) {
                PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                this.openScreen(new PresenceSettingsGui((GuiScreen)screenInstance, currentPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
            } else {
                String defaultIcon = Config.getProperty(screenInstance.defaultData, "iconOverride") != null ? screenInstance.defaultData.getIconOverride() : this.getCurrentData().entitySettings.fallbackEntityIcon;
                String specificIcon = Config.getProperty(screenInstance.currentData, "iconOverride") != null ? screenInstance.currentData.getIconOverride() : defaultIcon;
                this.openScreen(new SelectorGui((GuiScreen)screenInstance, Constants.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), specificIcon, (String)attributeName, true, false, ScrollableListControl.RenderType.DiscordAsset, (innerAttributeName, innerCurrentValue) -> screenInstance.currentData.setIconOverride((String)innerCurrentValue), null));
            }
        }, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.advanced.entity_riding_messages", CraftPresence.CLIENT.generateArgumentMessage("entity.riding.")))))))), () -> {
            if (!this.entityRidingMessagesButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.access", Constants.TRANSLATOR.translate("gui.config.name.advanced.enable_per_entity", new Object[0]))));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.advanced.entity_riding_messages", CraftPresence.CLIENT.generateArgumentMessage("entity.riding."))));
            }
        }, new String[0]));
        this.enablePerGuiButton = this.childFrame.addControl(new CheckBoxControl(calc1, this.getButtonY(4), "gui.config.name.advanced.enable_per_gui", this.getCurrentData().enablePerGui, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.advanced.enable_per_gui", new Object[0])))));
        this.enablePerItemButton = this.childFrame.addControl(new CheckBoxControl(calc2, this.getButtonY(4), "gui.config.name.advanced.enable_per_item", this.getCurrentData().enablePerItem, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.advanced.enable_per_item", new Object[0])))));
        this.enablePerEntityButton = this.childFrame.addControl(new CheckBoxControl(calc1, this.getButtonY(5, -10), "gui.config.name.advanced.enable_per_entity", this.getCurrentData().enablePerEntity, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.advanced.enable_per_entity", new Object[0])))));
        this.debugModeButton = this.childFrame.addControl(new CheckBoxControl(calc2, this.getButtonY(5, -10), "gui.config.name.advanced.debug_mode", this.getCurrentData().debugMode, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.advanced.debug_mode", Constants.IS_DEV_FLAG)))));
        this.formatWordsButton = this.childFrame.addControl(new CheckBoxControl(calc1, this.getButtonY(6, -20), "gui.config.name.advanced.format_words", this.getCurrentData().formatWords, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.advanced.format_words", new Object[0])))));
        this.verboseModeButton = this.childFrame.addControl(new CheckBoxControl(calc2, this.getButtonY(6, -20), "gui.config.name.advanced.verbose_mode", this.getCurrentData().verboseMode, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.advanced.verbose_mode", Constants.IS_VERBOSE_FLAG)))));
        this.allowPlaceholderPreviewsButton = this.childFrame.addControl(new CheckBoxControl(calc1, this.getButtonY(7, -30), "gui.config.name.advanced.allow_placeholder_previews", this.getCurrentData().allowPlaceholderPreviews, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.advanced.allow_placeholder_previews", new Object[0])))));
        this.allowEndpointIconsButton = this.childFrame.addControl(new CheckBoxControl(calc2, this.getButtonY(7, -30), "gui.config.name.advanced.allow_endpoint_icons", this.getCurrentData().allowEndpointIcons, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.advanced.allow_endpoint_icons", new Object[0])))));
        this.allowDuplicatePacketsButton = this.childFrame.addControl(new CheckBoxControl(calc1, this.getButtonY(8, -40), "gui.config.name.advanced.allow_duplicate_packets", this.getCurrentData().allowDuplicatePackets, null, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.advanced.allow_duplicate_packets", new Object[0])))));
        this.proceedButton.setOnHover(() -> {
            if (!this.proceedButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])));
            }
        });
        this.childFrame.addWidget(new TextDisplayWidget(this.childFrame, false, calc1, this.getButtonY(7), this.getScreenWidth(), Constants.TRANSLATOR.translate("gui.config.message.endpoints", new Object[0])));
        this.playerSkinEndpoint = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(8), 160, 20, "gui.config.name.advanced.player_skin_endpoint", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.advanced.player_skin_endpoint", new Object[0])))));
        this.playerSkinEndpoint.setControlMessage(this.getCurrentData().playerSkinEndpoint);
        this.serverIconEndpoint = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(9), 160, 20, "gui.config.name.advanced.server_icon_endpoint", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.comment.advanced.server_icon_endpoint", new Object[0])))));
        this.serverIconEndpoint.setControlMessage(this.getCurrentData().serverIconEndpoint);
    }

    @Override
    protected boolean canReset() {
        return !this.getCurrentData().equals(this.DEFAULTS);
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected boolean resetData() {
        return this.setCurrentData(this.DEFAULTS);
    }

    @Override
    protected boolean canSync() {
        return true;
    }

    @Override
    protected boolean allowedToSync() {
        return true;
    }

    @Override
    protected boolean syncData() {
        return this.setCurrentData(Config.loadOrCreate().advancedSettings);
    }

    @Override
    protected void syncRenderStates() {
        super.syncRenderStates();
        Pair<Boolean, Integer> refreshRateData = StringUtils.getValidInteger(this.refreshRate.getControlMessage());
        this.proceedButton.setControlEnabled(refreshRateData.getFirst() != false && refreshRateData.getSecond() >= 2);
        this.guiMessagesButton.setControlEnabled(CraftPresence.GUIS.enabled);
        this.itemMessagesButton.setControlEnabled(CraftPresence.TILE_ENTITIES.enabled);
        this.entityTargetMessagesButton.setControlEnabled(CraftPresence.ENTITIES.enabled);
        this.entityRidingMessagesButton.setControlEnabled(CraftPresence.ENTITIES.enabled);
    }

    @Override
    protected void applySettings() {
        if (this.allowEndpointIconsButton.isChecked() != this.getCurrentData().allowEndpointIcons) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().allowEndpointIcons = this.allowEndpointIconsButton.isChecked();
        }
        if (!this.refreshRate.getControlMessage().equals(Integer.toString(this.getCurrentData().refreshRate))) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().refreshRate = StringUtils.getValidInteger(this.refreshRate.getControlMessage()).getSecond();
        }
        if (!this.maxConnectionAttempts.getControlMessage().equals(Integer.toString(this.getCurrentData().maxConnectionAttempts))) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().maxConnectionAttempts = StringUtils.getValidInteger(this.maxConnectionAttempts.getControlMessage()).getSecond();
        }
        if (this.enablePerGuiButton.isChecked() != this.getCurrentData().enablePerGui) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().enablePerGui = this.enablePerGuiButton.isChecked();
        }
        if (this.enablePerItemButton.isChecked() != this.getCurrentData().enablePerItem) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().enablePerItem = this.enablePerItemButton.isChecked();
        }
        if (this.enablePerEntityButton.isChecked() != this.getCurrentData().enablePerEntity) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().enablePerEntity = this.enablePerEntityButton.isChecked();
        }
        if (this.formatWordsButton.isChecked() != this.getCurrentData().formatWords) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().formatWords = this.formatWordsButton.isChecked();
        }
        if (this.debugModeButton.isChecked() != this.getCurrentData().debugMode) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().debugMode = this.debugModeButton.isChecked();
        }
        if (this.verboseModeButton.isChecked() != this.getCurrentData().verboseMode) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().verboseMode = this.verboseModeButton.isChecked();
        }
        if (this.allowPlaceholderPreviewsButton.isChecked() != this.getCurrentData().allowPlaceholderPreviews) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().allowPlaceholderPreviews = this.allowPlaceholderPreviewsButton.isChecked();
        }
        if (this.allowDuplicatePacketsButton.isChecked() != this.getCurrentData().allowDuplicatePackets) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().allowDuplicatePackets = this.allowDuplicatePacketsButton.isChecked();
        }
        if (!this.playerSkinEndpoint.getControlMessage().equals(this.getCurrentData().playerSkinEndpoint)) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().playerSkinEndpoint = this.playerSkinEndpoint.getControlMessage();
        }
        if (!this.serverIconEndpoint.getControlMessage().equals(this.getCurrentData().serverIconEndpoint)) {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().serverIconEndpoint = this.serverIconEndpoint.getControlMessage();
        }
    }

    @Override
    protected Advanced getOriginalData() {
        return this.INSTANCE;
    }

    @Override
    protected Advanced getCurrentData() {
        return CraftPresence.CONFIG.advancedSettings;
    }

    @Override
    protected boolean setCurrentData(Advanced data) {
        if (!this.getCurrentData().equals(data)) {
            this.getCurrentData().transferFrom(data);
            CraftPresence.CONFIG.hasChanged = true;
            return true;
        }
        return false;
    }
}

