/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc.client;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import li.cil.oc.api.event.RobotRenderEvent;
import li.cil.oc.api.internal.Robot;
import li.cil.oc.client.renderer.PetRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.opengl.GL11;
import pl.asie.computronics.client.model.ModelRadar;
import pl.asie.computronics.item.ItemOpenComputers;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.util.internal.Triple;

public class UpgradeRenderer {
    private final ResourceLocation upgradeRadar = new ResourceLocation("computronics", "textures/models/UpgradeRadar.png");
    private final ResourceLocation modelRadar = new ResourceLocation("computronics", "textures/models/ModelRadar.png");
    private final ResourceLocation upgradeChatBox = new ResourceLocation("computronics", "textures/models/UpgradeChatBox.png");
    private final ResourceLocation beepCard = new ResourceLocation("computronics", "textures/models/CardBeep.png");
    AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)-0.1, (double)-0.1, (double)-0.1, (double)0.1, (double)0.1, (double)0.1);
    private static final List<Integer> upgrades = Arrays.asList(1, 2, 5, 8);
    private ModelRadar radarModel = new ModelRadar();
    private final HashMap<String, Triple> entitledPlayers;
    private final Triple WHITE;
    private boolean rendering = false;
    private long time = -1L;
    private Triple color;

    @Optional.Method(modid="OpenComputers")
    private boolean isUpgrade(ItemStack stack) {
        return stack != null && stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemOpenComputers && upgrades.contains(stack.func_77960_j());
    }

    @Optional.Method(modid="OpenComputers")
    public String computePreferredMountPoint(ItemStack stack, Robot robot, Set<String> availableMountPoints) {
        switch (stack.func_77960_j()) {
            case 1: {
                return "any";
            }
            case 2: {
                return availableMountPoints.contains("top_right") ? "top_right" : (availableMountPoints.contains("top_left") ? "top_left" : "any");
            }
            case 5: 
            case 8: {
                return availableMountPoints.contains("bottom_front") ? "bottom_front" : (availableMountPoints.contains("bottom_back") ? "bottom_back" : "any");
            }
        }
        return "none";
    }

    @Optional.Method(modid="OpenComputers")
    public void render(ItemStack stack, RobotRenderEvent.MountPoint mountPoint, Robot robot, float pt) {
        if (!this.isUpgrade(stack)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        TextureManager tm = mc.func_110434_K();
        switch (stack.func_77960_j()) {
            case 1: {
                tm.func_110577_a(this.upgradeChatBox);
                this.drawSimpleBlock(mountPoint, 0.0f, true);
                break;
            }
            case 2: {
                if (mountPoint.name.equals("top_left") || mountPoint.name.equals("top_right")) {
                    float degrees;
                    float f = degrees = robot.shouldAnimate() ? ((float)((robot.world().func_82737_E() + (long)(robot.hashCode() ^ 0xFF)) % 160L) + pt) / 160.0f * 360.0f : 0.0f;
                    if (mountPoint.name.equals("top_right")) {
                        degrees = 360.0f - degrees;
                    }
                    GL11.glPushAttrib((int)1048575);
                    tm.func_110577_a(this.modelRadar);
                    GL11.glDisable((int)2884);
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)mountPoint.rotation.getW(), (float)mountPoint.rotation.getX(), (float)mountPoint.rotation.getY(), (float)mountPoint.rotation.getZ());
                    GL11.glTranslatef((float)0.0f, (float)-0.8f, (float)0.0f);
                    GL11.glTranslatef((float)mountPoint.offset.getX(), (float)mountPoint.offset.getY(), (float)mountPoint.offset.getZ());
                    GL11.glScalef((float)0.3f, (float)0.3f, (float)0.3f);
                    GL11.glPushMatrix();
                    this.radarModel.render(Math.max(degrees, 0.0f));
                    GL11.glPopMatrix();
                    GL11.glPopAttrib();
                    break;
                }
                tm.func_110577_a(this.upgradeRadar);
                this.drawSimpleBlock(mountPoint, 0.0f, true);
                break;
            }
            case 5: 
            case 8: {
                tm.func_110577_a(this.beepCard);
                this.drawSimpleBlock(mountPoint, 0.0f, true);
            }
        }
    }

    @Optional.Method(modid="OpenComputers")
    private void drawSimpleBlock(RobotRenderEvent.MountPoint mountPoint, float frontOffset, boolean separateTopBottomTextures) {
        GL11.glRotatef((float)mountPoint.rotation.getW(), (float)mountPoint.rotation.getX(), (float)mountPoint.rotation.getY(), (float)mountPoint.rotation.getZ());
        GL11.glTranslatef((float)mountPoint.offset.getX(), (float)mountPoint.offset.getY(), (float)mountPoint.offset.getZ());
        GL11.glBegin((int)7);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTexCoord2f((float)frontOffset, (float)0.5f);
        GL11.glVertex3d((double)this.bounds.field_72340_a, (double)this.bounds.field_72338_b, (double)this.bounds.field_72334_f);
        GL11.glTexCoord2f((float)(frontOffset + 0.5f), (float)0.5f);
        GL11.glVertex3d((double)this.bounds.field_72336_d, (double)this.bounds.field_72338_b, (double)this.bounds.field_72334_f);
        GL11.glTexCoord2f((float)(frontOffset + 0.5f), (float)0.0f);
        GL11.glVertex3d((double)this.bounds.field_72336_d, (double)this.bounds.field_72337_e, (double)this.bounds.field_72334_f);
        GL11.glTexCoord2f((float)frontOffset, (float)0.0f);
        GL11.glVertex3d((double)this.bounds.field_72340_a, (double)this.bounds.field_72337_e, (double)this.bounds.field_72334_f);
        if (!separateTopBottomTextures) {
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)0.5f);
            GL11.glVertex3d((double)this.bounds.field_72336_d, (double)this.bounds.field_72337_e, (double)this.bounds.field_72334_f);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3d((double)this.bounds.field_72336_d, (double)this.bounds.field_72337_e, (double)this.bounds.field_72339_c);
            GL11.glTexCoord2f((float)0.5f, (float)1.0f);
            GL11.glVertex3d((double)this.bounds.field_72340_a, (double)this.bounds.field_72337_e, (double)this.bounds.field_72339_c);
            GL11.glTexCoord2f((float)0.5f, (float)0.5f);
            GL11.glVertex3d((double)this.bounds.field_72340_a, (double)this.bounds.field_72337_e, (double)this.bounds.field_72334_f);
        } else {
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3d((double)this.bounds.field_72336_d, (double)this.bounds.field_72337_e, (double)this.bounds.field_72334_f);
            GL11.glTexCoord2f((float)1.0f, (float)0.5f);
            GL11.glVertex3d((double)this.bounds.field_72336_d, (double)this.bounds.field_72337_e, (double)this.bounds.field_72339_c);
            GL11.glTexCoord2f((float)0.5f, (float)0.5f);
            GL11.glVertex3d((double)this.bounds.field_72340_a, (double)this.bounds.field_72337_e, (double)this.bounds.field_72339_c);
            GL11.glTexCoord2f((float)0.5f, (float)0.0f);
            GL11.glVertex3d((double)this.bounds.field_72340_a, (double)this.bounds.field_72337_e, (double)this.bounds.field_72334_f);
        }
        GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.5f, (float)0.5f);
        GL11.glVertex3d((double)this.bounds.field_72340_a, (double)this.bounds.field_72338_b, (double)this.bounds.field_72334_f);
        GL11.glTexCoord2f((float)0.5f, (float)1.0f);
        GL11.glVertex3d((double)this.bounds.field_72340_a, (double)this.bounds.field_72338_b, (double)this.bounds.field_72339_c);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3d((double)this.bounds.field_72336_d, (double)this.bounds.field_72338_b, (double)this.bounds.field_72339_c);
        GL11.glTexCoord2f((float)1.0f, (float)0.5f);
        GL11.glVertex3d((double)this.bounds.field_72336_d, (double)this.bounds.field_72338_b, (double)this.bounds.field_72334_f);
        GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.5f);
        GL11.glVertex3d((double)this.bounds.field_72336_d, (double)this.bounds.field_72337_e, (double)this.bounds.field_72334_f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3d((double)this.bounds.field_72336_d, (double)this.bounds.field_72338_b, (double)this.bounds.field_72334_f);
        GL11.glTexCoord2f((float)0.5f, (float)1.0f);
        GL11.glVertex3d((double)this.bounds.field_72336_d, (double)this.bounds.field_72338_b, (double)this.bounds.field_72339_c);
        GL11.glTexCoord2f((float)0.5f, (float)0.5f);
        GL11.glVertex3d((double)this.bounds.field_72336_d, (double)this.bounds.field_72337_e, (double)this.bounds.field_72339_c);
        GL11.glNormal3f((float)-1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3d((double)this.bounds.field_72340_a, (double)this.bounds.field_72338_b, (double)this.bounds.field_72334_f);
        GL11.glTexCoord2f((float)0.0f, (float)0.5f);
        GL11.glVertex3d((double)this.bounds.field_72340_a, (double)this.bounds.field_72337_e, (double)this.bounds.field_72334_f);
        GL11.glTexCoord2f((float)0.5f, (float)0.5f);
        GL11.glVertex3d((double)this.bounds.field_72340_a, (double)this.bounds.field_72337_e, (double)this.bounds.field_72339_c);
        GL11.glTexCoord2f((float)0.5f, (float)1.0f);
        GL11.glVertex3d((double)this.bounds.field_72340_a, (double)this.bounds.field_72338_b, (double)this.bounds.field_72339_c);
        GL11.glEnd();
    }

    public UpgradeRenderer() {
        if (!Mods.isLoaded("OpenComputers")) {
            this.entitledPlayers = null;
            this.WHITE = null;
            return;
        }
        this.entitledPlayers = new HashMap();
        this.WHITE = new Triple(1.0f, 1.0f, 1.0f);
        this.entitledPlayers.put("f3ba6ec8-c280-4950-bb08-1fcb2eab3a9c", this.WHITE);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    @Optional.Method(modid="OpenComputers")
    public void onPlayerTickPre(RenderPlayerEvent.Pre e) {
        String uuid = e.entityPlayer.func_110124_au().toString();
        if (PetRenderer.hidden().contains((Object)uuid) || !this.entitledPlayers.containsKey(uuid)) {
            return;
        }
        this.rendering = true;
        this.time = e.entityPlayer.func_130014_f_().func_82737_E() + (long)(e.entityPlayer.hashCode() ^ 0xFF);
        this.color = this.entitledPlayers.get(uuid);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @Optional.Method(modid="OpenComputers")
    public void onRobotRender(RobotRenderEvent e) {
        if (!this.rendering) {
            return;
        }
        if (e.mountPoints == null || e.mountPoints.length < 2) {
            return;
        }
        RobotRenderEvent.MountPoint mountPoint = e.mountPoints[1];
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glColor3f((float)this.color.r, (float)this.color.g, (float)this.color.b);
        float degrees = 360.0f - (float)(this.time % 160L) / 160.0f * 360.0f;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.modelRadar);
        GL11.glDisable((int)2884);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)mountPoint.rotation.getW(), (float)mountPoint.rotation.getX(), (float)mountPoint.rotation.getY(), (float)mountPoint.rotation.getZ());
        GL11.glTranslatef((float)0.0f, (float)-0.8f, (float)0.0f);
        GL11.glTranslatef((float)mountPoint.offset.getX(), (float)mountPoint.offset.getY(), (float)mountPoint.offset.getZ());
        GL11.glScalef((float)0.3f, (float)0.3f, (float)0.3f);
        GL11.glPushMatrix();
        this.radarModel.render(Math.max(degrees, 0.0f));
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    @Optional.Method(modid="OpenComputers")
    public void onPlayerTickPost(RenderPlayerEvent.Pre e) {
        if (this.rendering) {
            this.rendering = false;
            this.time = -1L;
            this.color = this.WHITE;
        }
    }
}

