/*
 * Decompiled with CFR 0.152.
 */
package com.caedis.duradisplay.utils;

import java.util.Objects;

public final class DurabilityLikeInfo {
    public final double current;
    public final double max;

    public DurabilityLikeInfo(double current, double max) {
        this.current = current;
        this.max = max;
    }

    public boolean isFull() {
        return this.current != 0.0 && this.current == this.max;
    }

    public boolean isEmpty() {
        return this.current == 0.0 && this.max != 0.0;
    }

    public boolean isNaN() {
        return this.current == 0.0 && this.max == 0.0;
    }

    public double percent() {
        return this.current / this.max;
    }

    public double current() {
        return this.current;
    }

    public double max() {
        return this.max;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DurabilityLikeInfo that = (DurabilityLikeInfo)obj;
        return Double.doubleToLongBits(this.current) == Double.doubleToLongBits(that.current) && Double.doubleToLongBits(this.max) == Double.doubleToLongBits(that.max);
    }

    public int hashCode() {
        return Objects.hash(this.current, this.max);
    }

    public String toString() {
        return "DurabilityLikeInfo[current=" + this.current + ", max=" + this.max + ']';
    }
}

