/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup;

import aroma1997.backup.BackupCommand;
import aroma1997.backup.Config;
import aroma1997.backup.EventListener;
import aroma1997.backup.Reference;
import aroma1997.backup.ThreadBackup;
import aroma1997.backup.ThreadSchedule;
import aroma1997.backup.WorldIndex;
import aroma1997.core.log.LogHelper;
import aroma1997.core.util.ServerUtil;
import aroma1997.core.util.Util;
import aroma1997.core.version.VersionCheck;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="AromaBackup", name="AromaBackup", dependencies="required-after:Aroma1997Core")
public class AromaBackup
implements ICommandSender {
    public Logger logger = LogHelper.genNewLogger((String)"AromaBackup");
    @Mod.Instance(value="AromaBackup")
    public static AromaBackup instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.instance.reload();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        VersionCheck.registerVersionChecker((String)"AromaBackup", (String)Reference.VERSION);
        EventListener el = new EventListener();
        FMLCommonHandler.instance().bus().register((Object)el);
        MinecraftForge.EVENT_BUS.register((Object)el);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new BackupCommand());
        WorldIndex.load();
        if (Config.instance.delay != 0L) {
            ThreadSchedule.startNewThread();
        }
        ThreadBackup.shouldBackup = true;
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        try {
            BasicFileAttributes attr = Files.readAttributes(Util.getWorldFolder().toPath(), BasicFileAttributes.class, new LinkOption[0]);
            long fileCreated = attr.creationTime().toMillis();
            ThreadSchedule.nextbackup = Config.instance.onStartup ? (fileCreated > System.currentTimeMillis() - 10000L && fileCreated <= System.currentTimeMillis() ? System.currentTimeMillis() + 60000L : System.currentTimeMillis() + 5000L) : System.currentTimeMillis() + Config.instance.delay;
        }
        catch (IOException e) {
            ThreadSchedule.nextbackup = Config.instance.onStartup ? System.currentTimeMillis() + 60000L : System.currentTimeMillis() + Config.instance.delay;
            e.printStackTrace();
        }
        this.logger.log(Level.INFO, "Next Backup in: " + (ThreadSchedule.nextbackup - System.currentTimeMillis() + 1L) / 1000L + " seconds.");
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        ThreadSchedule.stopThread();
    }

    public String func_70005_c_() {
        return "AromaBackup";
    }

    public boolean func_70003_b(int i, String s) {
        return true;
    }

    public World func_130014_f_() {
        return null;
    }

    public void func_145747_a(IChatComponent comp) {
        this.logger.log(Level.TRACE, comp.func_150260_c());
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return true;
    }

    public IChatComponent func_145748_c_() {
        return ServerUtil.getChatForString((String)this.func_70005_c_());
    }

    public ChunkCoordinates func_82114_b() {
        return new ChunkCoordinates();
    }
}

