/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.Direction;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMultiID;
import ic2.core.block.BlockPoleFence;
import ic2.core.block.wiring.BlockCable;
import ic2.core.block.wiring.TileEntityLuminator;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemLuminator;
import ic2.core.util.AabbUtil;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableObject;

public class BlockLuminator
extends BlockMultiID {
    boolean light;

    public BlockLuminator(InternalName internalName1) {
        super(internalName1, Material.field_151592_s, ItemLuminator.class);
        this.func_149672_a(field_149778_k);
        this.func_149711_c(0.3f);
        this.func_149752_b(0.5f);
        if (internalName1 == InternalName.blockLuminator) {
            this.light = true;
            this.func_149715_a(1.0f);
            this.func_149647_a(null);
            GameRegistry.registerTileEntity(TileEntityLuminator.class, (String)"Luminator");
        } else {
            this.light = false;
        }
    }

    @Override
    public String getTextureFolder(int id) {
        return "wiring";
    }

    @Override
    public int getTextureIndex(int meta) {
        return 0;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean func_149707_d(World world, int x, int y, int z, int direction) {
        if (!world.func_147437_c(x, y, z)) {
            return false;
        }
        switch (direction) {
            case 0: {
                ++y;
                break;
            }
            case 1: {
                --y;
                break;
            }
            case 2: {
                ++z;
                break;
            }
            case 3: {
                --z;
                break;
            }
            case 4: {
                ++x;
                break;
            }
            case 5: {
                --x;
            }
        }
        return BlockLuminator.isSupportingBlock(world, x, y, z);
    }

    public static boolean isSupportingBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return !block.isAir((IBlockAccess)world, x, y, z) && (block.func_149662_c() || BlockLuminator.isSpecialSupporter((IBlockAccess)world, x, y, z));
    }

    public static boolean isSpecialSupporter(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block.isAir(world, x, y, z)) {
            return false;
        }
        return block instanceof BlockFence || block instanceof BlockPoleFence || block instanceof BlockCable || StackUtil.equals(block, Ic2Items.reinforcedGlass) || block == Blocks.field_150359_w;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        TileEntityLuminator te = (TileEntityLuminator)this.getOwnTe((IBlockAccess)world, x, y, z);
        if (te == null) {
            return true;
        }
        if (te.ignoreBlockStay) {
            return true;
        }
        int facing = world.func_72805_g(x, y, z);
        switch (facing) {
            case 0: {
                ++y;
                break;
            }
            case 1: {
                --y;
                break;
            }
            case 2: {
                ++z;
                break;
            }
            case 3: {
                --z;
                break;
            }
            case 4: {
                ++x;
                break;
            }
            case 5: {
                --x;
            }
        }
        return BlockLuminator.isSupportingBlock(world, x, y, z);
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        if (!this.func_149718_j(world, x, y, z)) {
            world.func_147468_f(x, y, z);
        }
        super.func_149695_a(world, x, y, z, neighbor);
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public int func_149645_b() {
        return IC2.platform.getRenderId("luminator");
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z, int meta) {
        return this.func_149668_a(world, x, y, z);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        float[] box = BlockLuminator.getBoxOfLuminator((IBlockAccess)world, x, y, z);
        return AxisAlignedBB.func_72330_a((double)(box[0] + (float)x), (double)(box[1] + (float)y), (double)(box[2] + (float)z), (double)(box[3] + (float)x), (double)(box[4] + (float)y), (double)(box[5] + (float)z));
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        return this.func_149668_a(world, x, y, z);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 origin, Vec3 absDirection) {
        Vec3 direction = Vec3.func_72443_a((double)(absDirection.field_72450_a - origin.field_72450_a), (double)(absDirection.field_72448_b - origin.field_72448_b), (double)(absDirection.field_72449_c - origin.field_72449_c));
        double maxLength = direction.func_72433_c();
        Vec3 intersection = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        Direction intersectingDirection = AabbUtil.getIntersection(origin, direction, this.func_149668_a(world, x, y, z), intersection);
        if (intersectingDirection != null && intersection.func_72438_d(origin) <= maxLength) {
            return new MovingObjectPosition(x, y, z, intersectingDirection.toSideValue(), intersection);
        }
        return null;
    }

    public static float[] getBoxOfLuminator(IBlockAccess world, int x, int y, int z) {
        int facing = world.func_72805_g(x, y, z);
        float px = 0.0625f;
        switch (facing) {
            case 0: {
                ++y;
                break;
            }
            case 1: {
                --y;
                break;
            }
            case 2: {
                ++z;
                break;
            }
            case 3: {
                --z;
                break;
            }
            case 4: {
                ++x;
                break;
            }
            case 5: {
                --x;
            }
        }
        boolean fullCover = BlockLuminator.isSpecialSupporter(world, x, y, z);
        switch (facing) {
            case 1: {
                return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f * px, 1.0f};
            }
            case 2: {
                if (fullCover) {
                    return new float[]{0.0f, 0.0f, 15.0f * px, 1.0f, 1.0f, 1.0f};
                }
                return new float[]{6.0f * px, 3.0f * px, 14.0f * px, 1.0f - 6.0f * px, 1.0f - 3.0f * px, 1.0f};
            }
            case 3: {
                if (fullCover) {
                    return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f * px};
                }
                return new float[]{6.0f * px, 3.0f * px, 0.0f, 1.0f - 6.0f * px, 1.0f - 3.0f * px, 2.0f * px};
            }
            case 4: {
                if (fullCover) {
                    return new float[]{15.0f * px, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
                }
                return new float[]{14.0f * px, 3.0f * px, 6.0f * px, 1.0f, 1.0f - 3.0f * px, 1.0f - 6.0f * px};
            }
            case 5: {
                if (fullCover) {
                    return new float[]{0.0f, 0.0f, 0.0f, 1.0f * px, 1.0f, 1.0f};
                }
                return new float[]{0.0f, 3.0f * px, 6.0f * px, 2.0f * px, 1.0f - 3.0f * px, 1.0f - 6.0f * px};
            }
        }
        if (fullCover) {
            return new float[]{0.0f, 15.0f * px, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        return new float[]{4.0f * px, 13.0f * px, 4.0f * px, 1.0f - 4.0f * px, 1.0f, 1.0f - 4.0f * px};
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    public void func_149670_a(World world, int i, int j, int k, Entity entity) {
        if (this.light && entity instanceof EntityMob) {
            entity.func_70015_d(entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70668_bt() == EnumCreatureAttribute.UNDEAD ? 20 : 10);
        }
    }

    @Override
    public Class<? extends TileEntity> getTeClass(int meta, MutableObject<Class<?>[]> ctorArgTypes, MutableObject<Object[]> ctorArgs) {
        return TileEntityLuminator.class;
    }

    @Override
    public void func_149666_a(Item item, CreativeTabs tabs, List itemList) {
        if (!this.light) {
            super.func_149666_a(item, tabs, itemList);
        }
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        TileEntityLuminator te = (TileEntityLuminator)this.getOwnTe((IBlockAccess)world, x, y, z);
        if (te == null) {
            return 0;
        }
        return (int)Math.round(Util.map(te.energy, te.getMaxEnergy(), 15.0));
    }
}

