/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.personalspace.gui;

import java.awt.Rectangle;
import javax.annotation.Nonnull;
import me.eigenraven.personalspace.gui.Icons;
import me.eigenraven.personalspace.gui.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class WButton
extends Widget {
    @Nonnull
    String text = "";
    public boolean dropShadow = true;
    public static final int DEFAULT_COLOR = 0xFFFFFF;
    public int color = 0xFFFFFF;
    public Icons buttonIcon = null;
    public ItemStack itemStack = null;
    public String itemStackText = "";
    public Runnable onClick = null;
    public int lastButton = 0;
    public String tooltip = null;
    private static RenderItem renderItem;

    public WButton() {
    }

    public WButton(Rectangle position, String text, boolean dropShadow, int color, Icons buttonIcon, Runnable onClick) {
        this.position = position;
        this.dropShadow = dropShadow;
        this.color = color;
        this.onClick = onClick;
        this.buttonIcon = buttonIcon;
        this.setText(text);
    }

    @Nonnull
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.text = text;
    }

    @Override
    protected void drawImpl(int mouseX, int mouseY, float partialTicks) {
        Icons icon;
        Icons.bindTexture();
        Icons icons = icon = this.enabled ? Icons.BUTTON_NORMAL : Icons.BUTTON_OFF;
        if (this.enabled && this.testPoint(mouseX, mouseY)) {
            icon = Icons.BUTTON_HIGHLIGHT;
        }
        icon.draw9Patch(0, 0, this.position.width, this.position.height);
        int textSpace = this.position.width;
        if (this.buttonIcon != null) {
            textSpace -= this.buttonIcon.w + 6;
            this.buttonIcon.drawAt(1, this.position.height / 2 - this.buttonIcon.h / 2);
        }
        if (this.itemStack != null || this.itemStackText != null && !this.itemStackText.isEmpty()) {
            if (renderItem == null) {
                renderItem = new RenderItem();
            }
            textSpace -= 18;
            Icons.drawItem(1, this.position.height / 2 - 9, this.itemStack, this.itemStackText, renderItem);
        }
        if (!this.text.isEmpty()) {
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            String drawText = fr.func_78269_a(this.text, textSpace - 6);
            int textW = fr.func_78256_a(drawText);
            fr.func_85187_a(drawText, this.position.width - textSpace / 2 - textW / 2, this.position.height / 2 - fr.field_78288_b / 2, this.color, this.dropShadow);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    protected void drawForegroundImpl(int mouseX, int mouseY, float partialTicks) {
        if (this.tooltip != null && !this.tooltip.isEmpty() && this.testPoint(mouseX, mouseY)) {
            this.drawTooltip(mouseX - this.position.x, mouseY - this.position.y, this.tooltip);
        }
    }

    @Override
    protected boolean mouseClickedImpl(int x, int y, int button) {
        this.lastButton = button;
        if (this.onClick != null) {
            this.onClick.run();
        }
        this.clickSound();
        return true;
    }
}

