/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class RitualEffectJumping
extends RitualEffect {
    public static final int aetherDrain = 10;
    public static final int terraeDrain = 10;

    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        double range = 0.5;
        List<EntityLivingBase> livingList = SpellHelper.getLivingEntitiesInRange(world, (double)x + 0.5, (double)y + 1.5, (double)z + 0.5, range, range);
        if (currentEssence < this.getCostPerRefresh() * livingList.size()) {
            SoulNetworkHandler.causeNauseaToPlayer(owner);
        } else {
            int flag = 0;
            boolean hasAether = this.canDrainReagent(ritualStone, ReagentRegistry.aetherReagent, 10, false);
            boolean hasTerrae = this.canDrainReagent(ritualStone, ReagentRegistry.terraeReagent, 10, false);
            for (EntityLivingBase livingEntity : livingList) {
                if (livingEntity.func_70093_af()) continue;
                hasAether = hasAether && this.canDrainReagent(ritualStone, ReagentRegistry.aetherReagent, 10, false);
                hasTerrae = hasTerrae && this.canDrainReagent(ritualStone, ReagentRegistry.terraeReagent, 10, false);
                double motionY = 1.5 * (double)(hasAether ? 2 : 1);
                if (livingEntity instanceof EntityPlayer) {
                    SpellHelper.setPlayerSpeedFromServer((EntityPlayer)livingEntity, livingEntity.field_70159_w, motionY, livingEntity.field_70179_y);
                    livingEntity.field_70181_x = motionY;
                    livingEntity.field_70143_R = 0.0f;
                    ++flag;
                } else {
                    livingEntity.field_70181_x = motionY;
                    livingEntity.field_70143_R = 0.0f;
                    ++flag;
                }
                if (hasAether) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.aetherReagent, 10, true);
                }
                if (!hasTerrae || livingEntity.func_70644_a(AlchemicalWizardry.customPotionFeatherFall)) continue;
                livingEntity.func_70690_d(new PotionEffect(AlchemicalWizardry.customPotionFeatherFall.field_76415_H, 100, 0));
                this.canDrainReagent(ritualStone, ReagentRegistry.terraeReagent, 10, true);
            }
            if (flag > 0) {
                SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh() * flag);
            }
        }
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostHighJump[1];
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> jumpingRitual = new ArrayList<RitualComponent>();
        for (int i = -1; i <= 1; ++i) {
            jumpingRitual.add(new RitualComponent(1, i, 1, 4));
            jumpingRitual.add(new RitualComponent(-1, i, 1, 4));
            jumpingRitual.add(new RitualComponent(-1, i, -1, 4));
            jumpingRitual.add(new RitualComponent(1, i, -1, 4));
        }
        return jumpingRitual;
    }
}

