/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.api.items.interfaces.IRitualDiviner;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.IRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.Rituals;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.tileEntity.TEMasterStone;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemRitualDiviner
extends EnergyItems
implements IRitualDiviner {
    private int maxMetaData;

    public ItemRitualDiviner() {
        this.field_77777_bU = 1;
        this.setEnergyUsed(100);
        this.func_77637_a(AlchemicalWizardry.tabBloodMagic);
        this.maxMetaData = 4;
        this.field_77787_bX = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("AlchemicalWizardry:RitualDiviner");
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List par3List, boolean x) {
        boolean sneaking;
        par3List.add(StatCollector.func_74838_a((String)"tooltip.ritualdiviner.desc"));
        if (this.getMaxRuneDisplacement(stack) == 1) {
            par3List.add(StatCollector.func_74838_a((String)"tooltip.ritualdiviner.canplace"));
        } else if (this.getMaxRuneDisplacement(stack) >= 2) {
            par3List.add(StatCollector.func_74838_a((String)"tooltip.ritualdiviner.canplacedawn"));
        } else {
            par3List.add(StatCollector.func_74838_a((String)"tooltip.ritualdiviner.cannotplace"));
        }
        par3List.add(StatCollector.func_74838_a((String)"tooltip.ritualdiviner.ritualtunedto") + " " + this.getNameForDirection(this.getDirection(stack)));
        boolean bl = sneaking = Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42);
        if (sneaking) {
            if (stack.func_77978_p() != null) {
                String ritualID = this.getCurrentRitual(stack);
                par3List.add(StatCollector.func_74838_a((String)"tooltip.owner.currentowner") + " " + stack.func_77978_p().func_74779_i("ownerName"));
                par3List.add(StatCollector.func_74838_a((String)"tooltip.alchemy.ritualid") + " " + ritualID);
                List<RitualComponent> ritualList = Rituals.getRitualList(this.getCurrentRitual(stack));
                if (ritualList == null) {
                    return;
                }
                int blankStones = 0;
                int airStones = 0;
                int waterStones = 0;
                int fireStones = 0;
                int earthStones = 0;
                int duskStones = 0;
                int dawnStones = 0;
                for (RitualComponent rc : ritualList) {
                    switch (rc.getStoneType()) {
                        case 0: {
                            ++blankStones;
                            break;
                        }
                        case 4: {
                            ++airStones;
                            break;
                        }
                        case 1: {
                            ++waterStones;
                            break;
                        }
                        case 2: {
                            ++fireStones;
                            break;
                        }
                        case 3: {
                            ++earthStones;
                            break;
                        }
                        case 5: {
                            ++duskStones;
                            break;
                        }
                        case 6: {
                            ++dawnStones;
                        }
                    }
                }
                int totalStones = blankStones + airStones + waterStones + fireStones + earthStones + duskStones + dawnStones;
                par3List.add(EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"tooltip.ritualdiviner.blankstones") + " " + blankStones);
                par3List.add(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"tooltip.ritualdiviner.airstones") + " " + airStones);
                par3List.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"tooltip.ritualdiviner.waterstones") + " " + waterStones);
                par3List.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"tooltip.ritualdiviner.firestones") + " " + fireStones);
                par3List.add(EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)"tooltip.ritualdiviner.earthstones") + " " + earthStones);
                par3List.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"tooltip.ritualdiviner.duskstones") + " " + duskStones);
                par3List.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"tooltip.ritualdiviner.dawnstones") + " " + dawnStones);
                par3List.add(EnumChatFormatting.UNDERLINE + StatCollector.func_74838_a((String)"tooltip.ritualdiviner.totalStones") + " " + totalStones);
            }
        } else {
            par3List.add(EnumChatFormatting.AQUA + "-" + StatCollector.func_74838_a((String)"tooltip.ritualdiviner.moreinfo") + "-");
        }
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            String ritualID = this.getCurrentRitual(stack);
            if (ritualID.equals("")) {
                return super.func_77653_i(stack);
            }
            return StatCollector.func_74837_a((String)"bm.string.ritualDiviner", (Object[])new Object[]{Rituals.getLocalizedNameOfRitual(ritualID)});
        }
        return super.func_77653_i(stack);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        if (!EnergyItems.checkAndSetItemOwner(stack, player)) {
            return false;
        }
        if (this.placeRitualStoneAtMasterStone(stack, player, world, x, y, z)) {
            this.setStoredLocation(stack, new Int3(x, y, z));
            return true;
        }
        if (!(world.func_147439_a(x, y, z) instanceof IRitualStone || world.func_147439_a(x, y, z) instanceof IMasterRitualStone || player.func_70093_af())) {
            if (world.field_72995_K) {
                return false;
            }
            this.cycleDirection(stack);
            player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"tooltip.ritualdiviner.ritualtunedto") + " " + this.getNameForDirection(this.getDirection(stack))));
            return true;
        }
        return false;
    }

    public boolean placeRitualStoneAtMasterStone(ItemStack stack, EntityPlayer player, World world, int x, int y, int z) {
        int direction = this.getDirection(stack);
        ItemStack[] playerInventory = player.field_71071_by.field_70462_a;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TEMasterStone) {
            List<RitualComponent> ritualList = Rituals.getRitualList(this.getCurrentRitual(stack));
            if (ritualList == null) {
                return false;
            }
            int playerInvRitualStoneLocation = -1;
            for (int i = 0; i < playerInventory.length; ++i) {
                if (playerInventory[i] == null || !new ItemStack(ModBlocks.ritualStone).func_77969_a(playerInventory[i])) continue;
                playerInvRitualStoneLocation = i;
                break;
            }
            for (RitualComponent rc : ritualList) {
                if (world.func_147437_c(x + rc.getX(direction), y + rc.getY(), z + rc.getZ(direction))) {
                    if (playerInvRitualStoneLocation < 0 && !player.field_71075_bZ.field_75098_d) continue;
                    if (rc.getStoneType() > this.maxMetaData + this.getMaxRuneDisplacement(stack)) {
                        world.func_72926_e(200, x, y + 1, z, 0);
                        return true;
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70298_a(playerInvRitualStoneLocation, 1);
                    }
                    if (EnergyItems.syphonBatteries(stack, player, this.getEnergyUsed())) {
                        world.func_147465_d(x + rc.getX(direction), y + rc.getY(), z + rc.getZ(direction), ModBlocks.ritualStone, rc.getStoneType(), 3);
                        if (world.field_72995_K) {
                            world.func_72926_e(2005, x, y + 1, z, 0);
                            return true;
                        }
                    }
                    return true;
                }
                Block block = world.func_147439_a(x + rc.getX(direction), y + rc.getY(), z + rc.getZ(direction));
                if (block == ModBlocks.ritualStone) {
                    int metadata = world.func_72805_g(x + rc.getX(direction), y + rc.getY(), z + rc.getZ(direction));
                    if (metadata == rc.getStoneType() || !EnergyItems.syphonBatteries(stack, player, this.getEnergyUsed())) continue;
                    if (rc.getStoneType() > this.maxMetaData + this.getMaxRuneDisplacement(stack)) {
                        world.func_72926_e(200, x, y + 1, z, 0);
                        return true;
                    }
                    world.func_72921_c(x + rc.getX(direction), y + rc.getY(), z + rc.getZ(direction), rc.getStoneType(), 3);
                    return true;
                }
                world.func_72926_e(0, x, y + 1, z, 0);
                return true;
            }
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof EntityPlayer && this.hasStoredLocation(stack) && world.func_72820_D() % 5L == 0L) {
            Int3 loc = this.getStoredLocation(stack);
            int x = loc.xCoord;
            int y = loc.yCoord;
            int z = loc.zCoord;
            if (!this.placeRitualStoneAtMasterStone(stack, (EntityPlayer)entity, world, x, y, z)) {
                this.voidStoredLocation(stack);
            }
        }
    }

    public void setStoredLocation(ItemStack stack, Int3 location) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        NBTTagCompound locTag = location.writeToNBT(new NBTTagCompound());
        locTag.func_74757_a("isStored", true);
        tag.func_74782_a("location", (NBTBase)locTag);
    }

    public void voidStoredLocation(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b("location")) {
            this.setStoredLocation(stack, new Int3(0, 0, 0));
            return;
        }
        NBTTagCompound locTag = (NBTTagCompound)tag.func_74781_a("location");
        if (locTag != null) {
            locTag.func_74757_a("isStored", false);
        }
    }

    public Int3 getStoredLocation(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b("location")) {
            return new Int3(0, 0, 0);
        }
        NBTTagCompound locTag = (NBTTagCompound)tag.func_74781_a("location");
        return Int3.readFromNBT(locTag);
    }

    public boolean hasStoredLocation(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b("location")) {
            return false;
        }
        NBTTagCompound locTag = (NBTTagCompound)tag.func_74781_a("location");
        return locTag.func_74767_n("isStored");
    }

    public ItemStack func_77659_a(ItemStack stack, World par2World, EntityPlayer par3EntityPlayer) {
        if (EnergyItems.checkAndSetItemOwner(stack, par3EntityPlayer) && par3EntityPlayer.func_70093_af()) {
            this.rotateRituals(par2World, par3EntityPlayer, stack, true);
        }
        return stack;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (!EnergyItems.checkAndSetItemOwner(stack, player)) {
                return true;
            }
            if (!player.field_82175_bq && player.func_70093_af()) {
                this.rotateRituals(player.field_70170_p, player, stack, false);
            }
        }
        return false;
    }

    public void rotateRituals(World world, EntityPlayer player, ItemStack stack, boolean next) {
        this.voidStoredLocation(stack);
        String currentRitualID = this.getCurrentRitual(stack);
        this.setCurrentRitual(stack, next ? Rituals.getNextRitualKey(currentRitualID) : Rituals.getPreviousRitualKey(currentRitualID));
        if (world.field_72995_K) {
            ChatComponentText chatmessagecomponent = new ChatComponentText(StatCollector.func_74838_a((String)"message.ritual.currentritual") + " " + Rituals.getLocalizedNameOfRitual(this.getCurrentRitual(stack)));
            player.func_146105_b((IChatComponent)chatmessagecomponent);
        }
    }

    @Override
    public String getCurrentRitual(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p().func_74779_i("ritualID");
    }

    @Override
    public void setCurrentRitual(ItemStack stack, String ritualID) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a("ritualID", ritualID);
    }

    @Override
    public int getMaxRuneDisplacement(ItemStack stack) {
        return stack.func_77960_j();
    }

    @Override
    public void setMaxRuneDisplacement(ItemStack stack, int displacement) {
        stack.func_77964_b(displacement);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item id, CreativeTabs creativeTab, List list) {
        list.add(new ItemStack(id));
        ItemStack duskRitualDivinerStack = new ItemStack(id);
        this.setMaxRuneDisplacement(duskRitualDivinerStack, 1);
        list.add(duskRitualDivinerStack);
        ItemStack dawnRitualDivinerStack = new ItemStack(id);
        this.setMaxRuneDisplacement(dawnRitualDivinerStack, 2);
        list.add(dawnRitualDivinerStack);
    }

    @Override
    public int getDirection(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return itemStack.func_77978_p().func_74762_e("direction");
    }

    @Override
    public void setDirection(ItemStack itemStack, int direction) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74768_a("direction", direction);
    }

    @Override
    public int cycleDirection(ItemStack itemStack) {
        this.voidStoredLocation(itemStack);
        int direction = this.getDirection(itemStack);
        direction = direction < 4 ? Math.max(1, direction + 1) : 1;
        this.setDirection(itemStack, direction);
        return direction;
    }

    @Override
    public String getNameForDirection(int direction) {
        String dir = "";
        switch (direction) {
            case 0: 
            case 1: {
                dir = StatCollector.func_74838_a((String)"message.ritual.side.north");
                break;
            }
            case 2: {
                dir = StatCollector.func_74838_a((String)"message.ritual.side.east");
                break;
            }
            case 3: {
                dir = StatCollector.func_74838_a((String)"message.ritual.side.south");
                break;
            }
            case 4: {
                dir = StatCollector.func_74838_a((String)"message.ritual.side.west");
            }
        }
        return dir;
    }
}

