/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.alchemy.energy;

import WayofTime.alchemicalWizardry.api.alchemy.energy.ISegmentedReagentHandler;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainer;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainerInfo;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileSegmentedReagentHandler
extends TileEntity
implements ISegmentedReagentHandler {
    protected ReagentContainer[] tanks;
    protected Map<Reagent, Integer> attunedTankMap = new HashMap<Reagent, Integer>();

    public TileSegmentedReagentHandler() {
        this(1);
    }

    public TileSegmentedReagentHandler(int numberOfTanks) {
        this(numberOfTanks, 1000);
    }

    public TileSegmentedReagentHandler(int numberOfTanks, int tankSize) {
        this.tanks = new ReagentContainer[numberOfTanks];
        for (int i = 0; i < numberOfTanks; ++i) {
            this.tanks[i] = new ReagentContainer(tankSize);
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList tagList = tag.func_150295_c("reagentTanks", 10);
        int size = tagList.func_74745_c();
        this.tanks = new ReagentContainer[size];
        for (int i = 0; i < size; ++i) {
            NBTTagCompound savedTag = tagList.func_150305_b(i);
            this.tanks[i] = ReagentContainer.readFromNBT(savedTag);
        }
        NBTTagList attunedTagList = tag.func_150295_c("attunedTankMap", 10);
        for (int i = 0; i < attunedTagList.func_74745_c(); ++i) {
            NBTTagCompound savedTag = attunedTagList.func_150305_b(i);
            Reagent reagent = ReagentRegistry.getReagentForKey(savedTag.func_74779_i("reagent"));
            this.attunedTankMap.put(reagent, savedTag.func_74762_e("amount"));
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.tanks.length; ++i) {
            NBTTagCompound savedTag = new NBTTagCompound();
            if (this.tanks[i] != null) {
                this.tanks[i].writeToNBT(savedTag);
            }
            tagList.func_74742_a((NBTBase)savedTag);
        }
        tag.func_74782_a("reagentTanks", (NBTBase)tagList);
        NBTTagList attunedTagList = new NBTTagList();
        for (Map.Entry<Reagent, Integer> entry : this.attunedTankMap.entrySet()) {
            NBTTagCompound savedTag = new NBTTagCompound();
            savedTag.func_74778_a("reagent", ReagentRegistry.getKeyForReagent(entry.getKey()));
            savedTag.func_74768_a("amount", entry.getValue().intValue());
            attunedTagList.func_74742_a((NBTBase)savedTag);
        }
        tag.func_74782_a("attunedTankMap", (NBTBase)attunedTagList);
    }

    @Override
    public int fill(ForgeDirection from, ReagentStack resource, boolean doFill) {
        boolean useTankLimit;
        int totalFill = 0;
        boolean bl = useTankLimit = !this.attunedTankMap.isEmpty();
        if (resource != null) {
            ReagentStack remainingStack;
            int i;
            int totalTanksFillable = useTankLimit ? this.getTanksTunedToReagent(resource.reagent) : this.tanks.length;
            int tanksFilled = 0;
            int maxFill = resource.amount;
            for (i = this.tanks.length - 1; i >= 0; --i) {
                boolean doesReagentMatch;
                remainingStack = resource.copy();
                remainingStack.amount = maxFill - totalFill;
                boolean bl2 = doesReagentMatch = this.tanks[i].getReagent() == null ? false : this.tanks[i].getReagent().isReagentEqual(remainingStack);
                if (!doesReagentMatch || (totalFill += this.tanks[i].fill(remainingStack, doFill)) < maxFill && ++tanksFilled < totalTanksFillable) continue;
                return totalFill;
            }
            if (tanksFilled >= totalTanksFillable) {
                return totalFill;
            }
            for (i = this.tanks.length - 1; i >= 0; --i) {
                boolean isTankEmpty;
                remainingStack = resource.copy();
                remainingStack.amount = maxFill - totalFill;
                boolean bl3 = isTankEmpty = this.tanks[i].getReagent() == null;
                if (!isTankEmpty || (totalFill += this.tanks[i].fill(remainingStack, doFill)) < maxFill && ++tanksFilled < totalTanksFillable) continue;
                return totalFill;
            }
        }
        return totalFill;
    }

    @Override
    public ReagentStack drain(ForgeDirection from, ReagentStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        int maxDrain = resource.amount;
        Reagent reagent = resource.reagent;
        int drained = 0;
        for (int i = 0; i < this.tanks.length && drained < maxDrain; ++i) {
            ReagentStack drainStack;
            if (!resource.isReagentEqual(this.tanks[i].getReagent()) || (drainStack = this.tanks[i].drain(maxDrain - drained, doDrain)) == null) continue;
            drained += drainStack.amount;
        }
        return new ReagentStack(reagent, drained);
    }

    @Override
    public ReagentStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        for (int i = 0; i < this.tanks.length; ++i) {
            ReagentStack stack = this.tanks[i].drain(maxDrain, doDrain);
            if (stack == null) continue;
            return stack;
        }
        return null;
    }

    @Override
    public boolean canFill(ForgeDirection from, Reagent reagent) {
        return true;
    }

    @Override
    public boolean canDrain(ForgeDirection from, Reagent reagent) {
        return true;
    }

    @Override
    public ReagentContainerInfo[] getContainerInfo(ForgeDirection from) {
        ReagentContainerInfo[] info = new ReagentContainerInfo[this.getNumberOfTanks()];
        for (int i = 0; i < this.getNumberOfTanks(); ++i) {
            info[i] = this.tanks[i].getInfo();
        }
        return info;
    }

    @Override
    public int getNumberOfTanks() {
        return this.tanks.length;
    }

    @Override
    public int getTanksTunedToReagent(Reagent reagent) {
        if (this.attunedTankMap.containsKey(reagent) && this.attunedTankMap.get(reagent) != null) {
            return this.attunedTankMap.get(reagent);
        }
        return 0;
    }

    @Override
    public void setTanksTunedToReagent(Reagent reagent, int total) {
        if (total == 0 && this.attunedTankMap.containsKey(reagent)) {
            this.attunedTankMap.remove(reagent);
            return;
        }
        this.attunedTankMap.put(reagent, total);
    }

    @Override
    public Map<Reagent, Integer> getAttunedTankMap() {
        return this.attunedTankMap;
    }

    public boolean areTanksEmpty() {
        for (int i = 0; i < this.tanks.length; ++i) {
            if (this.tanks[i] == null || this.tanks[i].reagentStack == null) continue;
            return false;
        }
        return true;
    }
}

