/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.tooltip;

import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.$AutoValue_Tooltip;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.TooltipLine;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

final class AutoValue_Tooltip
extends $AutoValue_Tooltip {
    AutoValue_Tooltip(ImmutableList<TooltipLine> lines$) {
        super(lines$);
    }

    @Override
    public final String toPrettyString() {
        return "Tooltip {\n  lines = " + AutoValue_Tooltip.formatCollectionOfTooltipLine(this.lines(), 1) + ",\n}";
    }

    private static String formatTooltipLine(TooltipLine value, int indentLevel) {
        if (value == null) {
            return "null";
        }
        return value.toPrettyString().replace("\n", "\n" + AutoValue_Tooltip.$indent(indentLevel));
    }

    private static String formatCollectionOfTooltipLine(Collection<TooltipLine> value, int indentLevel) {
        if (value == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder().append("[");
        boolean hasElements = false;
        for (TooltipLine element : value) {
            builder.append("\n").append(AutoValue_Tooltip.$indent(indentLevel + 1)).append(AutoValue_Tooltip.formatTooltipLine(element, indentLevel + 1)).append(",");
            hasElements = true;
        }
        if (hasElements) {
            builder.append("\n").append(AutoValue_Tooltip.$indent(indentLevel));
        }
        return builder.append("]").toString();
    }

    private static String $indent(int level) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            builder.append("  ");
        }
        return builder.toString();
    }
}

