/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.feature.island.laboratory;

import chylex.hee.init.BlockList;
import chylex.hee.world.structure.util.pregen.LargeStructureWorld;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class LaboratoryElementPlacer {
    public static final Block blockLab = BlockList.laboratory_obsidian;
    public static final Block blockFloor = BlockList.laboratory_floor;

    public static void generateRoomEntrance(LargeStructureWorld world, Random rand, int x, int y, int z, boolean isX) {
        int x1 = x;
        int x2 = x;
        int z1 = z;
        int z2 = z;
        if (isX) {
            --z1;
            ++z2;
        } else {
            --x1;
            ++x2;
        }
        for (x = Math.min(x1, x2); x <= Math.max(x1, x2); ++x) {
            for (z = Math.min(z1, z2); z <= Math.max(z1, z2); ++z) {
                for (int py = 0; py < 5; ++py) {
                    world.setBlock(x, y + py, z, py == 0 ? blockFloor : (py == 4 ? blockLab : Blocks.field_150350_a));
                }
            }
        }
    }

    public static void generateHall(LargeStructureWorld world, Random rand, int x1, int z1, int x2, int z2, int y, boolean isX) {
        int py;
        int zMax;
        int x;
        int z;
        int py2;
        int a;
        int xMax;
        if (isX) {
            int xMin = Math.min(x1, x2);
            xMax = Math.max(x1, x2);
            for (int x3 = xMin; x3 <= xMax; ++x3) {
                for (a = 0; a < 3; ++a) {
                    world.setBlock(x3, y, z1 - 1 + a, blockFloor);
                    world.setBlock(x3, y + 4, z1 - 1 + a, blockLab);
                }
                for (py2 = 0; py2 < 4; ++py2) {
                    world.setBlock(x3, y + py2, z1 - 2, py2 == 2 ? BlockList.laboratory_glass : blockLab);
                    world.setBlock(x3, y + py2, z1 + 2, py2 == 2 ? BlockList.laboratory_glass : blockLab);
                }
            }
            --z1;
            ++z2;
        } else {
            int zMin = Math.min(z1, z2);
            int zMax2 = Math.max(z1, z2);
            for (z = zMin; z <= zMax2; ++z) {
                for (a = 0; a < 3; ++a) {
                    world.setBlock(x1 - 1 + a, y, z, blockFloor);
                    world.setBlock(x1 - 1 + a, y + 4, z, blockLab);
                }
                for (py2 = 0; py2 < 4; ++py2) {
                    world.setBlock(x1 - 2, y + py2, z, py2 == 2 ? BlockList.laboratory_glass : blockLab);
                    world.setBlock(x1 + 2, y + py2, z, py2 == 2 ? BlockList.laboratory_glass : blockLab);
                }
            }
            --x1;
            ++x2;
        }
        xMax = Math.max(x1, x2);
        for (x = Math.min(x1, x2); x <= xMax; ++x) {
            zMax = Math.max(z1, z2);
            for (z = Math.min(z1, z2); z <= zMax; ++z) {
                for (py = 1; py < 4; ++py) {
                    world.setBlock(x, y + py, z, Blocks.field_150350_a);
                }
            }
        }
        if (isX) {
            --z1;
            ++z2;
        } else {
            --x1;
            ++x2;
        }
        xMax = Math.max(x1, x2);
        for (x = Math.min(x1, x2); x <= xMax; ++x) {
            zMax = Math.max(z1, z2);
            for (z = Math.min(z1, z2); z <= zMax; ++z) {
                for (py = -1; py > -5 && world.isAir(x, y + py, z) && LaboratoryElementPlacer.isValidFloor(world.getBlock(x, y + py + 1, z)); --py) {
                    world.setBlock(x, y + py, z, blockLab);
                }
            }
        }
    }

    public static void generateHallStairs(LargeStructureWorld world, Random rand, int x, int y, int z, int xAdd, int yAdd, int zAdd) {
        int a;
        int side;
        int side2;
        int space;
        int b;
        int py;
        int x1 = x;
        int x2 = x;
        int z1 = z;
        int z2 = z;
        if (yAdd == -1) {
            --y;
        } else {
            xAdd *= -1;
            zAdd *= -1;
        }
        if (xAdd != 0) {
            for (py = 0; py <= 5; ++py) {
                if (py < 5) {
                    for (b = 0; b < 2; ++b) {
                        world.setBlock(x, y + py, z - 2 + b * 4, blockLab);
                    }
                }
                for (b = 0; b < 3; ++b) {
                    if (py == 1) {
                        world.setBlock(x, y + py, z - 1 + b, BlockList.laboratory_stairs, xAdd == 1 ? 1 : 0);
                        continue;
                    }
                    world.setBlock(x, y + py, z - 1 + b, py == 0 ? blockFloor : (py == 5 ? blockLab : Blocks.field_150350_a));
                }
            }
            for (space = 0; space < 3 && !world.isAir(x + (space + 1) * xAdd, y + 2, z - 2); ++space) {
            }
            if (space == 1 || space == 2) {
                for (side2 = 0; side2 < 2; ++side2) {
                    world.setBlock(x + xAdd, y + 2, z - 2 + side2 * 4, blockLab);
                }
            } else if (space == 3) {
                for (side2 = 0; side2 < 2; ++side2) {
                    world.setBlock(x + xAdd, y + 4, z - 2 + side2 * 4, blockLab);
                    world.setBlock(x, y + 3, z - 2 + side2 * 4, BlockList.laboratory_glass);
                    world.setBlock(x + xAdd, y + 3, z - 2 + side2 * 4, BlockList.laboratory_glass);
                }
            }
            for (b = 0; b <= Math.min(space, 2); ++b) {
                for (side = 0; side < 2; ++side) {
                    world.setBlock(x + xAdd * b, y + 4, z - 2 + side * 4, blockLab);
                }
                for (a = 0; a < 3; ++a) {
                    world.setBlock(x + xAdd * b, y + 4, z - 1 + a, Blocks.field_150350_a);
                    world.setBlock(x + xAdd * b, y + 5, z - 1 + a, blockLab);
                }
            }
            z1 -= 2;
            z2 += 2;
        } else if (zAdd != 0) {
            for (py = 0; py <= 5; ++py) {
                if (py < 5) {
                    for (b = 0; b < 2; ++b) {
                        world.setBlock(x - 2 + b * 4, y + py, z, blockLab);
                    }
                }
                for (b = 0; b < 3; ++b) {
                    if (py == 1) {
                        world.setBlock(x - 1 + b, y + py, z, BlockList.laboratory_stairs, zAdd == 1 ? 3 : 2);
                        continue;
                    }
                    world.setBlock(x - 1 + b, y + py, z, py == 0 ? blockFloor : (py == 5 ? blockLab : Blocks.field_150350_a));
                }
            }
            for (space = 0; space < 3 && !world.isAir(x - 2, y + 2, z + (space + 1) * zAdd); ++space) {
            }
            if (space == 1 || space == 2) {
                for (side2 = 0; side2 < 2; ++side2) {
                    world.setBlock(x - 2 + side2 * 4, y + 2, z + zAdd, blockLab);
                }
            } else if (space == 3) {
                for (side2 = 0; side2 < 2; ++side2) {
                    world.setBlock(x - 2 + side2 * 4, y + 4, z + zAdd, blockLab);
                    world.setBlock(x - 2 + side2 * 4, y + 3, z, BlockList.laboratory_glass);
                    world.setBlock(x - 2 + side2 * 4, y + 3, z + zAdd, BlockList.laboratory_glass);
                }
            }
            for (b = 0; b <= Math.min(space, 2); ++b) {
                for (side = 0; side < 2; ++side) {
                    world.setBlock(x - 2 + side * 4, y + 4, z + zAdd * b, blockLab);
                }
                for (a = 0; a < 3; ++a) {
                    world.setBlock(x - 1 + a, y + 4, z + zAdd * b, Blocks.field_150350_a);
                    world.setBlock(x - 1 + a, y + 5, z + zAdd * b, blockLab);
                }
            }
            x1 -= 2;
            x2 += 2;
        }
        int xMax = Math.max(x1, x2);
        for (int xx = Math.min(x1, x2); xx <= xMax; ++xx) {
            int zMax = Math.max(z1, z2);
            for (int zz = Math.min(z1, z2); zz <= zMax; ++zz) {
                for (int py2 = -1; py2 > -5 && world.isAir(xx, y + py2, zz) && LaboratoryElementPlacer.isValidFloor(world.getBlock(xx, y + py2 + 1, zz)); --py2) {
                    world.setBlock(xx, y + py2, zz, blockLab);
                }
            }
        }
    }

    public static void generateSmallRoom(LargeStructureWorld world, Random rand, int x, int y, int z) {
        int pz;
        int py;
        int pz2;
        int px;
        for (int a = 0; a < 5; ++a) {
            for (px = 0; px < 7; ++px) {
                world.setBlock(x - 3 + px, y, z - 2 + a, blockFloor);
                world.setBlock(x - 3 + px, y + 4, z - 2 + a, blockLab);
            }
            for (pz2 = 0; pz2 < 2; ++pz2) {
                world.setBlock(x - 2 + a, y, z - 3 + pz2 * 6, blockFloor);
                world.setBlock(x - 2 + a, y + 4, z - 3 + pz2 * 6, blockLab);
            }
        }
        for (py = 0; py < 4; ++py) {
            for (px = 0; px < 2; ++px) {
                for (pz = 0; pz < 2; ++pz) {
                    world.setBlock(x - 3 + px * 6, y + py, z - 3 + pz * 6, blockLab);
                }
            }
            for (int a = 0; a < 5; ++a) {
                for (int b = 0; b < 2; ++b) {
                    world.setBlock(x - 4 + b * 8, y + py, z - 2 + a, py == 2 && a >= 1 && a <= 3 ? BlockList.laboratory_glass : blockLab);
                    world.setBlock(x - 2 + a, y + py, z - 4 + b * 8, py == 2 && a >= 1 && a <= 3 ? BlockList.laboratory_glass : blockLab);
                }
            }
        }
        for (int px2 = 0; px2 < 9; ++px2) {
            for (pz2 = 0; pz2 < 9; ++pz2) {
                for (int py2 = -1; py2 > -5 && world.isAir(x - 4 + px2, y + py2, z - 4 + pz2) && LaboratoryElementPlacer.isValidFloor(world.getBlock(x - 4 + px2, y + py2 + 1, z - 4 + pz2)); --py2) {
                    world.setBlock(x - 4 + px2, y + py2, z - 4 + pz2, blockLab);
                }
            }
        }
        for (py = 1; py < 4; ++py) {
            for (px = 0; px < 7; ++px) {
                for (pz = 0; pz < 7; ++pz) {
                    if (world.getBlock(x - 3 + px, y + py, z - 3 + pz) == blockLab) continue;
                    world.setBlock(x - 3 + px, y + py, z - 3 + pz, Blocks.field_150350_a);
                }
            }
        }
    }

    public static void generateLargeRoom(LargeStructureWorld world, Random rand, int x, int y, int z) {
        int b;
        int a;
        int py;
        int pz;
        int px;
        for (px = 0; px < 7; ++px) {
            for (pz = 0; pz < 7; ++pz) {
                world.setBlock(x - 3 + pz, y, z - 3 + px, blockFloor);
                world.setBlock(x - 3 + pz, y + 4, z - 3 + px, blockLab);
            }
        }
        for (int a2 = 0; a2 < 5; ++a2) {
            for (int b2 = 0; b2 < 2; ++b2) {
                world.setBlock(x - 4 + 8 * b2, y, z - 2 + a2, blockFloor);
                world.setBlock(x - 4 + 8 * b2, y + 4, z - 2 + a2, blockLab);
                world.setBlock(x - 2 + a2, y, z - 4 + 8 * b2, blockFloor);
                world.setBlock(x - 2 + a2, y + 4, z - 4 + 8 * b2, blockLab);
            }
        }
        for (py = 0; py < 4; ++py) {
            for (a = 0; a < 5; ++a) {
                for (b = 0; b < 2; ++b) {
                    world.setBlock(x - 5 + 10 * b, y + py, z - 2 + a, py == 2 && a >= 1 && a <= 3 ? BlockList.laboratory_glass : blockLab);
                    world.setBlock(x - 2 + a, y + py, z - 5 + 10 * b, py == 2 && a >= 1 && a <= 3 ? BlockList.laboratory_glass : blockLab);
                }
            }
            for (a = 0; a < 2; ++a) {
                for (b = 0; b < 2; ++b) {
                    world.setBlock(x - 4 + 8 * a, y + py, z - 3 + 6 * b, blockLab);
                    world.setBlock(x - 3 + 6 * a, y + py, z - 4 + 8 * b, blockLab);
                }
            }
        }
        for (px = 0; px < 11; ++px) {
            for (pz = 0; pz < 11; ++pz) {
                for (int py2 = -1; py2 > -5 && world.isAir(x - 5 + px, y + py2, z - 5 + pz) && LaboratoryElementPlacer.isValidFloor(world.getBlock(x - 5 + px, y + py2 + 1, z - 5 + pz)); --py2) {
                    world.setBlock(x - 5 + px, y + py2, z - 5 + pz, blockLab);
                }
            }
        }
        for (py = 1; py < 4; ++py) {
            for (int px2 = 0; px2 < 7; ++px2) {
                for (int pz2 = 0; pz2 < 7; ++pz2) {
                    if (world.getBlock(x - 3 + px2, y + py, z - 3 + pz2) == blockLab) continue;
                    world.setBlock(x - 3 + px2, y + py, z - 3 + pz2, Blocks.field_150350_a);
                }
            }
            for (a = 0; a < 5; ++a) {
                for (b = 0; b < 2; ++b) {
                    if (world.getBlock(x - 2 + a, y + py, z - 4 + b * 8) != blockLab) {
                        world.setBlock(x - 2 + a, y + py, z - 4 + b * 8, Blocks.field_150350_a);
                    }
                    if (world.getBlock(x - 4 + b * 8, y + py, z - 2 + a) == blockLab) continue;
                    world.setBlock(x - 4 + b * 8, y + py, z - 2 + a, Blocks.field_150350_a);
                }
            }
        }
    }

    private static boolean isValidFloor(Block block) {
        return block == blockLab || block == blockFloor;
    }
}

