/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.compendium.player;

import chylex.hee.mechanics.compendium.KnowledgeRegistrations;
import chylex.hee.mechanics.compendium.content.KnowledgeFragment;
import chylex.hee.mechanics.compendium.content.KnowledgeObject;
import chylex.hee.mechanics.compendium.objects.ObjectBlock;
import chylex.hee.mechanics.compendium.objects.ObjectDummy;
import chylex.hee.mechanics.compendium.objects.ObjectItem;
import chylex.hee.mechanics.compendium.objects.ObjectMob;
import chylex.hee.mechanics.compendium.player.PlayerDiscoveryList;
import chylex.hee.system.logging.Stopwatch;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.set.hash.TIntHashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import org.apache.commons.lang3.StringUtils;

public class PlayerCompendiumData
implements IExtendedEntityProperties {
    private boolean seenHelp;
    private int pointAmount;
    private final PlayerDiscoveryList<ObjectBlock, ObjectBlock.BlockMetaWrapper> discoveredBlocks = new PlayerDiscoveryList(new DiscoveryBlockSerializer());
    private final PlayerDiscoveryList<ObjectItem, Item> discoveredItems = new PlayerDiscoveryList(new DiscoveryItemSerializer());
    private final PlayerDiscoveryList<ObjectMob, Class<? extends EntityLiving>> discoveredMobs = new PlayerDiscoveryList(new DiscoveryMobSerializer());
    private final PlayerDiscoveryList<ObjectDummy, String> discoveredMisc = new PlayerDiscoveryList(new DiscoveryStringSerializer());
    private final TIntHashSet unlockedFragments = new TIntHashSet();

    public PlayerCompendiumData() {
    }

    @SideOnly(value=Side.CLIENT)
    public PlayerCompendiumData(NBTTagCompound nbt) {
        this.loadNBTData(nbt);
    }

    public boolean seenHelp() {
        return this.seenHelp;
    }

    public void setSeenHelp() {
        this.seenHelp = true;
    }

    public int getPoints() {
        return this.pointAmount;
    }

    public void givePoints(int amount) {
        this.pointAmount += Math.max(0, amount);
    }

    public void payPoints(int amount) {
        this.pointAmount = Math.max(0, this.pointAmount - amount);
    }

    public boolean tryDiscoverObject(KnowledgeObject<?> object, boolean addReward) {
        Object obj = object.getObject();
        if (obj instanceof ObjectBlock) {
            return this.tryDiscoverBlock(object, addReward);
        }
        if (obj instanceof ObjectItem) {
            return this.tryDiscoverItem(object, addReward);
        }
        if (obj instanceof ObjectMob) {
            return this.tryDiscoverMob(object, addReward);
        }
        if (obj instanceof ObjectDummy) {
            return this.discoveredMisc.addObject((ObjectDummy)((Object)object.getObject()));
        }
        return false;
    }

    public boolean hasDiscoveredObject(KnowledgeObject<?> object) {
        if (object == KnowledgeRegistrations.HELP) {
            return true;
        }
        Object obj = object.getObject();
        if (obj instanceof ObjectBlock) {
            return this.discoveredBlocks.hasDiscoveredObject((ObjectBlock)obj);
        }
        if (obj instanceof ObjectItem) {
            return this.discoveredItems.hasDiscoveredObject((ObjectItem)obj);
        }
        if (obj instanceof ObjectMob) {
            return this.discoveredMobs.hasDiscoveredObject((ObjectMob)obj);
        }
        if (obj instanceof ObjectDummy) {
            return this.discoveredMisc.hasDiscoveredObject((ObjectDummy)obj);
        }
        return false;
    }

    public boolean tryDiscoverBlock(KnowledgeObject<ObjectBlock> block, boolean addReward) {
        if (this.discoveredBlocks.addObject(block.getObject())) {
            this.onDiscover(block, addReward);
            return true;
        }
        return false;
    }

    public boolean hasDiscoveredBlock(KnowledgeObject<ObjectBlock> block) {
        return this.discoveredBlocks.hasDiscoveredObject(block.getObject());
    }

    public boolean tryDiscoverItem(KnowledgeObject<ObjectItem> item, boolean addReward) {
        if (this.discoveredItems.addObject(item.getObject())) {
            this.onDiscover(item, addReward);
            return true;
        }
        return false;
    }

    public boolean hasDiscoveredItem(KnowledgeObject<ObjectItem> item) {
        return this.discoveredItems.hasDiscoveredObject(item.getObject());
    }

    public boolean tryDiscoverMob(KnowledgeObject<ObjectMob> mob, boolean addReward) {
        if (this.discoveredMobs.addObject(mob.getObject())) {
            this.onDiscover(mob, addReward);
            return true;
        }
        return false;
    }

    public boolean hasDiscoveredMob(KnowledgeObject<ObjectMob> mob) {
        return this.discoveredMobs.hasDiscoveredObject(mob.getObject());
    }

    private void onDiscover(KnowledgeObject<?> object, boolean addReward) {
        if (addReward) {
            this.unlockDiscoveryFragments(object);
            this.pointAmount += object.getDiscoveryReward();
        }
    }

    private void unlockDiscoveryFragments(KnowledgeObject<?> object) {
        for (KnowledgeFragment fragment : object.getFragments()) {
            if (!fragment.isUnlockedOnDiscovery()) continue;
            this.tryUnlockFragment(fragment);
        }
    }

    public boolean tryUnlockFragment(KnowledgeFragment fragment) {
        if (this.unlockedFragments.add(fragment.globalID)) {
            for (int cascade : fragment.getUnlockCascade()) {
                this.tryUnlockFragment(KnowledgeFragment.getById(cascade));
            }
            return true;
        }
        return false;
    }

    public boolean hasUnlockedFragment(KnowledgeFragment fragment) {
        return fragment != null && this.unlockedFragments.contains(fragment.globalID);
    }

    public FragmentPurchaseStatus canPurchaseFragment(KnowledgeFragment fragment) {
        if (!fragment.isBuyable()) {
            return FragmentPurchaseStatus.NOT_BUYABLE;
        }
        if (this.pointAmount < fragment.getPrice()) {
            return FragmentPurchaseStatus.NOT_ENOUGH_POINTS;
        }
        for (int requirement : fragment.getUnlockRequirements()) {
            if (this.unlockedFragments.contains(requirement)) continue;
            return FragmentPurchaseStatus.REQUIREMENTS_UNFULFILLED;
        }
        return FragmentPurchaseStatus.CAN_PURCHASE;
    }

    public void init(Entity entity, World world) {
    }

    public void saveNBTData(NBTTagCompound nbt) {
        Stopwatch.time("PlayerCompendiumData - save");
        NBTTagCompound hee = new NBTTagCompound();
        hee.func_74757_a("hlp", this.seenHelp);
        hee.func_74768_a("kps", this.pointAmount);
        hee.func_74782_a("fndBlocks", (NBTBase)this.discoveredBlocks.saveToNBTList());
        hee.func_74782_a("fndItems", (NBTBase)this.discoveredItems.saveToNBTList());
        hee.func_74782_a("fndMobs", (NBTBase)this.discoveredMobs.saveToNBTList());
        hee.func_74782_a("fndMisc", (NBTBase)this.discoveredMisc.saveToNBTList());
        hee.func_74782_a("unlocked", (NBTBase)new NBTTagIntArray(this.unlockedFragments.toArray()));
        nbt.func_74782_a("HEE", (NBTBase)hee);
        Stopwatch.finish("PlayerCompendiumData - save");
    }

    public void loadNBTData(NBTTagCompound nbt) {
        Stopwatch.time("PlayerCompendiumData - load");
        NBTTagCompound hee = nbt.func_74775_l("HEE");
        this.seenHelp = hee.func_74767_n("hlp");
        this.pointAmount = hee.func_74762_e("kps");
        this.discoveredBlocks.loadFromNBTList(hee.func_150295_c("fndBlocks", 8));
        this.discoveredItems.loadFromNBTList(hee.func_150295_c("fndItems", 8));
        this.discoveredMobs.loadFromNBTList(hee.func_150295_c("fndMobs", 8));
        this.discoveredMisc.loadFromNBTList(hee.func_150295_c("fndMisc", 8));
        this.unlockedFragments.clear();
        this.unlockedFragments.addAll(hee.func_74759_k("unlocked"));
        Stopwatch.finish("PlayerCompendiumData - load");
    }

    public static enum FragmentPurchaseStatus {
        CAN_PURCHASE,
        NOT_BUYABLE,
        NOT_ENOUGH_POINTS,
        REQUIREMENTS_UNFULFILLED;

    }

    private static class DiscoveryStringSerializer
    implements PlayerDiscoveryList.IObjectSerializer<String> {
        private DiscoveryStringSerializer() {
        }

        @Override
        public String serialize(String object) {
            return object;
        }

        @Override
        public String deserialize(String data) {
            return data;
        }
    }

    private static class DiscoveryMobSerializer
    implements PlayerDiscoveryList.IObjectSerializer<Class<? extends EntityLiving>> {
        private DiscoveryMobSerializer() {
        }

        @Override
        public String serialize(Class<? extends EntityLiving> object) {
            return (String)EntityList.field_75626_c.get(object);
        }

        @Override
        public Class<? extends EntityLiving> deserialize(String data) {
            return (Class)EntityList.field_75625_b.get(data);
        }
    }

    private static class DiscoveryItemSerializer
    implements PlayerDiscoveryList.IObjectSerializer<Item> {
        private DiscoveryItemSerializer() {
        }

        @Override
        public String serialize(Item object) {
            GameRegistry.UniqueIdentifier identifier = GameRegistry.findUniqueIdentifierFor((Item)object);
            return identifier.modId + ":" + identifier.name;
        }

        @Override
        public Item deserialize(String data) {
            return (Item)GameData.getItemRegistry().func_82594_a(data);
        }
    }

    private static class DiscoveryBlockSerializer
    implements PlayerDiscoveryList.IObjectSerializer<ObjectBlock.BlockMetaWrapper> {
        private DiscoveryBlockSerializer() {
        }

        @Override
        public String serialize(ObjectBlock.BlockMetaWrapper object) {
            GameRegistry.UniqueIdentifier identifier = GameRegistry.findUniqueIdentifierFor((Block)object.block);
            return identifier.modId + ":" + identifier.name + ":" + object.metadata;
        }

        @Override
        public ObjectBlock.BlockMetaWrapper deserialize(String data) {
            int secondColonIndex = data.lastIndexOf(":");
            String meta = data.substring(secondColonIndex + 1);
            if (!meta.equals("-1") && !StringUtils.isNumeric((CharSequence)meta)) {
                return null;
            }
            return new ObjectBlock.BlockMetaWrapper((Block)GameData.getBlockRegistry().func_82594_a(data.substring(0, secondColonIndex)), Integer.parseInt(meta));
        }
    }
}

