/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.compendium.content;

import chylex.hee.mechanics.compendium.content.KnowledgeCategory;
import chylex.hee.mechanics.compendium.content.KnowledgeFragment;
import chylex.hee.mechanics.compendium.objects.IKnowledgeObjectInstance;
import chylex.hee.mechanics.compendium.util.IGuiItemStackRenderer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class KnowledgeObject<T extends IKnowledgeObjectInstance<?>>
implements IGuiItemStackRenderer {
    private static int lastUsedID = 0;
    private static final int iconDist = 12;
    private static final TIntObjectHashMap<KnowledgeObject<?>> allObjects = new TIntObjectHashMap();
    public final int globalID;
    private final T theObject;
    private final ItemStack itemToRender;
    private final String tooltip;
    private final Set<KnowledgeFragment> fragmentSet = new LinkedHashSet<KnowledgeFragment>();
    private ImmutableSet<KnowledgeFragment> fragmentSetImmutable = ImmutableSet.of();
    private int x;
    private int y;
    private int unlockPrice;
    private int reward;

    public static <T extends IKnowledgeObjectInstance<?>> KnowledgeObject<T> getObject(Object o) {
        for (KnowledgeObject knowledgeObject : allObjects.valueCollection()) {
            if (!knowledgeObject.theObject.checkEquality(o)) continue;
            return knowledgeObject;
        }
        return null;
    }

    public static <T extends IKnowledgeObjectInstance<?>> KnowledgeObject<T> getObjectById(int id) {
        return (KnowledgeObject)allObjects.get(id);
    }

    public static ImmutableList<KnowledgeObject<?>> getAllObjects() {
        return ImmutableList.copyOf((Collection)allObjects.valueCollection());
    }

    public KnowledgeObject(T theObject) {
        this(theObject, theObject.createItemStackToRender());
    }

    public KnowledgeObject(T theObject, ItemStack itemToRender) {
        this(theObject, itemToRender, itemToRender.func_82833_r());
    }

    public KnowledgeObject(T theObject, String tooltip) {
        this(theObject, theObject.createItemStackToRender(), tooltip);
    }

    public KnowledgeObject(T theObject, ItemStack itemToRender, String tooltip) {
        this.theObject = theObject;
        this.itemToRender = itemToRender;
        this.tooltip = tooltip;
        this.globalID = ++lastUsedID;
        allObjects.put(this.globalID, (Object)this);
    }

    public KnowledgeObject setPos(int x, int y) {
        if (x < 0 || y < 0) {
            throw new IllegalArgumentException("Invalid KnowledgeObject position, x and y have to be >= 0 (" + x + "," + y + ")");
        }
        this.x = (x + 1) * 12;
        this.y = y * 12;
        return this;
    }

    public KnowledgeObject setCategoryObject(KnowledgeCategory category) {
        this.x = Integer.MIN_VALUE;
        category.setCategoryObject(this);
        return this;
    }

    public KnowledgeObject setUnlockPrice(int price) {
        this.unlockPrice = price;
        return this;
    }

    public KnowledgeObject setNonBuyable() {
        this.unlockPrice = -1;
        return this;
    }

    public KnowledgeObject setDiscoveryReward(int reward) {
        this.reward = reward;
        return this;
    }

    public KnowledgeObject addFragments(KnowledgeFragment[] fragments) {
        for (KnowledgeFragment fragment : fragments) {
            this.fragmentSet.add(fragment);
        }
        this.fragmentSetImmutable = ImmutableSet.copyOf(this.fragmentSet);
        return this;
    }

    public Set<KnowledgeFragment> getFragments() {
        return this.fragmentSetImmutable;
    }

    public T getObject() {
        return this.theObject;
    }

    public boolean isCategoryObject() {
        return this.x == Integer.MIN_VALUE;
    }

    public boolean isBuyable() {
        return this.unlockPrice != -1;
    }

    public int getUnlockPrice() {
        return this.unlockPrice;
    }

    public int getDiscoveryReward() {
        return this.reward;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public ItemStack getItemStack() {
        return this.itemToRender;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTooltip() {
        return I18n.func_135052_a((String)this.tooltip, (Object[])new Object[0]);
    }

    public String getUnlocalizedTooltip() {
        return this.tooltip;
    }

    public boolean equals(Object o) {
        if (o instanceof KnowledgeObject) {
            KnowledgeObject obj = (KnowledgeObject)o;
            return obj.globalID == this.globalID || obj.theObject == this.theObject;
        }
        return false;
    }

    public int hashCode() {
        return this.globalID;
    }

    public static final class LinkedKnowledgeObject<T extends IKnowledgeObjectInstance<?>>
    extends KnowledgeObject<T> {
        private final KnowledgeObject<T> linkedObject;

        public LinkedKnowledgeObject(KnowledgeObject<T> linkedObject) {
            this(linkedObject, linkedObject.getItemStack());
        }

        public LinkedKnowledgeObject(KnowledgeObject<T> linkedObject, ItemStack itemToRender) {
            this(linkedObject, itemToRender, itemToRender.func_82833_r());
        }

        public LinkedKnowledgeObject(KnowledgeObject<T> linkedObject, String tooltip) {
            this(linkedObject, linkedObject.getItemStack(), tooltip);
        }

        public LinkedKnowledgeObject(KnowledgeObject<T> linkedObject, ItemStack itemToRender, String tooltip) {
            super(linkedObject.getObject(), itemToRender, tooltip);
            this.linkedObject = linkedObject;
        }

        @Override
        public KnowledgeObject setUnlockPrice(int price) {
            throw new UnsupportedOperationException("Cannot modify unlock price in linked Knowledge Objects.");
        }

        @Override
        public KnowledgeObject setDiscoveryReward(int reward) {
            throw new UnsupportedOperationException("Cannot modify discovery reward in linked Knowledge Objects.");
        }

        @Override
        public KnowledgeObject addFragments(KnowledgeFragment[] fragments) {
            throw new UnsupportedOperationException("Cannot modify fragments in linked Knowledge Objects.");
        }

        @Override
        public boolean isBuyable() {
            return this.linkedObject.isBuyable();
        }

        @Override
        public int getUnlockPrice() {
            return this.linkedObject.getUnlockPrice();
        }

        @Override
        public int getDiscoveryReward() {
            return this.linkedObject.getDiscoveryReward();
        }

        @Override
        public Set<KnowledgeFragment> getFragments() {
            return this.linkedObject.getFragments();
        }
    }
}

