/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.item;

import chylex.hee.init.BlockList;
import chylex.hee.system.achievements.AchievementManager;
import chylex.hee.system.util.MathUtil;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.stats.StatBase;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;

public class ItemScorchingPickaxe
extends Item {
    private static final Pattern oreRegex = Pattern.compile("(?:^ore[A-Z].+$)|(?:^ore_.+$)|(?:.+_ore$)|(?:.+Ore$)");
    private static final Map<Block, Boolean> cachedBlocks = new IdentityHashMap<Block, Boolean>();
    private static final List<Block> cachedOres = new ArrayList<Block>();
    private static final Random cacheRand = new Random(0L);

    public static final boolean isBlockValid(Block block) {
        Item drop;
        if (cachedBlocks.containsKey(block)) {
            return cachedBlocks.get(block);
        }
        if (FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(block)) != null) {
            cachedBlocks.put(block, true);
            return true;
        }
        GameRegistry.UniqueIdentifier name = GameRegistry.findUniqueIdentifierFor((Block)block);
        if (name == null) {
            cachedBlocks.put(block, false);
            return false;
        }
        if (oreRegex.matcher(name.name).find() && (drop = block.func_149650_a(0, cacheRand, 0)) != null && !(drop instanceof ItemBlock)) {
            int testAmt = 0;
            for (int a = 0; a < 50; ++a) {
                testAmt += block.func_149679_a(10, cacheRand);
            }
            boolean isValid = testAmt > 50;
            cachedBlocks.put(block, isValid);
            cachedOres.add(block);
            return isValid;
        }
        cachedBlocks.put(block, false);
        return false;
    }

    public static final boolean isBlockOre(Block block) {
        return ItemScorchingPickaxe.isBlockValid(block) && cachedOres.contains(block);
    }

    public boolean func_150894_a(ItemStack is, World world, Block block, int x, int y, int z, EntityLivingBase owner) {
        if ((double)block.func_149712_f(world, x, y, z) != 0.0) {
            is.func_77972_a(1, owner);
        }
        return true;
    }

    public boolean func_77644_a(ItemStack is, EntityLivingBase hitEntity, EntityLivingBase owner) {
        is.func_77972_a(2, owner);
        return true;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (ItemScorchingPickaxe.isBlockValid(block)) {
            return 8.0f;
        }
        if (block == BlockList.ravaged_brick) {
            return 16.0f;
        }
        return super.getDigSpeed(stack, block, meta);
    }

    public boolean canHarvestBlock(Block block, ItemStack is) {
        return ItemScorchingPickaxe.isBlockValid(block) || block == BlockList.ravaged_brick;
    }

    public int getHarvestLevel(ItemStack is, String toolClass) {
        return toolClass.equals("pickaxe") ? 100 : -1;
    }

    public Set<String> getToolClasses(ItemStack is) {
        return ImmutableSet.of((Object)"pickaxe");
    }

    public void func_77622_d(ItemStack is, World world, EntityPlayer player) {
        player.func_71064_a((StatBase)AchievementManager.SCORCHING_PICKAXE, 1);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockDropItems(BlockEvent.HarvestDropsEvent e) {
        if (e.harvester == null) {
            return;
        }
        ItemStack heldItem = e.harvester.func_70694_bm();
        if (heldItem == null || heldItem.func_77973_b() != this) {
            return;
        }
        if (ItemScorchingPickaxe.isBlockValid(e.block) && !e.drops.isEmpty()) {
            e.dropChance = 1.0f;
            ItemStack drop = (ItemStack)e.drops.get(0);
            drop.field_77994_a = 1;
            for (ItemStack blockDrop : e.drops) {
                if (drop.func_77973_b() == blockDrop.func_77973_b()) continue;
                return;
            }
            e.drops.clear();
            Random rand = e.world.field_73012_v;
            if (drop.func_77973_b() instanceof ItemBlock) {
                ItemStack result = null;
                ItemStack smelted = FurnaceRecipes.func_77602_a().func_151395_a(drop);
                if (smelted == null) {
                    return;
                }
                if (smelted.func_77973_b() instanceof ItemBlock) {
                    result = smelted.func_77946_l();
                } else {
                    result = smelted.func_77946_l();
                    int fortune = 0;
                    for (int a = 0; a < 5; ++a) {
                        fortune += 1 + rand.nextInt(3 + rand.nextInt(3));
                    }
                    result.field_77994_a = fortune = 1 + MathUtil.floor((double)fortune * (0.35 * rand.nextDouble() * rand.nextDouble() * Math.pow(FurnaceRecipes.func_77602_a().func_151398_b(result), 2.6) + (double)fortune * 0.06) / 6.4);
                }
                e.drops.add(result);
            } else {
                int a;
                int fortune = 0;
                for (a = 0; a < 4; ++a) {
                    fortune += e.block.quantityDropped(e.blockMetadata, 3 + rand.nextInt(3) - rand.nextInt(2), rand);
                }
                for (a = 0; a < 4; ++a) {
                    fortune += e.block.quantityDropped(e.blockMetadata, 0, rand);
                }
                drop.field_77994_a = fortune = 1 + MathUtil.floor(((double)fortune + (double)e.block.getExpDrop((IBlockAccess)e.world, e.blockMetadata, 0) / 2.0) * (rand.nextDouble() + rand.nextDouble() * 0.5 + 0.35) / 6.0);
                e.drops.add(drop);
            }
        }
    }
}

