/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.ControlText;
import binnie.core.craftgui.controls.ControlTextCentered;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.geometry.TextJustification;
import binnie.core.util.I18N;
import binnie.genetics.gui.ControlAnalystPage;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import net.minecraft.util.EnumChatFormatting;

public class AnalystPageDescription
extends ControlAnalystPage {
    public AnalystPageDescription(IWidget parent, IArea area, IIndividual ind) {
        super(parent, area);
        this.setColor(0x333333);
        int y = 4;
        IAlleleSpecies species = ind.getGenome().getPrimary();
        String branchBinomial = species.getBranch() != null ? species.getBranch().getScientific() : I18N.localise("genetics.gui.analyst.description.unknown");
        String desc = species.getDescription();
        StringBuilder descBody = new StringBuilder(EnumChatFormatting.ITALIC.toString());
        String descSig = "";
        if (desc == null || desc.isEmpty() || desc.matches("(\\w+\\.?)+")) {
            descBody.append("");
        } else {
            String[] descStrings = desc.split("\\|");
            descBody.append(descStrings[0]);
            for (int i = 1; i < descStrings.length - 1; ++i) {
                descBody.append(" ").append(descStrings[i]);
            }
            if (descStrings.length > 1) {
                descSig = descSig + descStrings[descStrings.length - 1];
            }
        }
        String authority = species.getAuthority();
        if (authority.contains("Binnie")) {
            authority = EnumChatFormatting.DARK_BLUE.toString() + authority;
        }
        if (authority.contains("Sengir")) {
            authority = EnumChatFormatting.DARK_GREEN.toString() + authority;
        }
        if (authority.contains("MysteriousAges")) {
            authority = EnumChatFormatting.DARK_PURPLE.toString() + authority;
        }
        new ControlTextCentered((IWidget)this, y, EnumChatFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        new ControlTextCentered((IWidget)this, y += 16, species.getName() + EnumChatFormatting.RESET).setColor(this.getColor());
        new ControlTextCentered((IWidget)this, y += 10, EnumChatFormatting.ITALIC + branchBinomial + " " + species.getBinomial() + EnumChatFormatting.RESET).setColor(this.getColor());
        new ControlTextCentered((IWidget)this, y += 20, EnumChatFormatting.BOLD + I18N.localise("genetics.gui.analyst.description.discoveredBy", authority) + EnumChatFormatting.RESET).setColor(this.getColor());
        new ControlTextCentered((IWidget)this, y += (int)(3.0f + CraftGUI.render.textHeight(EnumChatFormatting.BOLD + I18N.localise("genetics.gui.analyst.description.discoveredBy", authority) + EnumChatFormatting.RESET, this.w())), I18N.localise("genetics.gui.analyst.description.complexity", species.getComplexity())).setColor(this.getColor());
        ControlText descText = new ControlText(this, new IArea(8.0f, y += 26, this.w() - 16.0f, 0.0f), descBody.toString() + EnumChatFormatting.RESET, TextJustification.TOP_CENTER);
        ControlText signatureText = new ControlText(this, new IArea(8.0f, y, this.w() - 16.0f, 0.0f), descSig + EnumChatFormatting.RESET, TextJustification.BOTTOM_RIGHT);
        descText.setColor(this.getColor());
        signatureText.setColor(this.getColor());
        float descHeight = CraftGUI.render.textHeight(descText.getValue(), descText.getSize().x());
        signatureText.setPosition(new IPoint(signatureText.pos().x(), descText.getPosition().y() + descHeight + 10.0f));
        this.setSize(new IPoint(this.w(), 20.0f + signatureText.y()));
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.description");
    }
}

