/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.controls.listbox;

import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.WidgetAttribute;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.controls.core.IControlValue;
import binnie.core.craftgui.controls.listbox.ControlList;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventMouse;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;

public class ControlOption<T>
extends Control
implements IControlValue<T> {
    protected T value;
    private EventMouse.Down.Handler mouseHandler = new EventMouse.Down.Handler(){

        @Override
        public void onEvent(EventMouse.Down event) {
            ((IControlValue)ControlOption.this.getParent()).setValue(ControlOption.this.getValue());
        }
    };

    public ControlOption(ControlList<T> controlList, T option) {
        this(controlList, option, 16);
    }

    public ControlOption(ControlList<T> controlList, T option, int height) {
        super(controlList, 0.0f, height, controlList.getSize().x(), 20.0f);
        this.value = option;
        if (this.value != null) {
            this.addAttribute(WidgetAttribute.MOUSE_OVER);
        }
        this.addSelfEventHandler((EventHandler)this.mouseHandler);
    }

    @Override
    public void onUpdateClient() {
        if (this.getValue() == null) {
            return;
        }
        int color = 0xA0A0A0;
        if (this.isCurrentSelection()) {
            color = 0xFFFFFF;
        }
        this.setColor(color);
    }

    @Override
    public void onRenderForeground() {
        if (this.isCurrentSelection()) {
            CraftGUI.render.texture((Object)CraftGUITexture.Outline, this.getArea());
        }
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    public boolean isCurrentSelection() {
        return this.getValue() != null && this.getValue().equals(((IControlValue)this.getParent()).getValue());
    }
}

