/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.ceramic;

import binnie.botany.Botany;
import binnie.botany.ceramic.CeramicColor;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.botany.items.BotanyItems;
import binnie.core.AbstractMod;
import binnie.core.BinnieCore;
import binnie.extratrees.api.IDesignMaterial;
import binnie.extratrees.api.IDesignSystem;
import binnie.extratrees.api.IPattern;
import binnie.extratrees.carpentry.DesignerManager;
import binnie.extratrees.carpentry.EnumPattern;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class CeramicDesignSystem
implements IDesignSystem {
    public static CeramicDesignSystem instance = new CeramicDesignSystem();
    protected Map<Integer, IIcon> primary = new HashMap<Integer, IIcon>();
    protected Map<Integer, IIcon> secondary = new HashMap<Integer, IIcon>();

    CeramicDesignSystem() {
        DesignerManager.instance.registerDesignSystem(this);
    }

    @Override
    public IDesignMaterial getDefaultMaterial() {
        return CeramicColor.get(EnumFlowerColor.WHITE);
    }

    @Override
    public IDesignMaterial getDefaultMaterial2() {
        return CeramicColor.get(EnumFlowerColor.BLACK);
    }

    @Override
    public IDesignMaterial getMaterial(int id) {
        return CeramicColor.get(EnumFlowerColor.get(id));
    }

    @Override
    public int getMaterialIndex(IDesignMaterial id) {
        return ((CeramicColor)id).color.ordinal();
    }

    public String getTexturePath() {
        return "ceramic";
    }

    @Override
    public IIcon getPrimaryIcon(IPattern pattern) {
        if (pattern instanceof EnumPattern) {
            return this.primary.get(((EnumPattern)pattern).ordinal());
        }
        return null;
    }

    @Override
    public IIcon getSecondaryIcon(IPattern pattern) {
        if (pattern instanceof EnumPattern) {
            return this.secondary.get(((EnumPattern)pattern).ordinal());
        }
        return null;
    }

    @Override
    public void registerIcons(IIconRegister register) {
        for (EnumPattern pattern : EnumPattern.values()) {
            this.primary.put(pattern.ordinal(), BinnieCore.proxy.getIcon(register, this.getMod().getModID(), this.getTexturePath() + "/" + pattern.toString().toLowerCase() + ".0"));
            this.secondary.put(pattern.ordinal(), BinnieCore.proxy.getIcon(register, this.getMod().getModID(), this.getTexturePath() + "/" + pattern.toString().toLowerCase() + ".1"));
        }
    }

    public AbstractMod getMod() {
        return Botany.instance;
    }

    @Override
    public ItemStack getAdhesive() {
        return BotanyItems.Mortar.get(1);
    }

    @Override
    public IDesignMaterial getMaterial(ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)Botany.ceramic) ? this.getMaterial(stack.func_77960_j()) : null;
    }
}

