/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.tile;

import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.block.ARBlocks;
import de.katzenpapst.amunra.helper.CoordHelper;
import de.katzenpapst.amunra.mothership.fueldisplay.MothershipFuelDisplay;
import de.katzenpapst.amunra.mothership.fueldisplay.MothershipFuelDisplayEnergy;
import de.katzenpapst.amunra.mothership.fueldisplay.MothershipFuelDisplayFluid;
import de.katzenpapst.amunra.mothership.fueldisplay.MothershipFuelRequirements;
import de.katzenpapst.amunra.proxy.ARSidedProxy;
import de.katzenpapst.amunra.tile.TileEntityMothershipEngineAbstract;
import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityMothershipEngineIon
extends TileEntityMothershipEngineAbstract {
    protected MothershipFuelDisplay fuelType = null;
    protected MothershipFuelDisplay fuelTypeEnergy = null;
    public static Fluid coolant;

    public TileEntityMothershipEngineIon() {
        this.boosterBlock = ARBlocks.blockMsEngineIonBooster;
        this.containingItems = new ItemStack[2];
        this.fuel = coolant;
        this.fuelType = new MothershipFuelDisplayFluid(this.fuel);
        this.fuelTypeEnergy = MothershipFuelDisplayEnergy.getInstance();
    }

    @Override
    protected void startSound() {
        super.startSound();
        AmunRa.proxy.playTileEntitySound((TileEntity)this, new ResourceLocation(GalacticraftCore.TEXTURE_PREFIX + "entity.astrominer"));
    }

    @Override
    protected void spawnParticles() {
        Vector3 particleStart = this.getExhaustPosition(1.8);
        Vector3 particleDirection = this.getExhaustDirection().scale(5.0);
        AmunRa.proxy.spawnParticles(ARSidedProxy.ParticleType.PT_MOTHERSHIP_ION_FLAME, this.field_145850_b, particleStart, particleDirection);
        AmunRa.proxy.spawnParticles(ARSidedProxy.ParticleType.PT_MOTHERSHIP_ION_FLAME, this.field_145850_b, particleStart, particleDirection);
        AmunRa.proxy.spawnParticles(ARSidedProxy.ParticleType.PT_MOTHERSHIP_ION_FLAME, this.field_145850_b, particleStart, particleDirection);
        AmunRa.proxy.spawnParticles(ARSidedProxy.ParticleType.PT_MOTHERSHIP_ION_FLAME, this.field_145850_b, particleStart, particleDirection);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{0, 1};
    }

    @Override
    public void beginTransit(long duration) {
        MothershipFuelRequirements reqs = this.getFuelRequirements(duration);
        int energyReq = reqs.get(this.fuelTypeEnergy);
        int fuelReq = reqs.get(this.fuelType);
        this.storage.extractEnergyGCnoMax((float)energyReq, false);
        this.fuelTank.drain(fuelReq, true);
        super.beginTransit(duration);
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.mothershipEngineIon.name");
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        switch (index) {
            case 0: {
                FluidStack containedFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
                if (containedFluid == null || containedFluid.getFluid() != this.fuel) break;
                return true;
            }
            case 1: {
                return ItemElectricBase.isElectricItem((Item)stack.func_77973_b());
            }
        }
        return false;
    }

    public float getFuelUsagePerTick() {
        return 1.0f;
    }

    public float getEnergyUsagePerTick() {
        return 10.0f;
    }

    public boolean shouldUseEnergy() {
        return false;
    }

    @Override
    public double getThrust() {
        return (double)this.getNumBoosters() * 2.5E7;
    }

    @Override
    protected int getTankCapacity() {
        return 2000 * this.numBoosters;
    }

    protected float getEnergyCapacity() {
        return 16000.0f * (float)this.numBoosters;
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (this.fuel != fluid && !FluidRegistry.getFluidName((Fluid)fluid).equals(this.fuel.getName())) {
            return false;
        }
        return super.canFill(from, fluid);
    }

    @Override
    protected boolean isItemFuel(ItemStack itemstack) {
        FluidStack containedFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack);
        return containedFluid != null && containedFluid.getFluid() == this.fuel;
    }

    @Override
    public int getRotationMeta(int meta) {
        return (meta & 0xC) >> 2;
    }

    @Override
    public ForgeDirection getElectricInputDirection() {
        int metadata = this.getRotationMeta(this.func_145832_p());
        return CoordHelper.rotateForgeDirection(ForgeDirection.SOUTH, metadata);
    }

    public EnumSet<ForgeDirection> getElectricalInputDirections() {
        return EnumSet.allOf(ForgeDirection.class);
    }

    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        return direction != null && !ForgeDirection.UNKNOWN.equals((Object)direction) && type == NetworkType.POWER;
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return this.containingItems[1];
    }

    @Override
    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return p_102008_1_ == 0 || p_102008_1_ == 1;
    }

    @Override
    public void slowDischarge() {
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        float capacity = compound.func_74760_g("energyCapacity");
        this.storage.setCapacity(capacity);
        super.func_145839_a(compound);
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74776_a("energyCapacity", this.storage.getCapacityGC());
    }

    @Override
    protected void createMultiblockInternal(boolean notifyClient) {
        super.createMultiblockInternal(notifyClient);
        this.storage.setCapacity(this.getEnergyCapacity());
    }

    @Override
    public MothershipFuelRequirements getFuelRequirements(long duration) {
        int totalFuelNeed = (int)Math.ceil(this.getFuelUsagePerTick() * (float)duration * AmunRa.config.mothershipFuelFactor);
        float totalEnergyNeed = this.getEnergyUsagePerTick() * (float)duration * AmunRa.config.mothershipFuelFactor;
        MothershipFuelRequirements result = new MothershipFuelRequirements();
        result.add(this.fuelType, totalFuelNeed);
        result.add(this.fuelTypeEnergy, (int)totalEnergyNeed);
        return result;
    }

    @Override
    public boolean canRunForDuration(long duration) {
        MothershipFuelRequirements reqs = this.getFuelRequirements(duration);
        int fuelNeeded = reqs.get(this.fuelType);
        int powerNeeded = reqs.get(this.fuelTypeEnergy);
        return this.storage.getEnergyStoredGC() >= (float)powerNeeded && this.fuelTank.getFluidAmount() > fuelNeeded;
    }
}

