/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.entity;

import de.katzenpapst.amunra.entity.EntityBaseLaserArrow;
import de.katzenpapst.amunra.mob.DamageSourceAR;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityCryoArrow
extends EntityBaseLaserArrow {
    private static final ResourceLocation arrowTextures = new ResourceLocation("amunra", "textures/entity/cryoarrow.png");

    public EntityCryoArrow(World world) {
        super(world);
    }

    public EntityCryoArrow(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Override
    protected int getEntityDependentDamage(Entity ent, int regularDamage) {
        if (ent instanceof EntityBlaze) {
            return regularDamage * 2;
        }
        return regularDamage;
    }

    public EntityCryoArrow(World world, EntityLivingBase shootingEntity, EntityLivingBase target, float randMod) {
        super(world, shootingEntity, target, randMod);
    }

    @Override
    protected void onPassThrough(int x, int y, int z) {
        Block b = this.field_70170_p.func_147439_a(x, y, z);
        if (b == Blocks.field_150355_j) {
            this.field_70170_p.func_147449_b(x, y, z, Blocks.field_150432_aD);
            this.field_70171_ac = false;
        }
        if (b == Blocks.field_150353_l) {
            this.func_85030_a("random.fizz", 0.7f, 1.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
            this.field_70170_p.func_147449_b(x, y, z, Blocks.field_150343_Z);
        }
    }

    public EntityCryoArrow(World par1World, EntityLivingBase par2EntityLivingBase) {
        super(par1World, par2EntityLivingBase);
    }

    @Override
    protected float getSpeed() {
        return 3.0f;
    }

    @Override
    protected float getDamage() {
        return 1.0f;
    }

    @Override
    protected boolean doesFireDamage() {
        return false;
    }

    @Override
    public ResourceLocation getTexture() {
        return arrowTextures;
    }

    @Override
    protected void onImpactEntity(MovingObjectPosition mop) {
        Entity entity = mop.field_72308_g;
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase entityLiving = (EntityLivingBase)entity;
            if (entityLiving.func_70027_ad()) {
                entityLiving.func_70066_B();
            }
            entityLiving.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 100, 3));
        }
    }

    @Override
    protected void onImpactBlock(World worldObj, int x, int y, int z) {
        Block block = worldObj.func_147439_a(x, y, z);
        if (block == Blocks.field_150353_l) {
            worldObj.func_147449_b(x, y, z, Blocks.field_150343_Z);
        } else if (block == Blocks.field_150480_ab) {
            worldObj.func_147449_b(x, y, z, Blocks.field_150350_a);
        } else if (worldObj.func_147439_a(x, y + 1, z) == Blocks.field_150480_ab) {
            worldObj.func_147449_b(x, y + 1, z, Blocks.field_150350_a);
        }
    }

    @Override
    protected DamageSource getDamageSource() {
        if (this.shootingEntity == null) {
            return DamageSourceAR.causeLaserDamage("ar_coldray", this, this);
        }
        return DamageSourceAR.causeLaserDamage("ar_coldray", this, this.shootingEntity);
    }
}

