/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.block.bush;

import de.katzenpapst.amunra.block.bush.BlockBushMulti;
import de.katzenpapst.amunra.block.bush.SubBlockBush;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.TerrainGen;

public abstract class AbstractSapling
extends SubBlockBush {
    protected BlockMetaPair wood;
    protected BlockMetaPair leaves;

    public AbstractSapling(String name, String texture) {
        super(name, texture);
    }

    public AbstractSapling setWood(BlockMetaPair wood) {
        this.wood = wood;
        return this;
    }

    public AbstractSapling setLeaves(BlockMetaPair leaves) {
        this.leaves = leaves;
        return this;
    }

    public void func_149674_a(World worldIn, int x, int y, int z, Random random) {
        if (worldIn.func_72957_l(x, y + 1, z) >= 9 && random.nextInt(7) == 0) {
            this.prepareGrowTree(worldIn, x, y, z, random);
        }
    }

    public void prepareGrowTree(World worldIn, int x, int y, int z, Random random) {
        int meta = worldIn.func_72805_g(x, y, z);
        if ((meta & 8) == 0) {
            worldIn.func_72921_c(x, y, z, meta | 8, 4);
        } else {
            this.growTree(worldIn, x, y, z, random);
        }
    }

    public void growTree(World worldIn, int x, int y, int z, Random random) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)random, (int)x, (int)y, (int)z)) {
            return;
        }
        int meta = worldIn.func_72805_g(x, y, z) & 7;
        worldIn.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 4);
        if (!this.generate(worldIn, random, x, y, z, true)) {
            worldIn.func_147465_d(x, y, z, (Block)this.parent, meta, 4);
        }
    }

    public boolean checkBlockAt(World world, int x, int y, int z, int metadata) {
        return world.func_147439_a(x, y, z) == this && (world.func_72805_g(x, y, z) & 7) == metadata;
    }

    @Override
    public boolean func_149851_a(World worldIn, int x, int y, int z, boolean isClient) {
        return true;
    }

    @Override
    public boolean func_149852_a(World worldIn, Random random, int x, int y, int z) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    @Override
    public void func_149853_b(World worldIn, Random random, int x, int y, int z) {
        this.prepareGrowTree(worldIn, x, y, z, random);
    }

    protected boolean isBlockReplaceable(Block block) {
        return block instanceof BlockBushMulti || block.func_149688_o() == Material.field_151579_a || block.func_149688_o() == Material.field_151584_j || block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150364_r || block == Blocks.field_150363_s || block == Blocks.field_150345_g || block == Blocks.field_150395_bd;
    }

    protected boolean canReplaceBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block.isAir((IBlockAccess)world, x, y, z) || block.isLeaves((IBlockAccess)world, x, y, z) || block.isWood((IBlockAccess)world, x, y, z) || this.isBlockReplaceable(block);
    }

    protected void setBlockAndNotifyAdequately(World world, int x, int y, int z, Block block, int meta, boolean notify) {
        if (notify) {
            world.func_147465_d(x, y, z, block, meta, 3);
        } else {
            world.func_147465_d(x, y, z, block, meta, 2);
        }
    }

    public abstract boolean generate(World var1, Random var2, int var3, int var4, int var5, boolean var6);
}

