/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBoundingBox;
import net.malisis.core.renderer.icon.ClippedIcon;
import net.malisis.core.renderer.icon.MalisisIcon;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.RaytraceBlock;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.door.DoorDescriptor;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.malisis.doors.gui.DigicodeGui;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public class Door
extends BlockDoor
implements ITileEntityProvider,
IBoundingBox {
    public static Block[] centerBlocks = new Block[]{Blocks.field_150411_aY, Blocks.field_150463_bK, Blocks.field_150422_aJ};
    public static final int DIR_WEST = 0;
    public static final int DIR_NORTH = 1;
    public static final int DIR_EAST = 2;
    public static final int DIR_SOUTH = 3;
    public static final float DOOR_WIDTH = 0.1875f;
    public static final int FLAG_OPENED = 4;
    public static final int FLAG_TOPBLOCK = 8;
    public static final int FLAG_REVERSED = 16;
    protected MalisisIcon[] iconTop;
    protected MalisisIcon[] iconBottom;
    protected String soundPath;
    private DoorDescriptor descriptor;

    public Door(DoorDescriptor desc) {
        super(desc.getMaterial());
        this.descriptor = desc;
        this.func_149711_c(desc.getHardness());
        this.func_149672_a(desc.getSoundType());
        this.func_149663_c(desc.getName());
        this.func_149658_d(desc.getTextureName());
    }

    public Door(Material material) {
        super(material);
    }

    public DoorDescriptor getDescriptor() {
        return this.descriptor;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        String textureName = this.func_149641_N();
        MalisisIcon top = new MalisisIcon(textureName + "_upper").register((TextureMap)register);
        MalisisIcon bottom = new MalisisIcon(textureName + "_lower").register((TextureMap)register);
        if (textureName.equals("door_wood") || textureName.equals("door_iron")) {
            textureName = "malisisdoors:" + textureName;
        }
        MalisisIcon side = new MalisisIcon(textureName + "_side").register((TextureMap)register);
        float w = 0.1875f;
        this.iconTop = new MalisisIcon[6];
        this.iconTop[0] = new ClippedIcon(side, 0.0f, 0.0f, w, 1.0f);
        this.iconTop[0].setRotation(1);
        this.iconTop[1] = this.iconTop[0];
        this.iconTop[2] = top;
        this.iconTop[3] = top;
        this.iconTop[4] = new ClippedIcon(side, w, 0.0f, w, 1.0f);
        this.iconTop[5] = new ClippedIcon(side, 2.0f * w, 0.0f, w, 1.0f);
        this.iconBottom = new MalisisIcon[6];
        this.iconBottom[0] = this.iconTop[0];
        this.iconBottom[1] = this.iconTop[0];
        this.iconBottom[2] = bottom;
        this.iconBottom[3] = bottom;
        this.iconBottom[4] = new ClippedIcon(side, 3.0f * w, 0.0f, w, 1.0f);
        this.iconBottom[5] = new ClippedIcon(side, 4.0f * w, 0.0f, w, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        boolean topBlock = (metadata & 8) != 0;
        boolean reversed = (metadata & 0x10) != 0;
        boolean flipH = false;
        boolean flipV = false;
        MalisisIcon icon = this.iconBottom[2];
        switch (side) {
            case 4: {
                side = reversed ? 5 : 4;
                break;
            }
            case 5: {
                side = reversed ? 4 : 5;
                break;
            }
            case 0: 
            case 1: {
                flipV = !reversed;
            }
            case 2: 
            case 3: {
                flipH = !reversed;
            }
        }
        icon = topBlock ? this.iconTop[side] : this.iconBottom[side];
        icon.flip(flipH, flipV);
        return icon;
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_149691_a(side, Door.fullMetadata(world, x, y, z));
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        DoorTileEntity te = Door.getDoor((IBlockAccess)world, x, y, z);
        if (te == null) {
            return;
        }
        te.onBlockPlaced(this, itemStack);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer p, int par6, float par7, float par8, float par9) {
        DoorTileEntity te = Door.getDoor((IBlockAccess)world, x, y, z);
        if (te == null) {
            return true;
        }
        if (te.getDescriptor() == null) {
            return true;
        }
        if (te.getDescriptor().hasCode() && !te.isOpened()) {
            if (world.field_72995_K) {
                new DigicodeGui(te).display();
            }
            return true;
        }
        if (world.field_72995_K) {
            return true;
        }
        if (te.getDescriptor().requireRedstone()) {
            return true;
        }
        if (te.getDescriptor().getAutoCloseTime() > 0 && !te.isOpened()) {
            world.func_147464_a(x, y, z, (Block)this, te.getDescriptor().getAutoCloseTime() + te.getDescriptor().getOpeningTime());
        }
        te.openOrCloseDoor();
        return true;
    }

    public void func_150014_a(World world, int x, int y, int z, boolean opening) {
        DoorTileEntity te = Door.getDoor((IBlockAccess)world, x, y, z);
        if (te == null) {
            return;
        }
        if (te.getDescriptor().hasCode()) {
            return;
        }
        if (te.getDescriptor().requireRedstone()) {
            return;
        }
        if (opening && te.isOpened()) {
            return;
        }
        te.openOrCloseDoor();
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int metadata = world.func_72805_g(x, y, z);
        if ((metadata & 8) == 0) {
            boolean flag = false;
            ItemStack itemStack = this.getDoorItemStack((IBlockAccess)world, x, y, z);
            if (world.func_147439_a(x, y + 1, z) != this) {
                world.func_147468_f(x, y, z);
                flag = true;
            }
            if (!World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z)) {
                world.func_147468_f(x, y, z);
                flag = true;
                if (world.func_147439_a(x, y + 1, z) == this) {
                    world.func_147468_f(x, y + 1, z);
                }
            }
            if (flag) {
                if (!world.field_72995_K && itemStack != null) {
                    this.func_149642_a(world, x, y, z, itemStack);
                }
            } else {
                DoorTileEntity te = Door.getDoor((IBlockAccess)world, x, y, z);
                if (te == null) {
                    return;
                }
                if (te.getDescriptor() != null && te.getDescriptor().hasCode()) {
                    return;
                }
                boolean powered = te.isPowered();
                if ((powered || block.func_149744_f()) && block != this) {
                    te.setPowered(powered);
                }
                if (te.getDescriptor() == null) {
                    return;
                }
                boolean centered = te.shouldCenter();
                DoorTileEntity dd = te.getDoubleDoor();
                if (dd != null) {
                    dd.setCentered(centered |= dd.shouldCenter());
                }
                te.setCentered(centered);
            }
        } else {
            if (world.func_147439_a(x, y - 1, z) != this) {
                world.func_147468_f(x, y, z);
            }
            if (block != this) {
                this.func_149695_a(world, x, y - 1, z, block);
            }
        }
    }

    protected ItemStack getDoorItemStack(IBlockAccess world, int x, int y, int z) {
        return new ItemStack(this.descriptor.getItem(), 1);
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        return (metadata & 8) != 0 || this.descriptor == null ? null : this.descriptor.getItem();
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World worldIn, int x, int y, int z) {
        return this.descriptor.getItem();
    }

    public AxisAlignedBB[] getBoundingBox(IBlockAccess world, int x, int y, int z, BoundingBoxType type) {
        DoorTileEntity te = Door.getDoor(world, x, y, z);
        if (te == null || te.isMoving() || te.getMovement() == null) {
            return new AxisAlignedBB[0];
        }
        AxisAlignedBB aabb = te.getMovement().getBoundingBox(te, te.isTopBlock(x, y, z), type);
        if (aabb != null && te.isCentered()) {
            aabb.func_72317_d(0.0, 0.0, 0.40625);
        }
        AABBUtils.rotate((AxisAlignedBB)aabb, (ForgeDirection)Door.intToDir(te.getDirection()));
        return new AxisAlignedBB[]{aabb};
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity entity) {
        for (AxisAlignedBB aabb : this.getBoundingBox((IBlockAccess)world, x, y, z, BoundingBoxType.COLLISION)) {
            if (aabb == null || !mask.func_72326_a(aabb.func_72317_d((double)x, (double)y, (double)z))) continue;
            list.add(aabb);
        }
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 src, Vec3 dest) {
        return new RaytraceBlock(world, src, dest, x, y, z).trace();
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        Object[] aabbs = this.getBoundingBox((IBlockAccess)world, x, y, z, BoundingBoxType.SELECTION);
        if (ArrayUtils.isEmpty((Object[])aabbs) || aabbs[0] == null) {
            return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        return aabbs[0].func_72317_d((double)x, (double)y, (double)z);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        DoorTileEntity te = Door.getDoor((IBlockAccess)world, x, y, z);
        if (te == null) {
            return;
        }
        if (te.getDescriptor().getAutoCloseTime() <= 0) {
            return;
        }
        if (te.getState() == DoorState.CLOSED || te.getState() == DoorState.CLOSING) {
            return;
        }
        te.openOrCloseDoor();
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        Block b = world.func_147439_a(x + side.offsetX, y + side.offsetY, z + side.offsetZ);
        return ArrayUtils.contains((Object[])centerBlocks, (Object)b);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        DoorTileEntity te;
        if ((metadata & 8) != 0) {
            return null;
        }
        try {
            te = this.descriptor.getTileEntityClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            te = new DoorTileEntity();
        }
        te.setDescriptor(this.descriptor);
        return te;
    }

    public int func_149645_b() {
        return -1;
    }

    public static DoorTileEntity getDoor(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int metadata = Door.fullMetadata(world, x, y, z);
        if (block instanceof Door) {
            y -= (metadata & 8) != 0 ? 1 : 0;
        }
        return (DoorTileEntity)((Object)TileEntityUtils.getTileEntity(DoorTileEntity.class, (IBlockAccess)world, (int)x, (int)y, (int)z));
    }

    public static int fullMetadata(IBlockAccess world, int x, int y, int z) {
        int topMetadata;
        int bottomMetadata;
        boolean blockTop;
        Block block = world.func_147439_a(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (!(block instanceof BlockDoor)) {
            return metadata;
        }
        boolean bl = blockTop = (metadata & 8) != 0;
        if (blockTop) {
            bottomMetadata = world.func_72805_g(x, y - 1, z);
            topMetadata = metadata;
        } else {
            bottomMetadata = metadata;
            topMetadata = world.func_72805_g(x, y + 1, z);
        }
        boolean flag1 = (topMetadata & 1) != 0;
        return bottomMetadata & 7 | (blockTop ? 8 : 0) | (flag1 ? 16 : 0);
    }

    public static int dirToInt(ForgeDirection dir) {
        if (dir == ForgeDirection.NORTH) {
            return 1;
        }
        if (dir == ForgeDirection.EAST) {
            return 2;
        }
        if (dir == ForgeDirection.SOUTH) {
            return 3;
        }
        return 0;
    }

    public static ForgeDirection intToDir(int i) {
        if (i == 1) {
            return ForgeDirection.NORTH;
        }
        if (i == 2) {
            return ForgeDirection.EAST;
        }
        if (i == 3) {
            return ForgeDirection.SOUTH;
        }
        return ForgeDirection.WEST;
    }
}

