/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.inventory.gui;

import appeng.container.AEBaseContainer;
import appeng.container.ContainerOpenContext;
import com.glodblock.github.inventory.gui.IGuiFactory;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileGuiFactory<T>
implements IGuiFactory {
    protected final Class<T> invClass;

    TileGuiFactory(Class<T> invClass) {
        this.invClass = invClass;
    }

    @Nullable
    protected T getInventory(TileEntity tile, ForgeDirection face) {
        return this.invClass.isInstance(tile) ? (T)this.invClass.cast(tile) : null;
    }

    @Override
    @Nullable
    public Object createServerGui(EntityPlayer player, World world, int x, int y, int z, ForgeDirection face) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null) {
            return null;
        }
        T inv = this.getInventory(tile, face);
        if (inv == null) {
            return null;
        }
        Object gui = this.createServerGui(player, inv);
        if (gui instanceof AEBaseContainer) {
            ContainerOpenContext ctx = new ContainerOpenContext(inv);
            ctx.setWorld(world);
            ctx.setX(x);
            ctx.setY(y);
            ctx.setZ(z);
            ctx.setSide(face);
            ((AEBaseContainer)gui).setOpenContext(ctx);
        }
        return gui;
    }

    @Nullable
    protected abstract Object createServerGui(EntityPlayer var1, T var2);

    @Override
    @Nullable
    public Object createClientGui(EntityPlayer player, World world, int x, int y, int z, ForgeDirection face) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null) {
            return null;
        }
        T inv = this.getInventory(tile, face);
        return inv != null ? this.createClientGui(player, inv) : null;
    }

    @Nullable
    protected abstract Object createClientGui(EntityPlayer var1, T var2);
}

