/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.storage;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.exceptions.AppEngException;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import com.glodblock.github.common.storage.FluidCellInventory;
import com.glodblock.github.util.Util;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CreativeFluidCellInventory
extends FluidCellInventory {
    public CreativeFluidCellInventory(ItemStack o, ISaveProvider container) throws AppEngException {
        super(o, container);
    }

    @Override
    public IAEFluidStack injectItems(IAEFluidStack input, Actionable mode, BaseActionSource src) {
        if (input == null || input.getStackSize() == 0L) {
            return null;
        }
        if (this.cellType.isBlackListed(this.cellItem, input)) {
            return input;
        }
        if (this.getCellFluids().findPrecise((IAEStack)input) != null) {
            return null;
        }
        return input;
    }

    @Override
    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource src) {
        if (request == null) {
            return null;
        }
        if (this.getCellFluids().findPrecise((IAEStack)request) != null) {
            return request.copy();
        }
        return null;
    }

    @Override
    protected void loadCellFluids() {
        if (this.cellFluids == null) {
            this.cellFluids = AEApi.instance().storage().createFluidList();
        }
        this.cellFluids.resetStatus();
        IInventory inv = this.cellType.getConfigInventory(this.cellItem);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            IAEFluidStack iaeFluidStack;
            FluidStack fs;
            ItemStack is = inv.func_70301_a(i);
            if (!Util.FluidUtil.isFluidContainer(is) || (fs = Util.getFluidFromItem(is)) == null || this.cellFluids.findPrecise((IAEStack)(iaeFluidStack = Util.FluidUtil.createAEFluidStack(fs))) != null) continue;
            iaeFluidStack.setStackSize(Integer.MAX_VALUE);
            this.cellFluids.add((IAEStack)iaeFluidStack);
        }
    }
}

