/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import net.minecraft.item.ItemStack;

public class ProcessingFood
implements IOreRecipeRegistrator {
    public ProcessingFood() {
        OrePrefixes.food.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        switch (aOreDictName) {
            case "foodCheese": {
                this.registerSlicerRecipes(aStack);
                GT_OreDictUnificator.addItemData(aStack, new ItemData(Materials.Cheese, 3628800L, new MaterialStack[0]));
                break;
            }
            case "foodDough": {
                GT_ModHandler.removeFurnaceSmelting(aStack);
                this.registerBenderRecipes(aStack);
                this.registerMixerRecipes(aStack);
                this.registerFormingPressRecipes(aStack);
            }
        }
    }

    private void registerSlicerRecipes(ItemStack stack) {
        GT_Values.RA.stdBuilder().itemInputs(stack, ItemList.Shape_Slicer_Flat.get(0L, new Object[0])).itemOutputs(ItemList.Food_Sliced_Cheese.get(4L, new Object[0])).duration(64).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sSlicerRecipes);
    }

    private void registerBenderRecipes(ItemStack stack) {
        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, stack), GT_Utility.getIntegratedCircuit(1)).itemOutputs(ItemList.Food_Flat_Dough.get(1L, new Object[0])).duration(16).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sBenderRecipes);
    }

    private void registerMixerRecipes(ItemStack stack) {
        GT_Values.RA.stdBuilder().itemInputs(stack, GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Sugar, 1L)).itemOutputs(ItemList.Food_Dough_Sugar.get(2L, new Object[0])).duration(32).eut(8).addTo(GT_Recipe.GT_Recipe_Map.sMixerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(stack, GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Cocoa, 1L)).itemOutputs(ItemList.Food_Dough_Chocolate.get(2L, new Object[0])).duration(32).eut(8).addTo(GT_Recipe.GT_Recipe_Map.sMixerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(stack, GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Chocolate, 1L)).itemOutputs(ItemList.Food_Dough_Chocolate.get(2L, new Object[0])).duration(32).eut(8).addTo(GT_Recipe.GT_Recipe_Map.sMixerRecipes);
    }

    private void registerFormingPressRecipes(ItemStack stack) {
        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, stack), ItemList.Shape_Mold_Bun.get(0L, new Object[0])).itemOutputs(ItemList.Food_Raw_Bun.get(1L, new Object[0])).duration(128).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sPressRecipes);
        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(2L, stack), ItemList.Shape_Mold_Bread.get(0L, new Object[0])).itemOutputs(ItemList.Food_Raw_Bread.get(1L, new Object[0])).duration(256).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sPressRecipes);
        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, stack), ItemList.Shape_Mold_Baguette.get(0L, new Object[0])).itemOutputs(ItemList.Food_Raw_Baguette.get(1L, new Object[0])).duration(384).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sPressRecipes);
    }
}

