/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.objects.MaterialStack;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeBuilder;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_RecipeRegistrator;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ProcessingDust
implements IOreRecipeRegistrator {
    public ProcessingDust() {
        OrePrefixes.dust.add(this);
        OrePrefixes.dustPure.add(this);
        OrePrefixes.dustImpure.add(this);
        OrePrefixes.dustRefined.add(this);
        OrePrefixes.dustSmall.add(this);
        OrePrefixes.dustTiny.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        switch (aPrefix) {
            case dust: {
                ItemStack tDustStack;
                if (aMaterial.mFuelPower > 0) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack)).metadata(GT_RecipeConstants.FUEL_VALUE, aMaterial.mFuelPower).metadata(GT_RecipeConstants.FUEL_TYPE, aMaterial.mFuelType).duration(0).eut(0).addTo(GT_RecipeConstants.Fuel);
                }
                if (GT_Utility.getFluidForFilledItem(GT_OreDictUnificator.get(OrePrefixes.cell, aMaterial, 1L), true) == null && GT_OreDictUnificator.get(OrePrefixes.cell, aMaterial, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(aStack, ItemList.Cell_Empty.get(1L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.cell, aMaterial, 1L)).duration(100).eut(1).addTo(GT_Recipe.GT_Recipe_Map.sCannerRecipes);
                }
                if (!aMaterial.mBlastFurnaceRequired) {
                    GT_RecipeRegistrator.registerReverseFluidSmelting(aStack, aMaterial, aPrefix.mMaterialAmount, null);
                    if (aMaterial.mSmeltInto.mArcSmeltInto != aMaterial) {
                        GT_RecipeRegistrator.registerReverseArcSmelting(GT_Utility.copyAmount(1L, aStack), aMaterial, aPrefix.mMaterialAmount, null, null, null);
                    }
                }
                if (null != (tDustStack = GT_OreDictUnificator.get(OrePrefixes.ingot, aMaterial.mSmeltInto, 1L)) && !aMaterial.contains(SubTag.NO_SMELTING)) {
                    if (aMaterial.mBlastFurnaceRequired) {
                        GT_ModHandler.removeFurnaceSmelting(aStack);
                        if (aMaterial.mAutoGenerateBlastFurnaceRecipes) {
                            GT_RecipeBuilder recipeBuilder = GT_Values.RA.stdBuilder();
                            recipeBuilder.itemInputs(GT_Utility.copyAmount(1L, aStack), GT_Utility.getIntegratedCircuit(1));
                            if (aMaterial.mBlastFurnaceTemp > 1750) {
                                recipeBuilder.itemOutputs(GT_OreDictUnificator.get(OrePrefixes.ingotHot, (Object)aMaterial.mSmeltInto, tDustStack, 1L));
                            } else {
                                recipeBuilder.itemOutputs(GT_Utility.copyAmount(1L, tDustStack));
                            }
                            recipeBuilder.duration(Math.max(aMaterial.getMass() / 40L, 1L) * (long)aMaterial.mBlastFurnaceTemp * 1L).eut(TierEU.RECIPE_MV).metadata(GT_RecipeConstants.COIL_HEAT, Integer.valueOf(aMaterial.mBlastFurnaceTemp)).addTo(GT_Recipe.GT_Recipe_Map.sBlastRecipes);
                        }
                    } else {
                        GT_ModHandler.addSmeltingRecipe(aStack, tDustStack);
                    }
                } else if (!aMaterial.contains(SubTag.NO_WORKING)) {
                    if (!OrePrefixes.block.isIgnored(aMaterial) && null == GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L) && GT_OreDictUnificator.get(OrePrefixes.block, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(9L, aStack)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.block, aMaterial, 1L)).duration(300).eut(2).addTo(GT_Recipe.GT_Recipe_Map.sCompressorRecipes);
                    }
                    if ((OrePrefixes.block.isIgnored(aMaterial) || null == GT_OreDictUnificator.get(OrePrefixes.block, aMaterial, 1L)) && aMaterial != Materials.GraniteRed && aMaterial != Materials.GraniteBlack && aMaterial != Materials.Basalt && aMaterial != Materials.Marble && aMaterial != Materials.Glass && aMaterial != Materials.Obsidian && aMaterial != Materials.Glowstone && aMaterial != Materials.Paper && aMaterial != MaterialsUEVplus.TranscendentMetal && aMaterial != Materials.Clay && GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).duration(300).eut(2).addTo(GT_Recipe.GT_Recipe_Map.sCompressorRecipes);
                    }
                }
                if (aMaterial.mMaterialList.size() > 0 && (aMaterial.mExtraData & 3) != 0) {
                    long tItemAmount = 0L;
                    long tCapsuleCount = 0L;
                    long tDensityMultiplier = aMaterial.getDensity() > 3628800L ? aMaterial.getDensity() / 3628800L : 1L;
                    ArrayList<ItemStack> tList = new ArrayList<ItemStack>();
                    for (MaterialStack tMat : aMaterial.mMaterialList) {
                        if (tMat.mAmount <= 0L) continue;
                        if (tMat.mMaterial == Materials.Air) {
                            tDustStack = ItemList.Cell_Air.get(tMat.mAmount / 2L, new Object[0]);
                        } else {
                            tDustStack = GT_OreDictUnificator.get(OrePrefixes.dust, tMat.mMaterial, tMat.mAmount);
                            if (tDustStack == null) {
                                tDustStack = GT_OreDictUnificator.get(OrePrefixes.cell, tMat.mMaterial, tMat.mAmount);
                            }
                        }
                        if (tItemAmount + tMat.mAmount * 3628800L > (long)aStack.func_77976_d() * aMaterial.getDensity()) continue;
                        tItemAmount += tMat.mAmount * 3628800L;
                        if (tDustStack == null) continue;
                        tDustStack.field_77994_a = (int)((long)tDustStack.field_77994_a * tDensityMultiplier);
                        while (tDustStack.field_77994_a > 64 && tList.size() < 6 && tCapsuleCount + (long)GT_ModHandler.getCapsuleCellContainerCount(tDustStack) * 64L <= 64L) {
                            tCapsuleCount += (long)GT_ModHandler.getCapsuleCellContainerCount(tDustStack) * 64L;
                            tList.add(GT_Utility.copyAmount(64L, tDustStack));
                            tDustStack.field_77994_a -= 64;
                        }
                        if (tDustStack.field_77994_a <= 0 || tList.size() >= 6 || tCapsuleCount + (long)GT_ModHandler.getCapsuleCellContainerCountMultipliedWithStackSize(tDustStack) > 64L) continue;
                        tCapsuleCount += (long)GT_ModHandler.getCapsuleCellContainerCountMultipliedWithStackSize(tDustStack);
                        tList.add(tDustStack);
                    }
                    tItemAmount = (long)(tItemAmount * tDensityMultiplier % aMaterial.getDensity() > 0L ? 1 : 0) + tItemAmount * tDensityMultiplier / aMaterial.getDensity();
                    if (tList.size() > 0) {
                        ItemStack[] outputsArray;
                        FluidStack tFluid = null;
                        int tList_sS = tList.size();
                        for (int i = 0; i < tList_sS; ++i) {
                            if (ItemList.Cell_Air.isStackEqual(tList.get(i)) || (tFluid = GT_Utility.getFluidForFilledItem((ItemStack)tList.get(i), true)) == null) continue;
                            tFluid.amount *= ((ItemStack)tList.get((int)i)).field_77994_a;
                            tCapsuleCount -= (long)GT_ModHandler.getCapsuleCellContainerCountMultipliedWithStackSize((ItemStack)tList.get(i));
                            tList.remove(i);
                            break;
                        }
                        if ((aMaterial.mExtraData & 1) != 0 && (tList.size() > 0 || tFluid != null)) {
                            GT_RecipeBuilder recipeBuilder = GT_Values.RA.stdBuilder();
                            if (tCapsuleCount > 0L) {
                                recipeBuilder.itemInputs(GT_Utility.copyAmount(tItemAmount, aStack), ItemList.Cell_Empty.get(tCapsuleCount, new Object[0]));
                            } else {
                                recipeBuilder.itemInputs(GT_Utility.copyAmount(tItemAmount, aStack));
                            }
                            if (tList.size() > 0) {
                                outputsArray = tList.toArray(new ItemStack[Math.min(tList.size(), 6)]);
                                recipeBuilder.itemOutputs(outputsArray);
                            }
                            if (tFluid != null) {
                                recipeBuilder.fluidOutputs(tFluid);
                            }
                            recipeBuilder.duration(Math.max(1L, Math.abs(aMaterial.getProtons() * 2L * tItemAmount))).eut(Math.min(4, tList.size()) * 30).addTo(GT_Recipe.GT_Recipe_Map.sElectrolyzerRecipes);
                        }
                        if ((aMaterial.mExtraData & 2) != 0 && (tList.size() > 0 || tFluid != null)) {
                            GT_RecipeBuilder recipeBuilder = GT_Values.RA.stdBuilder();
                            if (tCapsuleCount > 0L) {
                                recipeBuilder.itemInputs(GT_Utility.copyAmount(tItemAmount, aStack), ItemList.Cell_Empty.get(tCapsuleCount, new Object[0]));
                            } else {
                                recipeBuilder.itemInputs(GT_Utility.copyAmount(tItemAmount, aStack));
                            }
                            if (tList.size() > 0) {
                                outputsArray = tList.toArray(new ItemStack[Math.min(tList.size(), 6)]);
                                recipeBuilder.itemOutputs(outputsArray);
                            }
                            if (tFluid != null) {
                                recipeBuilder.fluidOutputs(tFluid);
                            }
                            recipeBuilder.duration(Math.max(1L, Math.abs(aMaterial.getMass() * 4L * tItemAmount))).eut(Math.min(4, tList.size()) * 5).addTo(GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes);
                        }
                    }
                }
                if (aMaterial.contains(SubTag.CRYSTALLISABLE) && GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), GT_Utility.getIntegratedCircuit(1)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L)).outputChances(7000).fluidInputs(Materials.Water.getFluid(200L)).duration(2000).eut(24).addTo(GT_Recipe.GT_Recipe_Map.sAutoclaveRecipes);
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), GT_Utility.getIntegratedCircuit(2)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L)).outputChances(9000).fluidInputs(GT_ModHandler.getDistilledWater(100L)).duration(1500).eut(24).addTo(GT_Recipe.GT_Recipe_Map.sAutoclaveRecipes);
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), GT_Utility.getIntegratedCircuit(3)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L)).outputChances(10000).fluidInputs(Materials.Void.getMolten(36L)).duration(1200).eut(24).addTo(GT_Recipe.GT_Recipe_Map.sAutoclaveRecipes);
                }
                switch (aMaterial.mName) {
                    case "NULL": 
                    case "Mercury": 
                    case "Coal": {
                        break;
                    }
                    case "Glass": {
                        GT_ModHandler.addSmeltingRecipe(GT_Utility.copyAmount(1L, aStack), new ItemStack(Blocks.field_150359_w));
                        break;
                    }
                    case "NetherQuartz": 
                    case "Quartz": 
                    case "CertusQuartz": {
                        if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Recipes.disabledrecipes, "QuartzDustSmeltingIntoAESilicon", true)) break;
                        GT_ModHandler.removeFurnaceSmelting(aStack);
                        break;
                    }
                    case "MeatRaw": {
                        GT_ModHandler.addSmeltingRecipe(GT_Utility.copyAmount(1L, aStack), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.MeatCooked, 1L));
                        break;
                    }
                    case "Oilsands": {
                        GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.addRecipe(true, new ItemStack[]{GT_Utility.copyAmount(1L, aStack)}, null, null, null, new FluidStack[]{Materials.OilHeavy.getFluid(1000L)}, 660, 8, 0);
                        break;
                    }
                    case "HydratedCoal": {
                        GT_ModHandler.addSmeltingRecipe(GT_Utility.copyAmount(1L, aStack), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Coal, 1L));
                        break;
                    }
                    case "Diamond": {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(4L, aStack), ItemList.Block_Powderbarrel.get(64L, new Object[0])).itemOutputs(ItemList.IC2_Industrial_Diamond.get(3L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 16L)).duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(4L, aStack), GT_ModHandler.getIC2Item("dynamite", 16L, null)).itemOutputs(ItemList.IC2_Industrial_Diamond.get(3L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 16L)).duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(4L, aStack), new ItemStack(Blocks.field_150335_W, 32)).itemOutputs(ItemList.IC2_Industrial_Diamond.get(3L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 16L)).duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(4L, aStack), GT_ModHandler.getIC2Item("industrialTnt", 8L)).itemOutputs(ItemList.IC2_Industrial_Diamond.get(3L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 16L)).duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                        break;
                    }
                    case "Opal": 
                    case "Olivine": 
                    case "Emerald": 
                    case "Ruby": 
                    case "Sapphire": 
                    case "GreenSapphire": 
                    case "Topaz": 
                    case "BlueTopaz": 
                    case "Tanzanite": 
                    case "Amethyst": {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(4L, aStack), ItemList.Block_Powderbarrel.get(48L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 3L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 12L)).duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(4L, aStack), GT_ModHandler.getIC2Item("dynamite", 12L, null)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 3L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 12L)).duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(4L, aStack), new ItemStack(Blocks.field_150335_W, 24)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 3L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 12L)).duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(4L, aStack), GT_ModHandler.getIC2Item("industrialTnt", 6L)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 3L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 12L)).duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                        break;
                    }
                    case "FoolsRuby": 
                    case "GarnetRed": 
                    case "GarnetYellow": 
                    case "Jasper": 
                    case "Amber": 
                    case "Monazite": 
                    case "Forcicium": 
                    case "Forcillium": 
                    case "Force": {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(4L, aStack), ItemList.Block_Powderbarrel.get(32L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 3L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 8L)).duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(4L, aStack), GT_ModHandler.getIC2Item("dynamite", 8L, null)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 3L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 8L)).duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(4L, aStack), new ItemStack(Blocks.field_150335_W, 16)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 3L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 8L)).duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(4L, aStack), GT_ModHandler.getIC2Item("industrialTnt", 4L)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 3L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 8L)).duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
                    }
                }
                break;
            }
            case dustPure: 
            case dustImpure: 
            case dustRefined: {
                ItemStack tImpureStack;
                Materials tByProduct = GT_Utility.selectItemInList(aPrefix == OrePrefixes.dustRefined ? 2 : (aPrefix == OrePrefixes.dustPure ? 1 : 0), aMaterial, aMaterial.mOreByProducts);
                if (aPrefix == OrePrefixes.dustPure) {
                    if (aMaterial.contains(SubTag.ELECTROMAGNETIC_SEPERATION_GOLD)) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustSmall, Materials.Gold, 1L), GT_OreDictUnificator.get(OrePrefixes.nugget, Materials.Gold, 1L)).outputChances(10000, 4000, 2000).duration(400).eut(24).addTo(GT_Recipe.GT_Recipe_Map.sElectroMagneticSeparatorRecipes);
                    }
                    if (aMaterial.contains(SubTag.ELECTROMAGNETIC_SEPERATION_IRON)) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustSmall, Materials.Iron, 1L), GT_OreDictUnificator.get(OrePrefixes.nugget, Materials.Iron, 1L)).outputChances(10000, 4000, 2000).duration(400).eut(24).addTo(GT_Recipe.GT_Recipe_Map.sElectroMagneticSeparatorRecipes);
                    }
                    if (aMaterial.contains(SubTag.ELECTROMAGNETIC_SEPERATION_NEODYMIUM)) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustSmall, Materials.Neodymium, 1L), GT_OreDictUnificator.get(OrePrefixes.nugget, Materials.Neodymium, 1L)).outputChances(10000, 4000, 2000).duration(400).eut(24).addTo(GT_Recipe.GT_Recipe_Map.sElectroMagneticSeparatorRecipes);
                    }
                }
                if (aMaterial.contains(SubTag.CRYSTALLISABLE) && GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), GT_Utility.getIntegratedCircuit(1)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L)).outputChances(9000).fluidInputs(Materials.Water.getFluid(200L)).duration(2000).eut(24).addTo(GT_Recipe.GT_Recipe_Map.sAutoclaveRecipes);
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), GT_Utility.getIntegratedCircuit(2)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L)).outputChances(9500).fluidInputs(GT_ModHandler.getDistilledWater(100L)).duration(1500).eut(24).addTo(GT_Recipe.GT_Recipe_Map.sAutoclaveRecipes);
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), GT_Utility.getIntegratedCircuit(3)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L)).outputChances(10000).fluidInputs(Materials.Void.getMolten(36L)).duration(1200).eut(24).addTo(GT_Recipe.GT_Recipe_Map.sAutoclaveRecipes);
                }
                if ((tImpureStack = GT_OreDictUnificator.get(OrePrefixes.dustTiny, (Object)tByProduct, GT_OreDictUnificator.get(OrePrefixes.nugget, tByProduct, 1L), 1L)) == null) {
                    tImpureStack = GT_OreDictUnificator.get(OrePrefixes.dustSmall, tByProduct, 1L);
                    if (tImpureStack == null) {
                        tImpureStack = GT_OreDictUnificator.get(OrePrefixes.dust, (Object)tByProduct, GT_OreDictUnificator.get(OrePrefixes.gem, tByProduct, 1L), 1L);
                        if (tImpureStack == null) {
                            tImpureStack = GT_OreDictUnificator.get(OrePrefixes.cell, tByProduct, 1L);
                            if (tImpureStack == null) {
                                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L)).duration(Math.max(1L, aMaterial.getMass())).eut(5).addTo(GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes);
                                break;
                            }
                            FluidStack tFluid = GT_Utility.getFluidForFilledItem(tImpureStack, true);
                            if (tFluid == null) {
                                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(9L, aStack), ItemList.Cell_Empty.get(1L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 9L), tImpureStack).duration(Math.max(1L, aMaterial.getMass() * 72L)).eut(5).addTo(GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes);
                                break;
                            }
                            tFluid.amount /= 10;
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L)).fluidOutputs(tFluid).duration(Math.max(1L, aMaterial.getMass() * 8L)).eut(5).addTo(GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes);
                            break;
                        }
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(9L, aStack)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 9L), tImpureStack).duration(Math.max(1L, aMaterial.getMass() * 72L)).eut(5).addTo(GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes);
                        break;
                    }
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(2L, aStack)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 2L), tImpureStack).duration(Math.max(1L, aMaterial.getMass() * 16L)).eut(5).addTo(GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes);
                    break;
                }
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dust, (Object)tByProduct, GT_OreDictUnificator.get(OrePrefixes.nugget, tByProduct, 1L), 1L)).outputChances(10000, 1111).duration(Math.max(1L, aMaterial.getMass() * 8L)).eut(5).addTo(GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes);
                break;
            }
            case dustSmall: {
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(4L, aStack), ItemList.Schematic_Dust.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L)).duration(20).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sBoxinatorRecipes);
                if (aMaterial.mBlastFurnaceRequired) break;
                GT_RecipeRegistrator.registerReverseFluidSmelting(aStack, aMaterial, aPrefix.mMaterialAmount, null);
                if (aMaterial.mSmeltInto.mArcSmeltInto == aMaterial) break;
                GT_RecipeRegistrator.registerReverseArcSmelting(GT_Utility.copyAmount(1L, aStack), aMaterial, aPrefix.mMaterialAmount, null, null, null);
                break;
            }
            case dustTiny: {
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(9L, aStack), ItemList.Schematic_Dust.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L)).duration(20).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sBoxinatorRecipes);
                if (!aMaterial.mBlastFurnaceRequired) {
                    GT_RecipeRegistrator.registerReverseFluidSmelting(aStack, aMaterial, aPrefix.mMaterialAmount, null);
                    if (aMaterial.mSmeltInto.mArcSmeltInto != aMaterial) {
                        GT_RecipeRegistrator.registerReverseArcSmelting(GT_Utility.copyAmount(1L, aStack), aMaterial, aPrefix.mMaterialAmount, null, null, null);
                    }
                }
                if (aMaterial.contains(SubTag.NO_SMELTING) || !aMaterial.mBlastFurnaceRequired) break;
                GT_ModHandler.removeFurnaceSmelting(aStack);
                break;
            }
        }
    }
}

