/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.objects.MaterialStack;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeBuilder;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class ProcessingCell
implements IOreRecipeRegistrator {
    public ProcessingCell() {
        OrePrefixes.cell.add(this);
        OrePrefixes.cellPlasma.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        switch (aPrefix) {
            case cell: {
                ItemStack[] outputsArray;
                if (aMaterial == Materials.Empty) {
                    GT_ModHandler.removeRecipeByOutputDelayed(aStack);
                    if (!aModName.equalsIgnoreCase("AtomicScience")) break;
                    GT_ModHandler.addExtractionRecipe(ItemList.Cell_Empty.get(1L, new Object[0]), aStack);
                    break;
                }
                if (aMaterial.mFuelPower > 0) {
                    GT_RecipeBuilder recipeBuilder = GT_Values.RA.stdBuilder();
                    recipeBuilder.itemInputs(GT_Utility.copyAmount(1L, aStack));
                    if (GT_Utility.getFluidForFilledItem(aStack, true) == null && GT_Utility.getContainerItem(aStack, true) != null) {
                        recipeBuilder.itemOutputs(GT_Utility.getContainerItem(aStack, true));
                    }
                    recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, aMaterial.mFuelPower).metadata(GT_RecipeConstants.FUEL_TYPE, aMaterial.mFuelType).duration(0).eut(0).addTo(GT_RecipeConstants.Fuel);
                }
                if (aMaterial.mMaterialList.size() <= 0 || (aMaterial.mExtraData & 3) == 0) break;
                int tAllAmount = 0;
                for (MaterialStack tMat2 : aMaterial.mMaterialList) {
                    tAllAmount = (int)((long)tAllAmount + tMat2.mAmount);
                }
                long tItemAmount = 0L;
                long tCapsuleCount = (long)GT_ModHandler.getCapsuleCellContainerCountMultipliedWithStackSize(aStack) * (long)(-tAllAmount);
                long tDensityMultiplier = aMaterial.getDensity() > 3628800L ? aMaterial.getDensity() / 3628800L : 1L;
                ArrayList<ItemStack> tList = new ArrayList<ItemStack>();
                for (MaterialStack tMat : aMaterial.mMaterialList) {
                    ItemStack tStack;
                    if (tMat.mAmount <= 0L) continue;
                    if (tMat.mMaterial == Materials.Air) {
                        tStack = ItemList.Cell_Air.get(tMat.mAmount * tDensityMultiplier / 2L, new Object[0]);
                    } else {
                        tStack = GT_OreDictUnificator.get(OrePrefixes.dust, tMat.mMaterial, tMat.mAmount);
                        if (tStack == null) {
                            tStack = GT_OreDictUnificator.get(OrePrefixes.cell, tMat.mMaterial, tMat.mAmount);
                        }
                    }
                    if (tItemAmount + tMat.mAmount * 3628800L > (long)aStack.func_77976_d() * aMaterial.getDensity()) continue;
                    tItemAmount += tMat.mAmount * 3628800L;
                    if (tStack == null) continue;
                    tStack.field_77994_a = (int)((long)tStack.field_77994_a * tDensityMultiplier);
                    while (tStack.field_77994_a > 64 && (tCapsuleCount + (long)GT_ModHandler.getCapsuleCellContainerCount(tStack) * 64L < 0L ? tList.size() < 5 : tList.size() < 6) && tCapsuleCount + (long)GT_ModHandler.getCapsuleCellContainerCount(tStack) * 64L <= 64L) {
                        tCapsuleCount += (long)GT_ModHandler.getCapsuleCellContainerCount(tStack) * 64L;
                        tList.add(GT_Utility.copyAmount(64L, tStack));
                        tStack.field_77994_a -= 64;
                    }
                    int tThisCapsuleCount = GT_ModHandler.getCapsuleCellContainerCountMultipliedWithStackSize(tStack);
                    if (tStack.field_77994_a <= 0 || tCapsuleCount + (long)tThisCapsuleCount > 64L || !(tCapsuleCount + (long)tThisCapsuleCount < 0L ? tList.size() < 5 : tList.size() < 6)) continue;
                    tCapsuleCount += (long)tThisCapsuleCount;
                    tList.add(tStack);
                }
                tItemAmount = GT_Utility.ceilDiv(tItemAmount * tDensityMultiplier, aMaterial.getDensity());
                if (tList.size() <= 0) break;
                if ((aMaterial.mExtraData & 1) != 0) {
                    if (GT_Utility.getFluidForFilledItem(aStack, true) == null) {
                        GT_RecipeBuilder recipeBuilder = GT_Values.RA.stdBuilder();
                        if (tCapsuleCount > 0L) {
                            recipeBuilder.itemInputs(GT_Utility.copyAmount(tItemAmount, aStack), ItemList.Cell_Empty.get(tCapsuleCount, new Object[0]));
                        } else {
                            recipeBuilder.itemInputs(GT_Utility.copyAmount(tItemAmount, aStack));
                        }
                        if (tCapsuleCount < 0L) {
                            tList.add(ItemList.Cell_Empty.get(-tCapsuleCount, new Object[0]));
                        }
                        outputsArray = tList.toArray(new ItemStack[Math.min(tList.size(), 6)]);
                        recipeBuilder.itemOutputs(outputsArray).duration(Math.max(1L, Math.abs(aMaterial.getProtons() * 2L * tItemAmount))).eut(Math.min(4, tList.size()) * 30).addTo(GT_Recipe.GT_Recipe_Map.sElectrolyzerRecipes);
                    } else {
                        long tCellBalance = tCapsuleCount + tItemAmount - 1L;
                        GT_RecipeBuilder recipeBuilder = GT_Values.RA.stdBuilder();
                        if (tCellBalance > 0L) {
                            recipeBuilder.itemInputs(aStack, ItemList.Cell_Empty.get(tCellBalance, new Object[0]));
                        } else {
                            recipeBuilder.itemInputs(aStack);
                        }
                        if (tCellBalance < 0L) {
                            tList.add(ItemList.Cell_Empty.get(-tCellBalance, new Object[0]));
                        }
                        ItemStack[] outputsArray2 = tList.toArray(new ItemStack[Math.min(tList.size(), 6)]);
                        recipeBuilder.itemOutputs(outputsArray2).duration(Math.max(1L, Math.abs(aMaterial.getProtons() * 8L * tItemAmount))).eut(Math.min(4, tList.size()) * 30).addTo(GT_Recipe.GT_Recipe_Map.sElectrolyzerRecipes);
                    }
                }
                if ((aMaterial.mExtraData & 2) == 0) break;
                GT_RecipeBuilder recipeBuilder = GT_Values.RA.stdBuilder();
                if (tCapsuleCount > 0L) {
                    recipeBuilder.itemInputs(GT_Utility.copyAmount(tItemAmount, aStack), ItemList.Cell_Empty.get(tCapsuleCount, new Object[0]));
                } else {
                    recipeBuilder.itemInputs(GT_Utility.copyAmount(tItemAmount, aStack));
                }
                if (tCapsuleCount < 0L) {
                    tList.add(ItemList.Cell_Empty.get(-tCapsuleCount, new Object[0]));
                }
                outputsArray = tList.toArray(new ItemStack[Math.min(tList.size(), 6)]);
                recipeBuilder.itemOutputs(outputsArray).duration(Math.max(1L, Math.abs(aMaterial.getMass() * 2L * tItemAmount))).eut(5).addTo(GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes);
                break;
            }
            case cellPlasma: {
                if (aMaterial == Materials.Empty) {
                    GT_ModHandler.removeRecipeByOutputDelayed(aStack);
                    break;
                }
                GT_RecipeBuilder recipeBuilder = GT_Values.RA.stdBuilder();
                recipeBuilder.itemInputs(GT_Utility.copyAmount(1L, aStack));
                if (GT_Utility.getFluidForFilledItem(aStack, true) == null && GT_Utility.getContainerItem(aStack, true) != null) {
                    recipeBuilder.itemOutputs(GT_Utility.getContainerItem(aStack, true));
                }
                switch (aMaterial.mName) {
                    case "Tin": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 150000).metadata(GT_RecipeConstants.FUEL_TYPE, 4).duration(0).eut(0).addTo(GT_RecipeConstants.Fuel);
                    }
                }
                recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, (int)Math.max(1024L, 1024L * aMaterial.getMass())).metadata(GT_RecipeConstants.FUEL_TYPE, 4).duration(0).eut(0).addTo(GT_RecipeConstants.Fuel);
                if (GT_OreDictUnificator.get(OrePrefixes.cell, aMaterial, 1L) == null) break;
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.cell, aMaterial, 1L)).duration((int)Math.max(aMaterial.getMass() * 2L, 1L) * 1).eut(TierEU.RECIPE_MV).addTo(GT_Recipe.GT_Recipe_Map.sVacuumRecipes);
                break;
            }
        }
    }
}

