/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.api.recipes.RecipeManagers;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.TierEU;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeBuilder;
import gregtech.common.items.DropType;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ItemDrop
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon secondIcon;

    public ItemDrop() {
        this.func_77637_a(Tabs.tabApiculture);
        this.func_77627_a(true);
        this.func_77655_b("gt.drop");
        GameRegistry.registerItem((Item)this, (String)"gt.drop", (String)Mods.GregTech.ID);
    }

    public ItemStack getStackForType(DropType type) {
        return new ItemStack((Item)this, 1, type.ordinal());
    }

    public ItemStack getStackForType(DropType type, int count) {
        return new ItemStack((Item)this, count, type.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List<ItemStack> list) {
        for (DropType type : DropType.values()) {
            if (!type.showInList) continue;
            list.add(this.getStackForType(type));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int meta) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("forestry:honeyDrop.0");
        this.secondIcon = iconRegister.func_94245_a("forestry:honeyDrop.1");
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return pass == 0 ? this.field_77791_bV : this.secondIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        int meta = Math.max(0, Math.min(DropType.values().length - 1, stack.func_77960_j()));
        int colour = DropType.values()[meta].getColours()[0];
        if (pass >= 1) {
            colour = DropType.values()[meta].getColours()[1];
        }
        return colour;
    }

    public String func_77653_i(ItemStack stack) {
        return DropType.values()[stack.func_77960_j()].getName();
    }

    public void initDropsRecipes() {
        ItemStack tDrop = this.getStackForType(DropType.OIL);
        this.addProcessLV(tDrop, Materials.OilHeavy.getFluid(100L), GT_ModHandler.getModItem(Mods.Forestry.ID, "propolis", 1L, 0), 3000, 8);
        RecipeManagers.squeezerManager.addRecipe(40, new ItemStack[]{tDrop}, Materials.OilHeavy.getFluid(100L), GT_ModHandler.getModItem(Mods.Forestry.ID, "propolis", 1L, 0), 30);
        tDrop = this.getStackForType(DropType.COOLANT);
        this.addProcessLV(tDrop, new FluidStack(FluidRegistry.getFluid((String)"ic2coolant"), 100), GT_ModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 0), 3000, 8);
        RecipeManagers.squeezerManager.addRecipe(40, new ItemStack[]{tDrop}, new FluidStack(FluidRegistry.getFluid((String)"ic2coolant"), 100), GT_ModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 0), 30);
        tDrop = this.getStackForType(DropType.HOT_COOLANT);
        this.addProcessLV(tDrop, new FluidStack(FluidRegistry.getFluid((String)"ic2hotcoolant"), 100), GT_ModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 2), 3000, 8);
        RecipeManagers.squeezerManager.addRecipe(40, new ItemStack[]{tDrop}, new FluidStack(FluidRegistry.getFluid((String)"ic2hotcoolant"), 100), GT_ModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 2), 30);
        tDrop = this.getStackForType(DropType.SNOW_QUEEN);
        this.addProcessMV(tDrop, Materials.FierySteel.getFluid(200L), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.SnowQueenBloodDrop", 1L, 0), 1500, 48);
        tDrop = this.getStackForType(DropType.LAPIS);
        this.addProcessLV(tDrop, new FluidStack(FluidRegistry.getFluid((String)"ic2coolant"), 200), GT_ModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 3), 5000, 1200, 2);
        RecipeManagers.squeezerManager.addRecipe(400, new ItemStack[]{tDrop}, new FluidStack(FluidRegistry.getFluid((String)"ic2coolant"), 100), GT_ModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 3), 30);
        tDrop = this.getStackForType(DropType.HYDRA);
        this.addProcessMV(tDrop, Materials.FierySteel.getFluid(50L), GT_ModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 2), 3000, 8);
        tDrop = this.getStackForType(DropType.OXYGEN);
        this.addProcessLV(tDrop, new FluidStack(FluidRegistry.getFluid((String)"liquidoxygen"), 100), GT_ModHandler.getModItem(Mods.ExtraBees.ID, "propolis", 1L, 2), 250, 1200, 8);
        RecipeManagers.squeezerManager.addRecipe(400, new ItemStack[]{tDrop}, new FluidStack(FluidRegistry.getFluid((String)"ic2coolant"), 100), GT_ModHandler.getModItem(Mods.ExtraBees.ID, "propolis", 1L, 2), 30);
        tDrop = this.getStackForType(DropType.ENDERGOO);
        if (Mods.HardcoreEnderExpansion.isModLoaded()) {
            this.addProcessHV(tDrop, new FluidStack(FluidRegistry.getFluid((String)"endergoo"), 500), GT_Values.NI, 1000);
        }
    }

    public void addProcessLV(ItemStack tDrop, FluidStack aOutput, ItemStack aOutput2, int aChance, int aEUt) {
        GT_Values.RA.stdBuilder().itemInputs(tDrop).itemOutputs(aOutput2).outputChances(aChance).fluidOutputs(aOutput).duration(32).eut(aEUt).addTo(GT_Recipe.GT_Recipe_Map.sFluidExtractionRecipes);
    }

    public void addProcessLV(ItemStack tDrop, FluidStack aOutput, ItemStack aOutput2, int aChance, int aDuration, int aEUt) {
        GT_Values.RA.stdBuilder().itemInputs(tDrop).itemOutputs(aOutput2).outputChances(aChance).fluidOutputs(aOutput).duration(aDuration).eut(aEUt).addTo(GT_Recipe.GT_Recipe_Map.sFluidExtractionRecipes);
    }

    public void addProcessMV(ItemStack tDrop, FluidStack aOutput, ItemStack aOutput2, int aChance, int aEUt) {
        GT_Values.RA.stdBuilder().itemInputs(tDrop).itemOutputs(aOutput2).outputChances(aChance).fluidOutputs(aOutput).duration(128).eut(aEUt).addTo(GT_Recipe.GT_Recipe_Map.sFluidExtractionRecipes);
    }

    public void addProcessHV(ItemStack tDrop, FluidStack aOutput, ItemStack aOutput2, int aChance) {
        GT_RecipeBuilder recipeBuilder = GT_Values.RA.stdBuilder();
        recipeBuilder.itemInputs(tDrop);
        if (aOutput2 != GT_Values.NI) {
            recipeBuilder.itemOutputs(aOutput2).outputChances(aChance);
        }
        recipeBuilder.fluidOutputs(aOutput).duration(480).eut(TierEU.RECIPE_HV).addTo(GT_Recipe.GT_Recipe_Map.sFluidExtractionRecipes);
    }
}

