/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.Loader;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.IGT_RecipeMap;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeBuilder;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GT_RecipeMapUtil {
    public static final Function<GT_Recipe, GT_Recipe> ALL_FAKE_RECIPE = r -> {
        r.mFakeRecipe = true;
        return r;
    };
    public static final Function<GT_Recipe, String> FIRST_FLUID_INPUT = r -> GT_Utility.isArrayEmptyOrNull(r.mFluidInputs) ? null : r.mFluidInputs[0].getFluid().getName();
    public static final Function<GT_Recipe, String> FIRST_FLUID_OUTPUT = r -> GT_Utility.isArrayEmptyOrNull(r.mFluidInputs) ? null : r.mFluidOutputs[0].getFluid().getName();
    public static final Function<GT_Recipe, String> FIRST_FLUIDSTACK_INPUT = r -> GT_Utility.isArrayEmptyOrNull(r.mFluidInputs) ? null : r.mFluidInputs[0].getUnlocalizedName();
    public static final Function<GT_Recipe, String> FIRST_FLUIDSTACK_OUTPUT = r -> GT_Utility.isArrayEmptyOrNull(r.mFluidOutputs) ? null : r.mFluidOutputs[0].getUnlocalizedName();
    public static final Function<GT_Recipe, String> FIRST_ITEM_INPUT = r -> GT_Utility.isArrayEmptyOrNull(r.mInputs) ? null : GT_Config.getStackConfigName(r.mInputs[0]);
    public static final Function<GT_Recipe, String> FIRST_ITEM_OUTPUT = r -> GT_Utility.isArrayEmptyOrNull(r.mOutputs) ? null : GT_Config.getStackConfigName(r.mOutputs[0]);
    public static final Function<GT_Recipe, String> FIRST_ITEM_OR_FLUID_INPUT = r -> GT_Utility.isArrayEmptyOrNull(r.mInputs) ? (GT_Utility.isArrayEmptyOrNull(r.mFluidInputs) ? null : r.mFluidInputs[0].getFluid().getName()) : GT_Config.getStackConfigName(r.mInputs[0]);
    public static final Function<GT_Recipe, String> FIRST_ITEM_OR_FLUID_OUTPUT = r -> GT_Utility.isArrayEmptyOrNull(r.mOutputs) ? (GT_Utility.isArrayEmptyOrNull(r.mFluidOutputs) ? null : r.mFluidOutputs[0].getFluid().getName()) : GT_Config.getStackConfigName(r.mOutputs[0]);
    private static final Map<String, IGT_RecipeMap> addonRecipeMaps = new HashMap<String, IGT_RecipeMap>();
    private static final Multimap<String, Consumer<IGT_RecipeMap>> delayedActions = ArrayListMultimap.create();
    public static final Set<GT_RecipeBuilder.MetadataIdentifier<Integer>> SPECIAL_VALUE_ALIASES = new HashSet<GT_RecipeBuilder.MetadataIdentifier<Integer>>();

    public static <T> T[] appendArray(T[] arr, T val) {
        T[] newArr = Arrays.copyOf(arr, arr.length + 1);
        newArr[arr.length] = val;
        return newArr;
    }

    public static GT_RecipeTemplate asTemplate(GT_Recipe r) {
        return GT_RecipeMapUtil.asTemplate(r, false);
    }

    public static GT_RecipeTemplate asTemplate(GT_Recipe r, boolean includeTemplate) {
        return new GT_RecipeTemplate(r, includeTemplate);
    }

    public static List<GT_Recipe> buildRecipeForMultiblock(GT_RecipeBuilder b) {
        return GT_RecipeMapUtil.buildOrEmpty(GT_RecipeMapUtil.convertCellToFluid(b, true));
    }

    public static List<GT_Recipe> buildRecipeForMultiblockNoCircuit(GT_RecipeBuilder b) {
        return GT_RecipeMapUtil.buildOrEmpty(GT_RecipeMapUtil.convertCellToFluid(b, false));
    }

    public static GT_RecipeBuilder convertCellToFluid(GT_RecipeBuilder b, boolean removeIntegratedCircuit) {
        ArrayList<ItemStack> itemInputs = new ArrayList<ItemStack>(Arrays.asList(b.getItemInputsBasic()));
        ArrayList<ItemStack> itemOutputs = new ArrayList<ItemStack>(Arrays.asList(b.getItemOutputs()));
        ArrayList<FluidStack> fluidInputs = new ArrayList<FluidStack>(Arrays.asList(b.getFluidInputs()));
        ArrayList<FluidStack> fluidOutputs = new ArrayList<FluidStack>(Arrays.asList(b.getFluidOutputs()));
        TIntArrayList chances = b.getChances() != null ? new TIntArrayList(b.getChances()) : null;
        GT_RecipeMapUtil.cellToFluid(itemInputs, fluidInputs, removeIntegratedCircuit, null);
        GT_RecipeMapUtil.cellToFluid(itemOutputs, fluidOutputs, removeIntegratedCircuit, (TIntList)chances);
        itemInputs.removeIf(Objects::isNull);
        if (chances == null) {
            itemOutputs.removeIf(Objects::isNull);
        }
        fluidInputs.removeIf(Objects::isNull);
        fluidOutputs.removeIf(Objects::isNull);
        b.itemInputs(itemInputs.toArray(new ItemStack[0]));
        b.itemOutputs(itemOutputs.toArray(new ItemStack[0]), chances != null ? chances.toArray() : null);
        b.fluidInputs(fluidInputs.toArray(new FluidStack[0]));
        b.fluidOutputs(fluidOutputs.toArray(new FluidStack[0]));
        return b;
    }

    private static void cellToFluid(List<ItemStack> items, List<FluidStack> fluids, boolean removeIntegratedCircuit, TIntList chances) {
        for (int i = items.size() - 1; i >= 0; --i) {
            ItemStack item = items.get(i);
            if (GT_Utility.getFluidForFilledItem(item, true) == null && !GT_Utility.isCellEmpty(item) && (!removeIntegratedCircuit || !GT_Utility.isAnyIntegratedCircuit(item))) continue;
            fluids.add(GT_Utility.convertCellToFluid(item));
            items.remove(i);
            if (chances == null) continue;
            chances.removeAt(i);
        }
    }

    public static List<GT_Recipe> buildOrEmpty(GT_RecipeBuilder builder) {
        return builder.build().map(Collections::singletonList).orElse(Collections.emptyList());
    }

    public static void registerRecipeMap(String identifier, IGT_RecipeMap recipeMap, RecipeMapDependency ... dependencies) {
        String modId = Loader.instance().activeModContainer().getModId();
        if (Mods.GregTech.ID.equals(modId)) {
            throw new IllegalStateException("do not register recipe map under the name of gregtech! do it in your own preinit!");
        }
        String id = modId + "@" + identifier;
        addonRecipeMaps.put(id, recipeMap);
        for (Consumer action : delayedActions.get((Object)id)) {
            action.accept(recipeMap);
        }
    }

    public static void registerRecipesFor(String modid, String identifier, Consumer<IGT_RecipeMap> registerAction) {
        String id = modid + "@" + identifier;
        IGT_RecipeMap map = addonRecipeMaps.get(id);
        if (map == null) {
            delayedActions.put((Object)id, registerAction);
        } else {
            registerAction.accept(map);
        }
    }

    public static final class GT_RecipeTemplate {
        private final GT_Recipe template;
        private final List<GT_Recipe> derivatives = new ArrayList<GT_Recipe>();

        private GT_RecipeTemplate(GT_Recipe template, boolean includeTemplate) {
            this.template = template;
            if (includeTemplate) {
                this.derivatives.add(template);
            }
        }

        public GT_Recipe derive() {
            GT_Recipe derived = this.template.copyShallow();
            this.derivatives.add(derived);
            return derived;
        }

        public List<GT_Recipe> getAll() {
            Set references = Collections.newSetFromMap(new IdentityHashMap());
            for (GT_Recipe r : this.derivatives) {
                if (!references.add(r.mInputs)) {
                    r.mInputs = (ItemStack[])r.mInputs.clone();
                }
                if (!references.add(r.mOutputs)) {
                    r.mOutputs = (ItemStack[])r.mOutputs.clone();
                }
                if (!references.add(r.mFluidInputs)) {
                    r.mFluidInputs = (FluidStack[])r.mFluidInputs.clone();
                }
                if (references.add(r.mFluidOutputs)) continue;
                r.mFluidOutputs = (FluidStack[])r.mFluidOutputs.clone();
            }
            return this.derivatives;
        }
    }

    public static final class RecipeMapDependency {
        private final IGT_RecipeMap obj;
        private final String id;

        public RecipeMapDependency(IGT_RecipeMap obj, String id) {
            this.obj = obj;
            this.id = id;
        }

        public static RecipeMapDependency create(String id) {
            return new RecipeMapDependency(null, id);
        }

        public static RecipeMapDependency create(IGT_RecipeMap obj) {
            return new RecipeMapDependency(obj, null);
        }
    }
}

